package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.BillAccbookSetEntity;
import com.ejianc.business.accplat.config.service.IBillAccbookSetService;
import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 会计平台设置-账簿映射规则
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billAccbookSet")
@Api(value = "会计平台设置-账簿映射规则", tags = {"会计平台设置-账簿映射规则"})
public class BillAccbookSetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillAccbookSetService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillAccbookSetVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BillAccbookSetVO saveOrUpdateVO) {
        BillAccbookSetEntity entity = BeanMapper.map(saveOrUpdateVO, BillAccbookSetEntity.class);
        service.saveOrUpdate(entity, false);
        BillAccbookSetVO vo = BeanMapper.map(entity, BillAccbookSetVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillAccbookSetVO> queryDetail(@RequestParam Long id) {
        BillAccbookSetEntity entity = service.selectById(id);
        BillAccbookSetVO vo = BeanMapper.map(entity, BillAccbookSetVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillAccbookSetVO> vos) {
        service.removeByIds(vos.stream().map(BillAccbookSetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillAccbookSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<BillAccbookSetEntity> page = service.queryPage(param, false);
        IPage<BillAccbookSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillAccbookSetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BillAccbookSetEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BIllAccbookSet-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBIllAccbookSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BillAccbookSetVO>> refBIllAccbookSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BillAccbookSetEntity> page = service.queryPage(param, false);
        IPage<BillAccbookSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillAccbookSetVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
