package com.ejianc.business.custransfer.sjyg;

import com.ejianc.business.accplat.consts.AccplatConsts;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.transfer.BaseVoucherTransferService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.vo.VoucherParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 凭证自定义转化-分包过程结算
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Slf4j
@Service("SJYG-SubSettleVoucherCusTransferService")
public class SJYGSubSettleVoucherCusTransferService extends BaseVoucherTransferService implements IVoucherTransferService {


    // 制单人ID取值字段
    private static final String MARKER_COLUMN = null;

    // 业务日期取值字段
    private static final String BUSINESS_DATE_COLUMN = "settleDate";

    // 来源单据URL-PC
    private static final String SRC_BILL_PC_URL = "srcBillPcUrl";

    // 来源单据主组织字段名
    private static final String SRC_BILL_ORG_COLUMN = "orgId";


    // 凭证类型ex01:记账
    private static final String VOUCHER_TYPE = "PRE001:记";

    // 汇率类型
    private static final String RATE_TYPE = "PRE001";

    // 币别
    private static final String CURRENCY_CODE = "HLTX01_SYS";


    // 借方 固定科目编码
    private static final String SUBJECT_CODE = "1002.01";

    private static final String DESCRIPTION_EXPRESSION = "projectName + '_' + billTypeName";


    // 贷方 科目分类编码
    private static final String SUBJECT_CONTRAST_CODE = "subSettle01";


    private static final String DESCRIPTION_EXPRESSION_VIEW = "手动录入摘要";

    // 金额字段
    private static final String MNY_EXPRESSION = "settleTaxMny";


    /**
     * @description: 将单据参数转化成原始凭证/财务凭证参数
     * @return
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public void transfer(VoucherParams voucherParams) {
        voucherParams.setIsGenerateOriginVoucherFlag(Boolean.FALSE);
        voucherParams.setIsGenerateFinanceVoucherFlag(Boolean.TRUE);
        VoucherTemplateVO voucherTemplateVO = new VoucherTemplateVO();
        // TODO 构建虚拟凭证模板vo
        voucherTemplateVO.setMarkerColumn(MARKER_COLUMN);
        voucherTemplateVO.setBusinessDateColumn(BUSINESS_DATE_COLUMN);
        voucherTemplateVO.setSrcBillPcUrl(SRC_BILL_PC_URL);
        voucherTemplateVO.setSrcBillOrgColumn(SRC_BILL_ORG_COLUMN);
        voucherTemplateVO.setVoucherType(VOUCHER_TYPE);
        voucherTemplateVO.setRateType(RATE_TYPE);
        voucherTemplateVO.setCurrencyCode(CURRENCY_CODE);

        List<VoucherTemplateDetailVO> templateDetailVOList = new ArrayList<>();
        // 借方分录 固定科目
        VoucherTemplateDetailVO debitDetailVO = new VoucherTemplateDetailVO();
        debitDetailVO.setDirectionFlag(AccplatConsts.DirectionFlag.DEBIT);
        debitDetailVO.setSubjectRuleFlag(AccplatConsts.SubjectRule.SUBJECT);
        debitDetailVO.setSubjectRuleCode(SUBJECT_CODE);
        // 放摘要表达式
        debitDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION);
        debitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(debitDetailVO);

        // 贷方分录 科目分类转化
        VoucherTemplateDetailVO crebitDetailVO = new VoucherTemplateDetailVO();
        crebitDetailVO.setDirectionFlag(AccplatConsts.DirectionFlag.CREBIT);
        crebitDetailVO.setSubjectRuleFlag(AccplatConsts.SubjectRule.SUBJECT_CONTRAST);
        crebitDetailVO.setSubjectRuleCode(SUBJECT_CONTRAST_CODE);
        // 放摘要字符串
        crebitDetailVO.setDescriptionExpressionView(DESCRIPTION_EXPRESSION_VIEW);
        crebitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(crebitDetailVO);

        voucherTemplateVO.setVoucherTemplateDetailList(templateDetailVOList);

        OriginVoucherVO originVoucherVO = transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVO(originVoucherVO);
        Map<String, Object> financeVoucher = transferFinanceVoucherByOriginVoucher(voucherParams, originVoucherVO);
        voucherParams.setFinanceVoucher(financeVoucher);
    }


}
