package com.ejianc.business.kingdee.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.kingdee.base.properties.KingDeeK3CloudProperties;
import com.ejianc.business.kingdee.base.response.RepoError;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.RepoRet;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;


/**
 * @description: 金蝶云星空单据操作基本处理
 * @author songlx
 * @date 2023/12/12
 * @version 1.0
 */
@Slf4j
@Component
public class KingDeeGalaxyInvokeHelper {

    @Resource
    KingDeeK3CloudProperties kingDeeK3CloudProperties;

    private static final String USER_AUTH = "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";

    // Cookie 值
    private static String CookieVal = null;

    private static Map map = new HashMap();

    static {
        map.put("Save",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc");
        map.put("BatchSave",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.BatchSave.common.kdsvc");
        map.put("View",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.View.common.kdsvc");
        map.put("Delete",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        map.put("ExecuteBillQuery",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc");


/*        map.put("Submit",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Submit.common.kdsvc");
        map.put("Audit",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Audit.common.kdsvc");
        map.put("UnAudit",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UnAudit.common.kdsvc");
        map.put("StatusConvert",
                "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.StatusConvert.common.kdsvc");*/
    }


    private HttpURLConnection initUrlConn(String url, JSONArray paras)
            throws Exception {
        URL postUrl = new URL(kingDeeK3CloudProperties.getServerUrl().concat(url));
        HttpURLConnection connection = (HttpURLConnection) postUrl
                .openConnection();
        if (CookieVal != null) {
            connection.setRequestProperty("Cookie", CookieVal);
        }
        if (!connection.getDoOutput()) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "application/json");
        DataOutputStream out = new DataOutputStream(
                connection.getOutputStream());

        UUID uuid = UUID.randomUUID();
        int hashCode = uuid.toString().hashCode();

        JSONObject jObj = new JSONObject();

        jObj.put("format", 1);
        jObj.put("useragent", "ApiClient");
        jObj.put("rid", hashCode);
        String parameters = chinaToUnicode(new Gson().toJson(paras));
        jObj.put("parameters", parameters);
        jObj.put("timestamp", new Date().toString());
        jObj.put("v", "1.0");

        out.writeBytes(jObj.toString());
        out.flush();
        out.close();

        return connection;
    }

    // Login
    public boolean Login() {
        boolean bResult = false;
        JSONArray jParas = new JSONArray();
        jParas.add(kingDeeK3CloudProperties.getDbId());// 帐套Id
        jParas.add(kingDeeK3CloudProperties.getUserName());// 用户名
        jParas.add(kingDeeK3CloudProperties.getPassword());// 密码
        jParas.add(kingDeeK3CloudProperties.getLcid());// 语言
        HttpURLConnection connection = null;
        try {
            connection = initUrlConn(USER_AUTH, jParas);
            // 获取Cookie
            String key = null;
            for (int i = 1; (key = connection.getHeaderFieldKey(i)) != null; i++) {
                if (key.equalsIgnoreCase("Set-Cookie")) {
                    String tempCookieVal = connection.getHeaderField(i);
                    if (tempCookieVal.startsWith("kdservice-sessionid")) {
                        CookieVal = tempCookieVal;
                        log.info("CookieVal:{}", CookieVal);
                        break;
                    }
                }
            }

            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            log.info(" ============================= ");
            log.info(" BaseK3InvokeHelper.Login Contents of post request ");
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                String sResult = new String(line.getBytes(), "utf-8");
                log.info(sResult);
                bResult = line.contains("\"LoginResultType\":1");
            }
            log.info(" ============================= ");
            log.info(" BaseK3InvokeHelper.Login Contents of post request ends ");
            log.info(" ============================= ");
            reader.close();

            connection.disconnect();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bResult;
    }

    // Save
    public RepoResult save(String formId, String content) {
        return invoke("Save", formId, content);
    }

    // BatchSave
    public RepoResult batchSave(String formId, String content) {
        return invoke("BatchSave", formId, content);
    }

    // View
    public RepoResult view(String formId, String content) {
        return invoke("View", formId, content);
    }

    // Delete
    public RepoResult delete(String formId, String content) {
        return invoke("Delete", formId, content);
    }


    public List<Map<String, Object>> executeBillQuery(String content, String fieldKeys) {
        return invokeQuery("ExecuteBillQuery", content, fieldKeys);
    }


    /*
        // Submit
        public void Submit(String formId, String content) {
            Invoke("Submit", formId, content);
        }

        // Audit
        public void Audit(String formId, String content) {
            Invoke("Audit", formId, content);
        }

        // UnAudit
        public void UnAudit(String formId, String content) {
            Invoke("UnAudit", formId, content);
        }

        // StatusConvert
        public void StatusConvert(String formId, String content) {
            Invoke("StatusConvert", formId, content);
        }


    */


    private RepoResult invoke(String deal, String formId, String content) {
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        jParas.add(formId);
        jParas.add(content);
        RepoResult repoResult = null;
        try {
            HttpURLConnection connectionInvoke = initUrlConn(sUrl, jParas);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));
            String line;
            log.info(" ============================= ");
            log.info("金蝶云星空接口发送参数:" + content);
            log.info(" ============================= ");
            String sResult = null;
            while ((line = reader.readLine()) != null) {
                sResult = new String(line.getBytes(), "utf-8");
                JSONObject jsonObject = JSONObject.parseObject(sResult);
                repoResult = DataConvertUtil.stringToObj(jsonObject.getString("Result"), RepoResult.class);
            }
            log.info(" ============================= ");
            log.info("金蝶云星空接口返回结果:" + DataConvertUtil.toPrettyFormat(sResult));
            log.info(" ============================= ");
            reader.close();
            connectionInvoke.disconnect();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return repoResult;
    }


    private List<Map<String, Object>> invokeQuery(String deal, String content, String fieldKeys) {
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        jParas.add(content);
        String json = null;
        try {
            HttpURLConnection connectionInvoke = initUrlConn(sUrl, jParas);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));
            String line;
            log.info(" ============================= ");
            log.info("金蝶云星空接口发送参数:" + content);
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                json = new String(line.getBytes(), "utf-8");
            }
            log.info(" ============================= ");
            log.info("金蝶云星空接口返回结果:" + DataConvertUtil.toPrettyFormat(json));
            log.info(" ============================= ");

            reader.close();
            connectionInvoke.disconnect();

        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            (new JsonParser()).parse(json).getAsJsonArray();
        } catch (Exception var6) {
            throw new BusinessException("json parse error, response: [" + json + "]", var6);
        }

        if (json.indexOf(",\"IsSuccess\":false,") > -1) {
            throw new BusinessException(this.loadErrorMsg(json));
        } else {
            return this.loadDataList(json, fieldKeys);
        }
    }

    String loadErrorMsg(String json) {
        if (json.startsWith("[[") && json.endsWith("]]")) {
            Gson gson = new Gson();
            return ((RepoError) ((RepoRet) gson.fromJson(json.substring(2, json.length() - 2), RepoRet.class)).getResult().getResponseStatus().getErrors().get(0)).getMessage();
        } else {
            return String.format("fail for ExecuteBillQuery:%s", json);
        }
    }

    public static Gson buildGson(Type type) {
        Gson gs = new Gson();
        K3CloudObjectTypeAdapter adapter = new K3CloudObjectTypeAdapter(gs);
        Gson gson = (new GsonBuilder()).registerTypeAdapter(type, adapter).create();
        return gson;
    }


    protected List<Map<String, Object>> loadDataList(String json, String fieldKeys) {
        List<Map<String, Object>> rets = new ArrayList();
        Gson gson = buildGson(ArrayList.class);
        List<ArrayList<Object>> rows = (List) gson.fromJson(json, rets.getClass());
        String[] fields = fieldKeys.split(",");
        Iterator var11 = rows.iterator();
        try {
            while (var11.hasNext()) {
                List<Object> darray = (List) var11.next();
                Map map = new HashMap<String, Object>();
                for (int i = 0; i < fields.length; ++i) {
                    map.put(fields[i], darray.get(i));
                }
                rets.add(map);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return rets;
    }


    /**
     * 把中文转成Unicode码
     *
     * @param str
     * @return
     */
    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); i++) {
            int chr1 = str.charAt(i);
            if (chr1 >= 19968 && chr1 <= 171941) {// 汉字范围 \u4e00-\u9fa5 (中文)
                result += "\\u" + Integer.toHexString(chr1);
            } else {
                result += str.charAt(i);
            }
        }
        return result;
    }

}