package com.ejianc.business.voucher.transfer;

import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.VoucherTemplateCacheProvider;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description: 公共凭证转化服务
 *
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service("commonVoucherTransferService")
public class CommonVoucherTransferService extends BaseVoucherTransferService implements IVoucherTransferService {


    @Autowired
    private VoucherTemplateCacheProvider voucherTemplateCacheProvider;


    /**
     * @description: 将单据参数转化成原始凭证/财务凭证参数
     * @return
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public void transfer(VoucherParams voucherParams) {
        voucherParams.setIsGenerateOriginVoucherFlag(getIsGenerateOriginVoucherFlag(voucherParams));
        voucherParams.setIsGenerateFinanceVoucherFlag(getIsGenerateFinanceVoucherFlag(voucherParams));
        VoucherTemplateVO voucherTemplateVO = voucherTemplateCacheProvider.loadTemplateFromCache(InvocationInfoProxy.getTenantid(), voucherParams.getBillTypeCode());
        OriginVoucherVO originVoucherVO = transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVO(originVoucherVO);
        Map<String, Object> financeVoucher = transferFinanceVoucherByOriginVoucher(voucherParams, originVoucherVO);
        voucherParams.setFinanceVoucher(financeVoucher);
    }


}
