/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.custransfer.sjyg;

import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.transfer.BaseVoucherTransferService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.vo.VoucherParams;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SJYG-SubSettleVoucherCusTransferService")
public class SJYGSubSettleVoucherCusTransferService
extends BaseVoucherTransferService
implements IVoucherTransferService {
    private static final Logger log = LoggerFactory.getLogger(SJYGSubSettleVoucherCusTransferService.class);
    private static final String MARKER_COLUMN = null;
    private static final String BUSINESS_DATE_COLUMN = "settleDate";
    private static final String SRC_BILL_PC_URL = "srcBillPcUrl";
    private static final String SRC_BILL_ORG_COLUMN = "orgId";
    private static final String VOUCHER_TYPE = "PRE001:\u8bb0";
    private static final String RATE_TYPE = "PRE001";
    private static final String CURRENCY_CODE = "HLTX01_SYS";
    private static final String SUBJECT_CODE = "1002.01";
    private static final String DESCRIPTION_EXPRESSION = "projectName + '_' + billTypeName";
    private static final String SUBJECT_CONTRAST_CODE = "subSettle01";
    private static final String DESCRIPTION_EXPRESSION_VIEW = "\u624b\u52a8\u5f55\u5165\u6458\u8981";
    private static final String MNY_EXPRESSION = "settleTaxMny";

    @Override
    public void transfer(VoucherParams voucherParams) {
        voucherParams.setIsGenerateOriginVoucherFlag(Boolean.FALSE);
        voucherParams.setIsGenerateFinanceVoucherFlag(Boolean.TRUE);
        VoucherTemplateVO voucherTemplateVO = new VoucherTemplateVO();
        voucherTemplateVO.setMarkerColumn(MARKER_COLUMN);
        voucherTemplateVO.setBusinessDateColumn(BUSINESS_DATE_COLUMN);
        voucherTemplateVO.setSrcBillPcUrl(SRC_BILL_PC_URL);
        voucherTemplateVO.setSrcBillOrgColumn(SRC_BILL_ORG_COLUMN);
        voucherTemplateVO.setVoucherType(VOUCHER_TYPE);
        voucherTemplateVO.setRateType(RATE_TYPE);
        voucherTemplateVO.setCurrencyCode(CURRENCY_CODE);
        ArrayList<VoucherTemplateDetailVO> templateDetailVOList = new ArrayList<VoucherTemplateDetailVO>();
        VoucherTemplateDetailVO debitDetailVO = new VoucherTemplateDetailVO();
        debitDetailVO.setDirectionFlag("debit");
        debitDetailVO.setSubjectRuleFlag("subject");
        debitDetailVO.setSubjectRuleCode(SUBJECT_CODE);
        debitDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION);
        debitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(debitDetailVO);
        VoucherTemplateDetailVO crebitDetailVO = new VoucherTemplateDetailVO();
        crebitDetailVO.setDirectionFlag("crebit");
        crebitDetailVO.setSubjectRuleFlag("subjectContrast");
        crebitDetailVO.setSubjectRuleCode(SUBJECT_CONTRAST_CODE);
        crebitDetailVO.setDescriptionExpressionView(DESCRIPTION_EXPRESSION_VIEW);
        crebitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(crebitDetailVO);
        voucherTemplateVO.setVoucherTemplateDetailList(templateDetailVOList);
        OriginVoucherVO originVoucherVO = this.transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVO(originVoucherVO);
        Map<String, Object> financeVoucher = this.transferFinanceVoucherByOriginVoucher(voucherParams, originVoucherVO);
        voucherParams.setFinanceVoucher(financeVoucher);
    }
}

