/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.config.service.IBillVoucherSetService;
import com.ejianc.business.accplat.config.vo.BillVoucherSetVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherBusinessService {
    private static final Logger log = LoggerFactory.getLogger(VoucherBusinessService.class);
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private IBillVoucherSetService billVoucherSetService;

    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        String financeSystemCode = "kingDeeGalaxy";
        voucherParams.setFinanceSystemCode(financeSystemCode);
        BillTypeVO billTypeVO = voucherParams.getBillTypeVO();
        Map billData = voucherParams.getBillData();
        billData.put("billTypeCode", billTypeVO.getBillCode());
        billData.put("billTypeName", billTypeVO.getBillName());
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        String serviceName = Optional.ofNullable(billVoucherSetVO.getCustomTransferServiceName()).orElse("commonVoucherTransferService");
        IVoucherTransferService voucherTransferService = this.voucherServiceFactory.getVoucherTransferService(serviceName);
        voucherTransferService.transfer(voucherParams);
        this.checkVoucherParams(voucherParams);
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue()) {
            OriginVoucherVO originVoucherVO = voucherParams.getOriginVoucherVO();
        }
        log.info(" ============================= ");
        log.info("\u91d1\u8776\u4e91\u661f\u7a7a\u63a5\u53e3save:" + DataConvertUtil.objToString((Object)voucherParams.getFinanceVoucher()));
        log.info(" ============================= ");
        if (voucherParams.getIsGenerateFinanceVoucherFlag().booleanValue()) {
            return this.getFinanceVoucherService(financeSystemCode).save(voucherParams);
        }
        return CommonResponse.success();
    }

    public CommonResponse<Map<String, Object>> get(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getFinanceSystemCode()).get(voucherInfo);
    }

    public CommonResponse del(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getFinanceSystemCode()).del(voucherInfo);
    }

    public Boolean isGenerateVoucher(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper voucherSetEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        voucherSetEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
        voucherSetEntityLambdaQueryWrapper.eq(BillVoucherSetEntity::getBillTypeCode, (Object)billTypeCode);
        BillVoucherSetEntity voucherSetEntity = (BillVoucherSetEntity)((Object)this.billVoucherSetService.getOne((Wrapper)voucherSetEntityLambdaQueryWrapper));
        if (voucherSetEntity != null) {
            voucherParams.setBillVoucherSetVO((BillVoucherSetVO)BeanMapper.map((Object)((Object)voucherSetEntity), BillVoucherSetVO.class));
            return voucherSetEntity.getEnabled() == 1;
        }
        return Boolean.FALSE;
    }

    private IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        return this.voucherServiceFactory.getFinanceVoucherService(systemCode);
    }

    private void checkVoucherParams(VoucherParams voucherParams) {
        Boolean isGenerateOriginVoucherFlag = voucherParams.getIsGenerateOriginVoucherFlag();
        Boolean isGenerateFinanceVoucherFlag = voucherParams.getIsGenerateFinanceVoucherFlag();
        OriginVoucherVO originVoucherVO = voucherParams.getOriginVoucherVO();
        Map financeVoucher = voucherParams.getFinanceVoucher();
        if (isGenerateOriginVoucherFlag.booleanValue() && originVoucherVO == null) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u539f\u59cb\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u4f46\u7f3a\u4e4f\u539f\u59cb\u51ed\u8bc1\u6570\u636e[originVoucher]");
        }
        if (isGenerateFinanceVoucherFlag.booleanValue() && financeVoucher == null) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u8d22\u52a1\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u7f3a\u4e4f\u8d22\u52a1\u51ed\u8bc1\u53c2\u6570[financeVoucher]");
        }
    }
}

