/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.transfer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.BillAccbookSetEntity;
import com.ejianc.business.accplat.config.bean.BillAuxiliarySetEntity;
import com.ejianc.business.accplat.config.bean.BillInfluenceSetEntity;
import com.ejianc.business.accplat.config.bean.SubjectEntity;
import com.ejianc.business.accplat.config.service.IBillAccbookSetService;
import com.ejianc.business.accplat.config.service.IBillAuxiliarySetService;
import com.ejianc.business.accplat.config.service.IBillInfluenceSetService;
import com.ejianc.business.accplat.config.service.ISubjectContrastService;
import com.ejianc.business.accplat.config.service.ISubjectService;
import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.config.vo.BillAuxiliarySetVO;
import com.ejianc.business.accplat.config.vo.BillInfluenceSetVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastDetailInfluenceVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastDetailVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.transfer.VoucherServiceFactory;
import com.ejianc.business.voucher.utils.AviatorUtil;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseVoucherTransferService {
    private static final Logger log = LoggerFactory.getLogger(BaseVoucherTransferService.class);
    @Autowired
    private VoucherServiceFactory voucherServiceFactory;
    @Autowired
    private IBillAccbookSetService billAccbookSetService;
    @Autowired
    private IBillInfluenceSetService billInfluenceSetService;
    @Autowired
    private IBillAuxiliarySetService billAuxiliarySetService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISubjectContrastService subjectContrastService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Autowired
    private CacheManager cacheManager;

    public <T> T executeBusinessExpression(String express, Map<String, Object> billData, String billTypeCode) {
        List columnNameList;
        if ((express.contains("_") || express.contains(".")) && CollectionUtils.isNotEmpty((Collection)(columnNameList = DataConvertUtil.getColumnNameList((String)express)))) {
            ArrayList<String> subTableKeyList = new ArrayList<String>();
            Map mdAttributeVOMap = null;
            String cacheKey = "mdattr" + billTypeCode;
            if (this.cacheManager.exists(cacheKey).booleanValue()) {
                mdAttributeVOMap = (Map)((Object)this.cacheManager.get(cacheKey));
            } else {
                CommonResponse attrMapRes = this.mdAttributeApi.getAttrMap(billTypeCode);
                mdAttributeVOMap = (Map)attrMapRes.getData();
            }
            for (String column : columnNameList) {
                MdAttributeVO mdAttributeVO = (MdAttributeVO)mdAttributeVOMap.get(column);
                if (mdAttributeVO == null) continue;
                String columnPos = mdAttributeVO.getColumnPos();
                if ("HR".equals(columnPos)) {
                    this.setRelationEntityValue(column, billData, billTypeCode, mdAttributeVOMap);
                    continue;
                }
                if (!"B".equals(columnPos)) continue;
                String[] subKeys = column.split(".");
                subTableKeyList.add(subKeys[0]);
            }
            if (subTableKeyList.size() > 1) {
                throw new BusinessException("\u5355\u636e\u7c7b\u578b\u7f16\u7801\u3010" + billTypeCode + "\u3011\u7684\u8868\u8fbe\u5f0f\u3010" + express + "\u3011\u4e2d\u8fd8\u6709\u81f3\u5c11\u4e24\u4e2a\u5b50\u8868\u952e\u503c\uff0c\u4e0d\u80fd\u6b63\u5e38\u89e3\u6790\u6570\u636e\uff01");
            }
            if (subTableKeyList.size() == 1) {
                String subTableKey = (String)subTableKeyList.get(0);
                String _subTableKey = "subData-" + subTableKey;
                ArrayList subDatas = new ArrayList();
                if (billData.containsKey(_subTableKey)) {
                    subDatas = (ArrayList)billData.get(_subTableKey);
                } else {
                    Object sub = billData.get(subTableKey);
                    if (sub != null) {
                        subDatas = (ArrayList)sub;
                        billData.put(_subTableKey, subDatas);
                    }
                }
                int a = 1;
                StringBuilder subExpress = new StringBuilder();
                HashMap subExecResMap = new HashMap();
                for (Map subData : subDatas) {
                    billData.put(subTableKey, subData);
                    Object oneSubExecObj = AviatorUtil.exec(express, billData);
                    String key = "oneSubRes" + a;
                    subExecResMap.put(key, oneSubExecObj);
                    subExpress.append(key);
                    if (a != subDatas.size()) {
                        if (oneSubExecObj instanceof Boolean) {
                            subExpress.append(" && ");
                        } else {
                            subExpress.append(" + ");
                        }
                    }
                    ++a;
                }
                express = subExpress.toString();
            }
        }
        Object exec = AviatorUtil.exec(express, billData);
        log.info("\u8868\u8fbe\u5f0f\u6267\u884c\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)express, exec);
        return exec;
    }

    private void setRelationEntityValue(String columnExpression, Map<String, Object> billData, String billTypeCode, Map<String, MdAttributeVO> mdAttributeVOMap) {
        String _headCol = columnExpression.substring(0, columnExpression.indexOf("."));
        String headCol = columnExpression.substring(1, columnExpression.indexOf("."));
        if (!billData.containsKey(_headCol)) {
            MdAttributeVO sourceAttributeVO = mdAttributeVOMap.get(headCol);
            Object execVal = AviatorUtil.exec(headCol, billData);
            CommonResponse mapCommonResponse = this.mdAttributeApi.queryRelationEntityValue(billTypeCode, sourceAttributeVO.getEntityId(), sourceAttributeVO.getId(), String.valueOf(execVal), null);
            billData.put(_headCol, mapCommonResponse.getData());
        }
    }

    public OriginVoucherVO transferOriginVoucherByVoucherTemplate(VoucherParams voucherParams, VoucherTemplateVO voucherTemplateVO) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Map billData = voucherParams.getBillData();
        Long orgId = Long.valueOf(String.valueOf(billData.get(voucherTemplateVO.getSrcBillOrgColumn())));
        Date businessDate = DataConvertUtil.getDate(billData.get(voucherTemplateVO.getBusinessDateColumn()));
        OriginVoucherVO originVoucherVO = new OriginVoucherVO();
        BillAccbookSetVO billAccbookSetVO = this.getBillAccbookSet(orgId, billTypeCode);
        log.info("billAccbookSetVO:{}", (Object)DataConvertUtil.toPrettyFormat((Object)billAccbookSetVO));
        originVoucherVO.setAccbookId(billAccbookSetVO.getAccbookId());
        originVoucherVO.setAccbookCode(billAccbookSetVO.getAccbookCode());
        originVoucherVO.setAccbookName(billAccbookSetVO.getAccbookName());
        originVoucherVO.setBusinessDate(businessDate);
        ArrayList<OriginVoucherEntryVO> entryList = new ArrayList<OriginVoucherEntryVO>();
        List voucherTemplateDetailList = voucherTemplateVO.getVoucherTemplateDetailList();
        for (VoucherTemplateDetailVO voucherTemplateDetailVO : voucherTemplateDetailList) {
            String subjectRuleFlag = voucherTemplateDetailVO.getSubjectRuleFlag();
            List<OriginVoucherEntryVO> list = null;
            list = "subjectContrast".equals(subjectRuleFlag) ? this.analysisEntryBySubjectContrast(billTypeCode, billData, voucherTemplateDetailVO, voucherTemplateVO) : this.analysisEntryBySubject(billTypeCode, billData, voucherTemplateDetailVO, voucherTemplateVO);
            entryList.addAll(list);
        }
        this.analysisAuxiliary(billTypeCode, billData, entryList);
        originVoucherVO.setOriginVoucherEntryList(entryList);
        return originVoucherVO;
    }

    public List<OriginVoucherEntryVO> analysisEntryBySubject(String billTypeCode, Map<String, Object> billData, VoucherTemplateDetailVO voucherTemplateDetailVO, VoucherTemplateVO voucherTemplateVO) {
        String subjectCode = voucherTemplateDetailVO.getSubjectRuleCode();
        String directionFlag = voucherTemplateDetailVO.getDirectionFlag();
        String description = voucherTemplateDetailVO.getDescriptionExpressionView();
        String descriptionExpression = voucherTemplateDetailVO.getDescriptionExpression();
        if (StringUtils.isNotBlank((CharSequence)descriptionExpression)) {
            description = (String)this.executeBusinessExpression(descriptionExpression, billData, billTypeCode);
        }
        String mnyExpression = voucherTemplateDetailVO.getMnyExpression();
        BigDecimal mny = (BigDecimal)this.executeBusinessExpression(mnyExpression, billData, billTypeCode);
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u56fa\u5b9a\u79d1\u76ee\u7f16\u7801\uff1a" + subjectCode + "\u3011=====start====================================");
        LinkedList<OriginVoucherEntryVO> entryVOList = new LinkedList<OriginVoucherEntryVO>();
        SubjectVO subject = this.getSubject(subjectCode);
        OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
        originVoucherEntryVO.setEntryDescription(description);
        originVoucherEntryVO.setSubjectId(subject.getId());
        originVoucherEntryVO.setSubjectCode(subject.getSubjectCode());
        originVoucherEntryVO.setSubjectName(subject.getSubjectName());
        originVoucherEntryVO.setDirectionFlag(directionFlag);
        if ("debit".equals(directionFlag)) {
            originVoucherEntryVO.setDebitOriginalMny(mny);
        } else {
            originVoucherEntryVO.setCrebitOriginalMny(mny);
        }
        originVoucherEntryVO.setRateType(voucherTemplateVO.getRateType());
        originVoucherEntryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
        entryVOList.add(originVoucherEntryVO);
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u56fa\u5b9a\u79d1\u76ee\u7f16\u7801\uff1a" + subjectCode + "\u3011=====end======================================");
        return entryVOList;
    }

    public List<OriginVoucherEntryVO> analysisEntryBySubjectContrast(String billTypeCode, Map<String, Object> billData, VoucherTemplateDetailVO voucherTemplateDetailVO, VoucherTemplateVO voucherTemplateVO) {
        String subjectCategoryCode = voucherTemplateDetailVO.getSubjectRuleCode();
        String directionFlag = voucherTemplateDetailVO.getDirectionFlag();
        String description = voucherTemplateDetailVO.getDescriptionExpressionView();
        String descriptionExpression = voucherTemplateDetailVO.getDescriptionExpression();
        if (StringUtils.isNotBlank((CharSequence)descriptionExpression)) {
            description = (String)this.executeBusinessExpression(descriptionExpression, billData, billTypeCode);
        }
        String mnyExpression = voucherTemplateDetailVO.getMnyExpression();
        BigDecimal mny = (BigDecimal)this.executeBusinessExpression(mnyExpression, billData, billTypeCode);
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====start====================================");
        LinkedList<OriginVoucherEntryVO> entriesList = new LinkedList<OriginVoucherEntryVO>();
        SubjectContrastVO subjectContrast = this.getSubjectContrast(null, subjectCategoryCode);
        List subjectContrastDetailList = subjectContrast.getSubjectContrastDetailList();
        String influenceIdsStr = subjectContrast.getInfluenceIds();
        if (StringUtils.isBlank((CharSequence)influenceIdsStr)) {
            throw new BusinessException("\u8be5\u79d1\u76ee\u5206\u7c7b\u3010\u7f16\u7801\uff1a" + subjectContrast.getSubjectCategoryCode() + "\u3011\u672a\u5b9a\u4e49\u5f71\u54cd\u56e0\u7d20\uff01");
        }
        String[] influenceIdsArr = influenceIdsStr.split(",");
        List<Long> influenceIds = Arrays.stream(influenceIdsArr).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<BillInfluenceSetVO> billInfluenceSetList = this.getBillInfluenceSet(billTypeCode, influenceIds);
        Map<Long, BillInfluenceSetVO> billInfluenceSetMap = billInfluenceSetList.stream().collect(Collectors.toMap(BillInfluenceSetVO::getInfluenceId, t -> t));
        if (CollectionUtils.isNotEmpty((Collection)subjectContrastDetailList)) {
            for (SubjectContrastDetailVO subjectContrastDetailVO : subjectContrastDetailList) {
                Long accountSubjectId = subjectContrastDetailVO.getAccountSubjectId();
                String accountSubjectCode = subjectContrastDetailVO.getAccountSubjectCode();
                String accountSubjectName = subjectContrastDetailVO.getAccountSubjectName();
                List subjectContrastDetailInfluenceList = subjectContrastDetailVO.getSubjectContrastDetailInfluenceList();
                LinkedList<String> expressionList = new LinkedList<String>();
                String expressionString = null;
                for (SubjectContrastDetailInfluenceVO subjectContrastDetailInfluenceVO : subjectContrastDetailInfluenceList) {
                    Long influenceId = subjectContrastDetailInfluenceVO.getInfluenceId();
                    String influenceValue = subjectContrastDetailInfluenceVO.getInfluenceValue();
                    BillInfluenceSetVO billInfluenceSetVO = billInfluenceSetMap.get(influenceId);
                    if (billInfluenceSetVO == null) {
                        throw new BusinessException("\u4f1a\u8ba1\u5e73\u53f0\u914d\u7f6e-\u5f71\u54cd\u56e0\u7d20\u3010ID\uff1a" + subjectContrastDetailInfluenceVO.getInfluenceId() + "\u3011\u672a\u914d\u7f6e\u5173\u8054\u5b57\u6bb5");
                    }
                    String columnExpression = billInfluenceSetVO.getColumnExpression();
                    String eqStringExpression = columnExpression + "==" + influenceValue;
                    expressionList.add(eqStringExpression);
                }
                expressionString = String.join((CharSequence)" && ", expressionList);
                boolean b = (Boolean)this.executeBusinessExpression(expressionString, billData, billTypeCode);
                if (!b) continue;
                OriginVoucherEntryVO entryVO = OriginVoucherEntryVO.getInstanceVO((String)directionFlag, (Long)accountSubjectId, (String)accountSubjectCode, (String)accountSubjectName);
                if ("debit".equals(directionFlag)) {
                    entryVO.setDebitOriginalMny(mny);
                } else {
                    entryVO.setCrebitOriginalMny(mny);
                }
                entryVO.setEntryDescription(description);
                entryVO.setRateType(voucherTemplateVO.getRateType());
                entryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
                entriesList.add(entryVO);
            }
        }
        if (CollectionUtils.isEmpty(entriesList)) {
            Long defaultSubjectId = subjectContrast.getDefaultSubjectId();
            String defaultSubjectCode = subjectContrast.getDefaultSubjectCode();
            String defaultSubjectName = subjectContrast.getDefaultSubjectName();
            OriginVoucherEntryVO entryVO = OriginVoucherEntryVO.getInstanceVO((String)directionFlag, (Long)defaultSubjectId, (String)defaultSubjectCode, (String)defaultSubjectName);
            if ("debit".equals(directionFlag)) {
                entryVO.setDebitOriginalMny(mny);
            } else {
                entryVO.setCrebitOriginalMny(mny);
            }
            entryVO.setEntryDescription(description);
            entryVO.setRateType(voucherTemplateVO.getRateType());
            entryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
            entriesList.add(entryVO);
        }
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====end======================================");
        return entriesList;
    }

    public void analysisAuxiliary(String billTypeCode, Map<String, Object> billData, List<OriginVoucherEntryVO> entriesList) {
        List<BillAuxiliarySetVO> billAuxiliarySet = this.getBillAuxiliarySet(billTypeCode);
        if (CollectionUtils.isEmpty(billAuxiliarySet)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "\u3011\u4f1a\u8ba1\u5e73\u53f0\u914d\u7f6e-\u8f85\u52a9\u6838\u7b97\u9879\u5173\u8054");
        }
        Map<Long, BillAuxiliarySetVO> auxiliarySetMap = billAuxiliarySet.stream().collect(Collectors.toMap(BillAuxiliarySetVO::getAuxiliaryId, dto2 -> dto2));
        for (OriginVoucherEntryVO entryVO : entriesList) {
            Long accsubjectId = entryVO.getSubjectId();
            SubjectEntity subjectEntity = (SubjectEntity)((Object)this.subjectService.selectById(accsubjectId));
            String auxiliaryIds = subjectEntity.getAuxiliaryIds();
            if (!StringUtils.isNotBlank((CharSequence)auxiliaryIds)) continue;
            LinkedList<OriginVoucherAuxiliaryVO> originVoucherAuxiliaryVOS = new LinkedList<OriginVoucherAuxiliaryVO>();
            for (String auxiliaryId : auxiliaryIds.split(",")) {
                Long _auxiliaryId = Long.valueOf(auxiliaryId);
                BillAuxiliarySetVO billAuxiliarySetVO = auxiliarySetMap.get(_auxiliaryId);
                String columnExpression = billAuxiliarySetVO.getColumnExpression();
                String referCode = billAuxiliarySetVO.getReferCode();
                Object auxiliaryIdObj = this.executeBusinessExpression(columnExpression, billData, billTypeCode);
                JSONObject auxiliaryValJson = this.getReferCodeValue(String.valueOf(auxiliaryIdObj), referCode);
                OriginVoucherAuxiliaryVO originVoucherAuxiliaryVO = new OriginVoucherAuxiliaryVO();
                originVoucherAuxiliaryVO.setAuxiliaryId(billAuxiliarySetVO.getAuxiliaryId());
                originVoucherAuxiliaryVO.setAuxiliaryCode(billAuxiliarySetVO.getAuxiliaryCode());
                originVoucherAuxiliaryVO.setAuxiliaryName(billAuxiliarySetVO.getAuxiliaryName());
                originVoucherAuxiliaryVO.setAuxiliaryValueId(auxiliaryValJson.getLong("id"));
                String codeVal = auxiliaryValJson.getString("code");
                originVoucherAuxiliaryVO.setAuxiliaryValueCode(codeVal);
                originVoucherAuxiliaryVO.setAuxiliaryValueName(auxiliaryValJson.getString("name"));
                originVoucherAuxiliaryVO.setAuxiliaryFsCode(billAuxiliarySetVO.getAuxiliaryCode());
                originVoucherAuxiliaryVO.setAuxiliaryFsValue(codeVal);
                originVoucherAuxiliaryVOS.add(originVoucherAuxiliaryVO);
            }
            entryVO.setOriginVoucherAuxiliaryVOList(originVoucherAuxiliaryVOS);
        }
    }

    public JSONObject getReferCodeValue(String value, String referCode) {
        try {
            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)value, (String)referCode);
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                return json;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, Object> transferFinanceVoucherByOriginVoucher(VoucherParams voucherParams, OriginVoucherVO originVoucherVO) {
        String systemCode = voucherParams.getFinanceSystemCode();
        IFinanceVoucherService financeVoucherService = this.voucherServiceFactory.getFinanceVoucherService(systemCode);
        return financeVoucherService.convertToFinanceVoucherByOriginVoucher(voucherParams, originVoucherVO);
    }

    public SubjectContrastVO getSubjectContrast(String subjectChartCode, String subjectCategoryCode) {
        return this.subjectContrastService.getOneBySubjectCategoryCode(subjectChartCode, subjectCategoryCode);
    }

    public SubjectVO getSubject(String subjectCode) {
        LambdaQueryWrapper subjectEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        subjectEntityLambdaQueryWrapper.eq(SubjectEntity::getSubjectCode, (Object)subjectCode);
        subjectEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        SubjectEntity one = (SubjectEntity)((Object)this.subjectService.getOne((Wrapper)subjectEntityLambdaQueryWrapper));
        return (SubjectVO)BeanMapper.map((Object)((Object)one), SubjectVO.class);
    }

    public List<BillAuxiliarySetVO> getBillAuxiliarySet(String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAuxiliarySetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billAuxiliarySetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u8f85\u52a9\u6838\u7b97\u9879\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillAuxiliarySetVO.class);
    }

    public List<BillInfluenceSetVO> getBillInfluenceSet(String billTypeCode, List<Long> influenceIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillInfluenceSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.in(CollectionUtils.isNotEmpty(influenceIds), BillInfluenceSetEntity::getInfluenceId, influenceIds);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billInfluenceSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u5f71\u54cd\u56e0\u7d20\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillInfluenceSetVO.class);
    }

    protected BillAccbookSetVO getBillAccbookSet(Long orgId, String billTypeCode) {
        CommonResponse oneById = this.orgApi.getOneById(orgId);
        OrgVO orgVO = (OrgVO)oneById.getData();
        Object[] parentOrgIds = orgVO.getInnerCode().split("\\|");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAccbookSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.in(BillAccbookSetEntity::getSourceOrgId, parentOrgIds);
        List list = this.billAccbookSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u8d26\u7c3f\u6620\u5c04\u89c4\u5219\u3011, orgId:" + orgId);
        }
        Map setMap = list.stream().collect(Collectors.toMap(BillAccbookSetEntity::getSourceOrgId, Function.identity(), (key1, key2) -> key2));
        BillAccbookSetVO billAccbookSetVO = null;
        for (int i = parentOrgIds.length - 1; i >= 0; --i) {
            BillAccbookSetEntity billAccbookSetEntity = (BillAccbookSetEntity)((Object)setMap.get(Long.valueOf((String)parentOrgIds[i])));
            if (billAccbookSetEntity == null) continue;
            billAccbookSetVO = (BillAccbookSetVO)BeanMapper.map((Object)((Object)billAccbookSetEntity), BillAccbookSetVO.class);
            break;
        }
        return billAccbookSetVO;
    }

    public Boolean getIsGenerateOriginVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }

    public Boolean getIsGenerateFinanceVoucherFlag(VoucherParams voucherParams) {
        return Boolean.TRUE;
    }

    public static void main(String[] args) {
        String expressionString = "'x:' + x";
        Expression expression = AviatorEvaluator.getInstance().compile(expressionString);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("x", 10);
        variables.put("y", "10");
        Object result1 = expression.execute(variables);
        System.out.println("Result 1: " + result1);
        variables.put("x", 20);
        variables.put("y", 8);
        Object result2 = expression.execute(variables);
        System.out.println("Result 2: " + result2);
    }
}

