package com.ejianc.business.accplat.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.InfluenceEntity;
import com.ejianc.business.accplat.config.bean.SubjectContrastDetailEntity;
import com.ejianc.business.accplat.config.bean.SubjectContrastDetailInfluenceEntity;
import com.ejianc.business.accplat.config.bean.SubjectContrastEntity;
import com.ejianc.business.accplat.config.mapper.SubjectContrastMapper;
import com.ejianc.business.accplat.config.service.IInfluenceService;
import com.ejianc.business.accplat.config.service.ISubjectContrastDetailInfluenceService;
import com.ejianc.business.accplat.config.service.ISubjectContrastService;
import com.ejianc.business.accplat.config.vo.InfluenceVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 科目对照
 *
 * @author generator
 *
 */
@Service("subjectContrastService")
public class SubjectContrastServiceImpl extends BaseServiceImpl<SubjectContrastMapper, SubjectContrastEntity> implements ISubjectContrastService {

    @Autowired
    private ISubjectContrastDetailInfluenceService detailInfluenceService;

    @Autowired
    private IInfluenceService influenceService;

    @Override
    public boolean insertOrUpdate(SubjectContrastEntity entity) {
        Boolean success = super.saveOrUpdate(entity, false);
        if (success) {
            List<SubjectContrastDetailEntity> subjectContrastDetailList = entity.getSubjectContrastDetailList();
            List<Long> subjectContrastDetailInfluenceIdList = new ArrayList<>();
            if (ListUtil.isNotEmpty(subjectContrastDetailList)) {
                subjectContrastDetailList.forEach(detail -> {
                    LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                    influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, detail.getId());
                    List<SubjectContrastDetailInfluenceEntity> influenceEntities = detailInfluenceService.list(influenceEntityLambdaQueryWrapper);
                    Map<Long, SubjectContrastDetailInfluenceEntity> oldDetailInfluenceEntityMap = new HashMap<>();
                    if (ListUtil.isNotEmpty(influenceEntities)) {
                        oldDetailInfluenceEntityMap = influenceEntities.stream()
                                .collect(Collectors.toMap(SubjectContrastDetailInfluenceEntity::getInfluenceId, t -> t));
                    }
                    List<SubjectContrastDetailInfluenceEntity> subjectContrastDetailInfluenceList = detail.getSubjectContrastDetailInfluenceList();
                    if (ListUtil.isNotEmpty(subjectContrastDetailInfluenceList)) {
                        for (SubjectContrastDetailInfluenceEntity subjectContrastDetailInfluenceEntity : subjectContrastDetailInfluenceList) {
                            subjectContrastDetailInfluenceEntity.setContrastId(entity.getId());
                            subjectContrastDetailInfluenceEntity.setDetailId(detail.getId());
                            Long influenceId = subjectContrastDetailInfluenceEntity.getInfluenceId();
                            SubjectContrastDetailInfluenceEntity old = oldDetailInfluenceEntityMap.get(influenceId);
                            if (old != null) {
                                old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                                old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                                BeanUtils.copyProperties(old, subjectContrastDetailInfluenceEntity, "influenceValue", "influenceValueView");
                            }
                        }
                        detailInfluenceService.saveOrUpdateBatch(subjectContrastDetailInfluenceList);
                        subjectContrastDetailInfluenceIdList.addAll(subjectContrastDetailInfluenceList.stream().map(SubjectContrastDetailInfluenceEntity::getId).collect(Collectors.toList()));
                    }

                });
            }

            LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaDelWrapper = new LambdaQueryWrapper<>();
            influenceEntityLambdaDelWrapper.eq(SubjectContrastDetailInfluenceEntity::getContrastId, entity.getId());
            influenceEntityLambdaDelWrapper.notIn(CollectionUtils.isNotEmpty(subjectContrastDetailInfluenceIdList), SubjectContrastDetailInfluenceEntity::getId, subjectContrastDetailInfluenceIdList);
            detailInfluenceService.remove(influenceEntityLambdaDelWrapper);

        }
        return true;
    }

    @Override
    public SubjectContrastVO getOneBySubjectCategoryCode(String subjectChartCode, String subjectCategoryCode) {
        LambdaQueryWrapper<SubjectContrastEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(StringUtils.isNoneEmpty(subjectChartCode), SubjectContrastEntity::getSubjectChartCode, subjectChartCode);
        wrapper.eq(StringUtils.isNoneEmpty(subjectCategoryCode), SubjectContrastEntity::getSubjectCategoryCode, subjectCategoryCode);
        List<SubjectContrastEntity> list = this.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("根据科目表编码【" + subjectChartCode + "】、科目分类编码【" + subjectCategoryCode + "】未获取到对应的科目对照！");
        }
        return queryDetail(list.get(0).getId());
    }

    @Override
    public SubjectContrastVO queryDetail(Long id) {
        SubjectContrastEntity entity = this.selectById(id);
        List<SubjectContrastDetailEntity> subjectContrastDetailList = entity.getSubjectContrastDetailList();
        if (ListUtil.isNotEmpty(subjectContrastDetailList)) {
            Collections.sort(subjectContrastDetailList, Comparator.comparingInt(SubjectContrastDetailEntity::getSequence));
            subjectContrastDetailList.forEach(detail -> {
                LambdaQueryWrapper<SubjectContrastDetailInfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
                influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, detail.getId());
                List<SubjectContrastDetailInfluenceEntity> influenceEntities = detailInfluenceService.list(influenceEntityLambdaQueryWrapper);
                detail.setSubjectContrastDetailInfluenceList(influenceEntities);
            });
        }
        SubjectContrastVO vo = BeanMapper.map(entity, SubjectContrastVO.class);
        String influenceIds = vo.getInfluenceIds();
        if (StringUtils.isNotBlank(influenceIds)) {
            LambdaQueryWrapper<InfluenceEntity> influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            influenceEntityLambdaQueryWrapper.in(InfluenceEntity::getId, influenceIds.split(","));
            List<InfluenceEntity> influenceEntities = influenceService.list(influenceEntityLambdaQueryWrapper);
            vo.setSelectedInfluence(BeanMapper.mapList(influenceEntities, InfluenceVO.class));
        }
        return vo;
    }
}
