package com.ejianc.business.accplat.originvoucher.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 凭证模板
 *
 * @author generator
 *
 */
@TableName("ejc_accplat_voucher_template")
public class VoucherTemplateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField("template_code")
    private String templateCode; //模板编码
    @TableField(value = "accbook_id")
    private Long accbookId; // 账簿ID
    @TableField(value = "accbook_code")
    private String accbookCode; // 账簿编号
    @TableField(value = "accbook_name")
    private String accbookName; // 账簿名称
    @TableField(value = "entry_merge_rule")
    private String entryMergeRule; // 分录是否合并规则
    @TableField(value = "mny_null_filter_flag")
    private Integer mnyNullFilterFlag; // 金额为空是否过滤
    @TableField(value = "src_bill_type_id")
    private Long srcBillTypeId; // 来源单据类型ID
    @TableField(value = "src_bill_type_code")
    private String srcBillTypeCode; // 来源单据类型编码
    @TableField(value = "src_bill_type_name")
    private String srcBillTypeName; // 来源单据类型名称
    @TableField(value = "voucher_type")
    private String voucherType; // 凭证类型ex01:记账
    @TableField(value = "rate_type")
    private String rateType; // 汇率类型
    @TableField(value = "currency_code")
    private String currencyCode; // 币别
    @TableField(value = "marker_column")
    private String markerColumn; // 制单人ID取值字段
    @TableField(value = "business_date_column")
    private String businessDateColumn; // 业务日期取值字段
    @TableField(value = "src_bill_pc_url")
    private String srcBillPcUrl; // 来源单据URL
    @TableField(value = "src_bill_org_column")
    private String srcBillOrgColumn; // 来源单据主组织字段名


    @TableField(exist = false)
    @SubEntity(serviceName = "voucherTemplateDetailService", pidName = "voucherTemplateId")//此处有pid="xxx"，默认值pid="pid"
    private List<VoucherTemplateDetailEntity> voucherTemplateDetailList = new ArrayList<>(); // 凭证模板明细

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public Long getAccbookId() {
        return accbookId;
    }

    public void setAccbookId(Long accbookId) {
        this.accbookId = accbookId;
    }

    public String getAccbookCode() {
        return accbookCode;
    }

    public void setAccbookCode(String accbookCode) {
        this.accbookCode = accbookCode;
    }

    public String getAccbookName() {
        return accbookName;
    }

    public void setAccbookName(String accbookName) {
        this.accbookName = accbookName;
    }

    public String getEntryMergeRule() {
        return entryMergeRule;
    }

    public void setEntryMergeRule(String entryMergeRule) {
        this.entryMergeRule = entryMergeRule;
    }

    public Integer getMnyNullFilterFlag() {
        return mnyNullFilterFlag;
    }

    public void setMnyNullFilterFlag(Integer mnyNullFilterFlag) {
        this.mnyNullFilterFlag = mnyNullFilterFlag;
    }

    public Long getSrcBillTypeId() {
        return srcBillTypeId;
    }

    public void setSrcBillTypeId(Long srcBillTypeId) {
        this.srcBillTypeId = srcBillTypeId;
    }

    public String getSrcBillTypeCode() {
        return srcBillTypeCode;
    }

    public void setSrcBillTypeCode(String srcBillTypeCode) {
        this.srcBillTypeCode = srcBillTypeCode;
    }

    public String getSrcBillTypeName() {
        return srcBillTypeName;
    }

    public void setSrcBillTypeName(String srcBillTypeName) {
        this.srcBillTypeName = srcBillTypeName;
    }

    public String getVoucherType() {
        return voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType;
    }

    public String getRateType() {
        return rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getMarkerColumn() {
        return markerColumn;
    }

    public void setMarkerColumn(String markerColumn) {
        this.markerColumn = markerColumn;
    }

    public String getBusinessDateColumn() {
        return businessDateColumn;
    }

    public void setBusinessDateColumn(String businessDateColumn) {
        this.businessDateColumn = businessDateColumn;
    }

    public String getSrcBillPcUrl() {
        return srcBillPcUrl;
    }

    public void setSrcBillPcUrl(String srcBillPcUrl) {
        this.srcBillPcUrl = srcBillPcUrl;
    }

    public String getSrcBillOrgColumn() {
        return srcBillOrgColumn;
    }

    public void setSrcBillOrgColumn(String srcBillOrgColumn) {
        this.srcBillOrgColumn = srcBillOrgColumn;
    }

    public List<VoucherTemplateDetailEntity> getVoucherTemplateDetailList() {
        return voucherTemplateDetailList;
    }

    public void setVoucherTemplateDetailList(List<VoucherTemplateDetailEntity> voucherTemplateDetailList) {
        this.voucherTemplateDetailList = voucherTemplateDetailList;
    }
}
