package com.ejianc.business.voucher.api;

import com.ejianc.business.voucher.service.VoucherBusinessService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @description: 凭证VoucherApi
 **/
@Slf4j
@RestController
@RequestMapping(value = "/api/voucherApi/")
public class VoucherApi {


    @Autowired
    private VoucherBusinessService voucherBusinessService;

    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * @description: 保存凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "save")
    public CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams) {
        // 1、传入参数校验
        String billTypeCode = voucherParams.getBillTypeCode();
        Assert.notNull(billTypeCode, "单据类型编码不能为空！");
        Assert.notNull(voucherParams.getBillData(), "单据数据不能为空！");
        log.info("voucherParams:{}", voucherParams);
        CommonResponse<BillTypeVO> byCodeRes = billTypeApi.getByCode(billTypeCode);
        if (!byCodeRes.isSuccess()) {
            throw new BusinessException("未获取到单据类型【编码：" + billTypeCode + "】");
        }
        voucherParams.setBillTypeVO(byCodeRes.getData());

        // 2、查询是否需要传凭证
        Boolean isGenerateVoucher = voucherBusinessService.isGenerateVoucher(voucherParams);
        if (!isGenerateVoucher) {
            VoucherInfo noNeedVoucherInfo = VoucherInfo.getNoNeedVoucherInfo();
            return CommonResponse.success(noNeedVoucherInfo);
        }

        // 3、保存凭证
        CommonResponse<VoucherInfo> response = voucherBusinessService.save(voucherParams);
        if (response.isSuccess() && response.getData() != null) {
            VoucherInfo data = response.getData();
            data.setFinanceSystemCode(voucherParams.getFinanceSystemCode());
            data.setBillTypeCode(billTypeCode);
        }
        return response;
    }


    /**
     * @description: 查询凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "get")
    public CommonResponse<Map<String, Object>> get(@RequestBody VoucherInfo voucherInfo) {
        return voucherBusinessService.get(voucherInfo);
    }


    /**
     * @description: 凭证删除
     *
     * @author songlx
     * @date: 2023/11/22
     */
    @PostMapping(value = "del")
    public CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo) {
        return voucherBusinessService.del(voucherInfo);
    }


    /**
     * @description: 判断单据是否生成凭证
     *
     * @author songlx
     * @date: 2023/11/30
     */
    @RequestMapping(value = "isGenerateVoucher", method = RequestMethod.GET)
    public CommonResponse<Boolean> isGenerateVoucher(@RequestParam(value = "billTypeCode") String billTypeCode) {
        //TODO
        return CommonResponse.success(Boolean.TRUE);
    }

}
