package com.ejianc.business.voucher.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.voucher.api.VoucherApi;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 凭证业务测试
 * @author songlx
 * @date 2023/12/20
 * @version 1.0
 */
@Slf4j
@RestController
@RequestMapping("voucher")
@Api(value = "凭证业务测试", tags = {"凭证业务测试"})
public class VoucherController {


    @Autowired
    private VoucherApi voucherApi;

    @Autowired
    private ISubContractApi subContractApi;

    @ApiOperation("保存测试")
    @GetMapping(value = "save")
    public CommonResponse<VoucherInfo> save(@RequestParam(defaultValue = "794590852067373151", required = false) String id, @RequestParam(defaultValue = "BT200630000000001", required = false) String billTypeCode) {
        CommonResponse<SettleVO> settleVO = subContractApi.getSettleVO(Long.valueOf(id));
        VoucherParams voucherParams = VoucherParams.newInstance(billTypeCode, settleVO.getData());
        CommonResponse<VoucherInfo> response = voucherApi.save(voucherParams);
        log.info("推送凭证结果：" + JSON.toJSONString(response, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        return response;
    }

    public static void main(String[] args) {
        System.out.println(IdWorker.getId());
    }


}
