package com.ejianc.business.yonyou.base;

import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.datacenter.impl.QueryDataCenterUrlProviderImpl;
import com.ejianc.business.yonyou.base.module.auth.OpenApiAuthProviderFactory;
import com.ejianc.business.yonyou.base.module.auth.OpenApiAuthProviderFactoryImpl;
import com.ejianc.business.yonyou.base.module.auth.isv.ISVAuthProvider;
import com.ejianc.business.yonyou.base.module.auth.isv.ISVCryptoService;
import com.ejianc.business.yonyou.base.module.auth.isv.impl.ISVAuthProviderImpl;
import com.ejianc.business.yonyou.base.module.auth.isv.impl.ISVCryptoServiceImpl;
import com.ejianc.business.yonyou.base.module.auth.tenant.TenantAuthProvider;
import com.ejianc.business.yonyou.base.module.auth.tenant.impl.TenantAuthProviderImpl;
import com.ejianc.business.yonyou.base.network.OpenApiRequestEncryptor;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * 本类主要用于
 *
 * @author liuhaoi
 * @since Created At 2020/5/11 10:31 上午
 */
@RequiredArgsConstructor
@Configuration
@EnableConfigurationProperties(OpenApiProperties.class)
public class OpenApiAutoConfiguration {

    private final OpenApiProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public OpenApiRequestEncryptor openApiRequestEncryptor() {
        return new OpenApiRequestEncryptor();
    }

    @Bean
    public TenantAuthProvider openApiAccessTokenProvider(OpenApiRequestEncryptor encryptor, RestTemplate restTemplate) {
        return new TenantAuthProviderImpl(properties, encryptor, restTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public ISVCryptoService isvCryptoService() {
        return new ISVCryptoServiceImpl(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ISVAuthProvider isvTokenProvider(RestTemplate restTemplate, OpenApiRequestEncryptor encryptor) {
        return new ISVAuthProviderImpl(restTemplate, properties, encryptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiAuthProviderFactory openApiAuthProviderFactory(TenantAuthProvider tenantAuthProvider, ISVAuthProvider isvAuthProvider) {
        return new OpenApiAuthProviderFactoryImpl(isvAuthProvider, tenantAuthProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataCenterUrlProvider dataCenterUrlProvider() {
        return new QueryDataCenterUrlProviderImpl();
    }

}
