/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.AuxiliaryEntity;
import com.ejianc.business.accplat.config.service.IAuxiliaryPresetService;
import com.ejianc.business.accplat.config.service.IAuxiliaryService;
import com.ejianc.business.accplat.config.vo.AuxiliaryPresetVO;
import com.ejianc.business.accplat.config.vo.AuxiliaryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"auxiliary"})
@Api(value="\u8f85\u52a9\u6838\u7b97\u9879", tags={"\u8f85\u52a9\u6838\u7b97\u9879"})
public class AuxiliaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAuxiliaryService service;
    @Autowired
    private IAuxiliaryPresetService auxiliaryPresetService;
    private static final String AUXILIARY_CODE = "AUXILIARY_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AuxiliaryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AuxiliaryVO saveOrUpdateVO) {
        String auxiliaryCode = saveOrUpdateVO.getAuxiliaryCode();
        if (StringUtils.isBlank((CharSequence)auxiliaryCode)) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(AUXILIARY_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            saveOrUpdateVO.setAuxiliaryCode((String)billCode.getData());
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(AuxiliaryEntity::getAuxiliaryCode, (Object)auxiliaryCode);
            wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            int count = this.service.count((Wrapper)wrapper);
            if (count > 0) {
                throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
        }
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setEnabled(Integer.valueOf(1));
        }
        AuxiliaryEntity entity = (AuxiliaryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AuxiliaryEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AuxiliaryVO vo = (AuxiliaryVO)BeanMapper.map((Object)((Object)entity), AuxiliaryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AuxiliaryVO> queryDetail(@RequestParam Long id) {
        AuxiliaryEntity entity = (AuxiliaryEntity)((Object)this.service.selectById(id));
        AuxiliaryVO vo = (AuxiliaryVO)BeanMapper.map((Object)((Object)entity), AuxiliaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuxiliaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AuxiliaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Auxiliary-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAuxiliaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryVO>> refAuxiliaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AuxiliaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u542f\u7528/\u505c\u7528")
    @RequestMapping(value={"/enabled"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody AuxiliaryVO auxiliaryVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)auxiliaryVO.getId());
        wrapper.set(AuxiliaryEntity::getEnabled, (Object)auxiliaryVO.getEnabled());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u542f\u7528/\u505c\u7528\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5f15\u5165\u9884\u7f6e\u6838\u7b97\u9879")
    @RequestMapping(value={"/importPreset"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importPreset(@RequestBody List<AuxiliaryPresetVO> vos) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.service.list((Wrapper)queryWrapper);
        Map<Object, Object> auxiliaryMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            auxiliaryMap = list.stream().collect(Collectors.toMap(AuxiliaryEntity::getAuxiliaryCode, t -> t));
        }
        ArrayList<AuxiliaryEntity> auxiliaryEntitiesSave = new ArrayList<AuxiliaryEntity>();
        ArrayList<String> repeatCodes = new ArrayList<String>();
        StringBuilder resMsg = new StringBuilder();
        for (AuxiliaryPresetVO vo : vos) {
            String auxiliaryCode = vo.getAuxiliaryCode();
            if (auxiliaryMap.containsKey(auxiliaryCode)) {
                repeatCodes.add(auxiliaryCode);
                continue;
            }
            AuxiliaryEntity auxiliaryEntity = new AuxiliaryEntity();
            auxiliaryEntity.setAuxiliaryCode(vo.getAuxiliaryCode());
            auxiliaryEntity.setAuxiliaryName(vo.getAuxiliaryName());
            auxiliaryEntity.setDataType(vo.getDataType());
            auxiliaryEntity.setReferId(vo.getReferId());
            auxiliaryEntity.setReferCode(vo.getReferCode());
            auxiliaryEntity.setReferName(vo.getReferName());
            auxiliaryEntity.setEnabled(1);
            auxiliaryEntitiesSave.add(auxiliaryEntity);
        }
        if (CollectionUtils.isNotEmpty(auxiliaryEntitiesSave)) {
            this.service.saveOrUpdateBatch(auxiliaryEntitiesSave);
            resMsg.append("[\u6210\u529f\u5f15\u5165\u9884\u7f6e\u6838\u7b97\u9879 " + auxiliaryEntitiesSave.size() + " \u6761]");
        }
        if (CollectionUtils.isNotEmpty(repeatCodes)) {
            resMsg.append("[\u5f15\u5165\u5931\u8d25 " + repeatCodes.size() + " \u6761\uff0c\u7f16\u7801\u5df2\u5b58\u5728\uff1a" + String.join((CharSequence)"\uff0c", repeatCodes) + "]");
        }
        return CommonResponse.success((String)resMsg.toString());
    }
}

