/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.SubjectContrastDetailEntity;
import com.ejianc.business.accplat.config.bean.SubjectContrastDetailInfluenceEntity;
import com.ejianc.business.accplat.config.bean.SubjectContrastEntity;
import com.ejianc.business.accplat.config.mapper.SubjectContrastMapper;
import com.ejianc.business.accplat.config.service.IInfluenceService;
import com.ejianc.business.accplat.config.service.ISubjectContrastDetailInfluenceService;
import com.ejianc.business.accplat.config.service.ISubjectContrastService;
import com.ejianc.business.accplat.config.vo.InfluenceVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subjectContrastService")
public class SubjectContrastServiceImpl
extends BaseServiceImpl<SubjectContrastMapper, SubjectContrastEntity>
implements ISubjectContrastService {
    @Autowired
    private ISubjectContrastDetailInfluenceService detailInfluenceService;
    @Autowired
    private IInfluenceService influenceService;

    @Override
    public boolean insertOrUpdate(SubjectContrastEntity entity) {
        Boolean success = super.saveOrUpdate((Object)entity, false);
        if (success.booleanValue()) {
            List<SubjectContrastDetailEntity> subjectContrastDetailList = entity.getSubjectContrastDetailList();
            ArrayList subjectContrastDetailInfluenceIdList = new ArrayList();
            if (ListUtil.isNotEmpty(subjectContrastDetailList)) {
                subjectContrastDetailList.forEach(detail -> {
                    List<SubjectContrastDetailInfluenceEntity> subjectContrastDetailInfluenceList;
                    LambdaQueryWrapper influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                    influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, (Object)detail.getId());
                    List influenceEntities = this.detailInfluenceService.list((Wrapper)influenceEntityLambdaQueryWrapper);
                    Map<Object, Object> oldDetailInfluenceEntityMap = new HashMap();
                    if (ListUtil.isNotEmpty((List)influenceEntities)) {
                        oldDetailInfluenceEntityMap = influenceEntities.stream().collect(Collectors.toMap(SubjectContrastDetailInfluenceEntity::getInfluenceId, t -> t));
                    }
                    if (ListUtil.isNotEmpty(subjectContrastDetailInfluenceList = detail.getSubjectContrastDetailInfluenceList())) {
                        for (SubjectContrastDetailInfluenceEntity subjectContrastDetailInfluenceEntity : subjectContrastDetailInfluenceList) {
                            subjectContrastDetailInfluenceEntity.setContrastId(entity.getId());
                            subjectContrastDetailInfluenceEntity.setDetailId(detail.getId());
                            Long influenceId = subjectContrastDetailInfluenceEntity.getInfluenceId();
                            SubjectContrastDetailInfluenceEntity old = (SubjectContrastDetailInfluenceEntity)((Object)((Object)oldDetailInfluenceEntityMap.get(influenceId)));
                            if (old == null) continue;
                            old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                            old.setInfluenceValue(subjectContrastDetailInfluenceEntity.getInfluenceValue());
                            BeanUtils.copyProperties((Object)((Object)old), (Object)((Object)subjectContrastDetailInfluenceEntity), (String[])new String[]{"influenceValue", "influenceValueView"});
                        }
                        this.detailInfluenceService.saveOrUpdateBatch(subjectContrastDetailInfluenceList);
                        subjectContrastDetailInfluenceIdList.addAll(subjectContrastDetailInfluenceList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                    }
                });
            }
            LambdaQueryWrapper influenceEntityLambdaDelWrapper = new LambdaQueryWrapper();
            influenceEntityLambdaDelWrapper.eq(SubjectContrastDetailInfluenceEntity::getContrastId, (Object)entity.getId());
            influenceEntityLambdaDelWrapper.notIn(CollectionUtils.isNotEmpty(subjectContrastDetailInfluenceIdList), BaseEntity::getId, subjectContrastDetailInfluenceIdList);
            this.detailInfluenceService.remove((Wrapper)influenceEntityLambdaDelWrapper);
        }
        return true;
    }

    @Override
    public SubjectContrastVO getOneBySubjectCategoryCode(String subjectChartCode, String subjectCategoryCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{subjectChartCode}), SubjectContrastEntity::getSubjectChartCode, (Object)subjectChartCode);
        wrapper.eq(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{subjectCategoryCode}), SubjectContrastEntity::getSubjectCategoryCode, (Object)subjectCategoryCode);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u6839\u636e\u79d1\u76ee\u8868\u7f16\u7801\u3010" + subjectChartCode + "\u3011\u3001\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\u3010" + subjectCategoryCode + "\u3011\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u79d1\u76ee\u5bf9\u7167\uff01");
        }
        return this.queryDetail(((SubjectContrastEntity)((Object)list.get(0))).getId());
    }

    @Override
    public SubjectContrastVO queryDetail(Long id) {
        SubjectContrastVO vo;
        String influenceIds;
        SubjectContrastEntity entity = (SubjectContrastEntity)((Object)this.selectById(id));
        List<SubjectContrastDetailEntity> subjectContrastDetailList = entity.getSubjectContrastDetailList();
        if (ListUtil.isNotEmpty(subjectContrastDetailList)) {
            Collections.sort(subjectContrastDetailList, Comparator.comparingInt(SubjectContrastDetailEntity::getSequence));
            subjectContrastDetailList.forEach(detail -> {
                LambdaQueryWrapper influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                influenceEntityLambdaQueryWrapper.eq(SubjectContrastDetailInfluenceEntity::getDetailId, (Object)detail.getId());
                List influenceEntities = this.detailInfluenceService.list((Wrapper)influenceEntityLambdaQueryWrapper);
                detail.setSubjectContrastDetailInfluenceList(influenceEntities);
            });
        }
        if (StringUtils.isNotBlank((CharSequence)(influenceIds = (vo = (SubjectContrastVO)BeanMapper.map((Object)((Object)entity), SubjectContrastVO.class)).getInfluenceIds()))) {
            LambdaQueryWrapper influenceEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            influenceEntityLambdaQueryWrapper.in(BaseEntity::getId, (Object[])influenceIds.split(","));
            List influenceEntities = this.influenceService.list((Wrapper)influenceEntityLambdaQueryWrapper);
            vo.setSelectedInfluence(BeanMapper.mapList((Iterable)influenceEntities, InfluenceVO.class));
        }
        return vo;
    }
}

