/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.kingdee.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.kingdee.api.KingDeeGalaxyInvokeHelper;
import com.ejianc.business.kingdee.base.consts.KingDeeQueryConsts;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.SuccessEntity;
import com.ejianc.business.kingdee.base.vo.query.KingDeeVoucherApiQueryVO;
import com.ejianc.business.kingdee.base.vo.save.FACCOUNTID;
import com.ejianc.business.kingdee.base.vo.save.FAccountBookID;
import com.ejianc.business.kingdee.base.vo.save.FCURRENCYID;
import com.ejianc.business.kingdee.base.vo.save.FDetailID;
import com.ejianc.business.kingdee.base.vo.save.FEXCHANGERATETYPE;
import com.ejianc.business.kingdee.base.vo.save.FEntity;
import com.ejianc.business.kingdee.base.vo.save.KingDeeVoucherApiSaveVO;
import com.ejianc.business.kingdee.base.vo.save.Model;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KingDeeGalaxyVoucherService
extends KingDeeGalaxyInvokeHelper
implements IFinanceVoucherService {
    @Value(value="${kdapi.access-type}")
    private boolean accessType;

    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            Map map = voucherParams.getFinanceVoucher();
            Object model = map.get("Model");
            RepoResult repoResult = null;
            repoResult = model instanceof List ? this.batchSave("GL_VOUCHER", DataConvertUtil.objToString((Object)map)) : this.save("GL_VOUCHER", DataConvertUtil.objToString((Object)map));
            if (repoResult.isSuccess()) {
                ArrayList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                ArrayList<VoucherSimpleVO> voucherSimpleVOS = new ArrayList<VoucherSimpleVO>();
                for (SuccessEntity successEntity : successEntitys) {
                    VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                    voucherSimpleVO.setVoucherId(successEntity.getId());
                    voucherSimpleVO.setVoucherCode(successEntity.getNumber());
                    voucherSimpleVOS.add(voucherSimpleVO);
                }
                return CommonResponse.success((Object)VoucherInfo.getVoucherInfo(voucherSimpleVOS));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            Map map = voucherParams.getFinanceVoucher();
            RepoResult repoResult = this.batchSave("GL_VOUCHER", DataConvertUtil.objToString((Object)map));
            if (repoResult.isSuccess()) {
                ArrayList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                ArrayList<VoucherSimpleVO> voucherSimpleVOS = new ArrayList<VoucherSimpleVO>();
                for (SuccessEntity successEntity : successEntitys) {
                    VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                    voucherSimpleVO.setVoucherId(successEntity.getId());
                    voucherSimpleVO.setVoucherCode(successEntity.getNumber());
                    voucherSimpleVOS.add(voucherSimpleVO);
                }
                return CommonResponse.success((Object)VoucherInfo.getVoucherInfo(voucherSimpleVOS));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public CommonResponse get(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            List vouchers = voucherInfo.getVouchers();
            if (CollectionUtils.isEmpty((Collection)vouchers)) {
                throw new BusinessException("vouchers\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (vouchers.size() == 1) {
                VoucherSimpleVO voucherSimpleVO = (VoucherSimpleVO)vouchers.get(0);
                JSONObject paramObj = new JSONObject();
                paramObj.put("Id", (Object)voucherSimpleVO.getVoucherId());
                RepoResult repoResult = this.view("GL_VOUCHER", paramObj.toJSONString());
                if (repoResult.isSuccess()) {
                    JSONObject result = (JSONObject)repoResult.getResult();
                    return CommonResponse.success((Object)result);
                }
                resp = repoResult.toCommonResponse();
            } else {
                KingDeeVoucherApiQueryVO kingDeeVoucherApiQueryVO = new KingDeeVoucherApiQueryVO();
                List<String> ids = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.toList());
                kingDeeVoucherApiQueryVO.setFilterStringForEqIds(ids);
                List<Map<String, Object>> maps = this.executeBillQuery(DataConvertUtil.objToString((Object)((Object)kingDeeVoucherApiQueryVO)), KingDeeQueryConsts.FIELDKEYS);
                resp = CommonResponse.success(maps);
            }
        }
        return resp;
    }

    @Override
    public CommonResponse getList(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            KingDeeVoucherApiQueryVO kingDeeVoucherApiQueryVO = new KingDeeVoucherApiQueryVO();
            List vouchers = voucherInfo.getVouchers();
            List<String> ids = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.toList());
            kingDeeVoucherApiQueryVO.setFilterStringForEqIds(ids);
            List<Map<String, Object>> maps = this.executeBillQuery(DataConvertUtil.objToString((Object)((Object)kingDeeVoucherApiQueryVO)), KingDeeQueryConsts.FIELDKEYS);
            resp = CommonResponse.success(maps);
        }
        return resp;
    }

    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            List vouchers = voucherInfo.getVouchers();
            if (CollectionUtils.isEmpty((Collection)vouchers)) {
                throw new BusinessException("vouchers\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String voucherIds = vouchers.stream().map(VoucherSimpleVO::getVoucherId).collect(Collectors.joining(","));
            JSONObject paramObj = new JSONObject();
            paramObj.put("Ids", (Object)voucherIds);
            RepoResult repoResult = this.delete("GL_VOUCHER", paramObj.toJSONString());
            if (repoResult.isSuccess()) {
                String result = String.valueOf(repoResult.getResult());
                return CommonResponse.success((Object)JSON.parseObject((String)result));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public Map<String, Object> convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams, OriginVoucherVO originVoucherVO) {
        KingDeeVoucherApiSaveVO<Model> kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        Model model = new Model();
        FAccountBookID fAccountBookID = new FAccountBookID();
        fAccountBookID.setFNumber(originVoucherVO.getAccbookCode());
        model.setFAccountBookID(fAccountBookID);
        Date businessDate = originVoucherVO.getBusinessDate();
        model.setFDate(DataConvertUtil.formatDate((Object)businessDate));
        List originVoucherEntryList = originVoucherVO.getOriginVoucherEntryList();
        ArrayList<FEntity> fEntityList = new ArrayList<FEntity>();
        for (OriginVoucherEntryVO entryVO : originVoucherEntryList) {
            FEntity fEntity1 = new FEntity();
            fEntity1.setFEXPLANATION(entryVO.getEntryDescription());
            FACCOUNTID faccountid = new FACCOUNTID();
            faccountid.setFNumber(entryVO.getSubjectCode());
            fEntity1.setFACCOUNTID(faccountid);
            if ("debit".equals(entryVO.getDirectionFlag())) {
                fEntity1.setFAMOUNTFOR(entryVO.getDebitOriginalMny());
                fEntity1.setFDEBIT(entryVO.getDebitOriginalMny());
            } else {
                fEntity1.setFAMOUNTFOR(entryVO.getCrebitOriginalMny());
                fEntity1.setFCREDIT(entryVO.getCrebitOriginalMny());
            }
            FCURRENCYID fcurrencyid = new FCURRENCYID();
            fcurrencyid.setFNumber(entryVO.getRateType());
            fEntity1.setFCURRENCYID(fcurrencyid);
            FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
            fexchangeratetype.setFNumber(entryVO.getCurrencyCode());
            fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);
            List clientAuxiliaryList = entryVO.getOriginVoucherAuxiliaryVOList();
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)clientAuxiliaryList)) {
                HashMap<String, FDetailID> fDetailID = new HashMap<String, FDetailID>();
                for (OriginVoucherAuxiliaryVO originVoucherAuxiliaryVO : clientAuxiliaryList) {
                    FDetailID fflex = new FDetailID();
                    fflex.setFNumber(originVoucherAuxiliaryVO.getAuxiliaryFsValue());
                    try {
                        BeanUtils.setProperty(fDetailID, (String)originVoucherAuxiliaryVO.getAuxiliaryFsCode(), (Object)fflex);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                fEntity1.setFDetailID(fDetailID);
            }
            fEntityList.add(fEntity1);
        }
        model.setFEntity(fEntityList);
        kingDeeVoucherApiSaveVO.setModel(model);
        return DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO);
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "tom");
        map.put("Age", 20);
        String s = new Gson().toJson(map);
        System.out.println(s);
        KingDeeVoucherApiSaveVO<Model> kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        Model model = new Model();
        FEntity fEntity = new FEntity();
        fEntity.setFAMOUNTFOR(ComputeUtil.toBigDecimal((Integer)11));
        model.setFEntity(Arrays.asList(fEntity));
        kingDeeVoucherApiSaveVO.setModel(model);
        String s1 = new Gson().toJson(kingDeeVoucherApiSaveVO);
        System.out.println(s1);
        Map map1 = (Map)JSON.parseObject((String)new Gson().toJson(kingDeeVoucherApiSaveVO), Map.class);
        System.out.println(map1);
        System.out.println(JSONObject.toJSONString(kingDeeVoucherApiSaveVO));
    }
}

