/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.originvoucher.bean.VoucherTemplateEntity;
import com.ejianc.business.accplat.originvoucher.service.IVoucherTemplateService;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherTemplateCacheProvider {
    private final String VOUCHER_TEMPLATE_CACHE_PREFIX = "ejcvt:";
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IVoucherTemplateService voucherTemplateService;

    public VoucherTemplateVO loadTemplateFromCache(String billTypeCode, String businessType) {
        String cacheKey = this.getCacheKey(billTypeCode, businessType);
        VoucherTemplateVO voucherTemplateVO = (VoucherTemplateVO)this.cacheManager.get(cacheKey);
        if (null == voucherTemplateVO) {
            LambdaQueryWrapper templateEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            templateEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getSrcBillTypeCode, (Object)billTypeCode);
            templateEntityLambdaQueryWrapper.eq(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{businessType}), VoucherTemplateEntity::getBusinessType, (Object)businessType);
            VoucherTemplateEntity templateEntity = (VoucherTemplateEntity)((Object)this.voucherTemplateService.getOne((Wrapper)templateEntityLambdaQueryWrapper));
            if (templateEntity == null) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5355\u636e\u3010\u5355\u636e\u7c7b\u578b\uff1a" + billTypeCode + "\u3011\u7684\u51ed\u8bc1\u6a21\u677f!");
            }
            voucherTemplateVO = (VoucherTemplateVO)BeanMapper.map((Object)((Object)templateEntity), VoucherTemplateVO.class);
            this.saveTemplateToCache(cacheKey, voucherTemplateVO);
        }
        return voucherTemplateVO;
    }

    public void saveTemplateToCache(String cacheKey, VoucherTemplateVO voucherTemplateVO) {
        this.cacheManager.set(cacheKey, (Serializable)voucherTemplateVO);
    }

    public void removeTemplateCache(String billTypeCode, String businessType) {
        String cacheKey = this.getCacheKey(billTypeCode, businessType);
        if (this.cacheManager.exists(cacheKey).booleanValue()) {
            this.cacheManager.removeCache(cacheKey);
        }
    }

    private String getCacheKey(String billTypeCode, String businessType) {
        return "ejcvt:" + InvocationInfoProxy.getTenantid() + billTypeCode + Optional.ofNullable(businessType).orElse("");
    }
}

