/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.AccbookEntity;
import com.ejianc.business.accplat.config.bean.SubjectChartEntity;
import com.ejianc.business.accplat.config.service.IAccbookService;
import com.ejianc.business.accplat.config.service.ISubjectChartService;
import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"accbook"})
@Api(value="\u8d26\u7c3f", tags={"\u8d26\u7c3f"})
public class AccbookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAccbookService service;
    @Autowired
    private ISubjectChartService subjectChartService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AccbookVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AccbookVO saveOrUpdateVO) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AccbookEntity::getCode, (Object)saveOrUpdateVO.getCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        int count = this.service.count((Wrapper)wrapper);
        if (count > 0) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setEnabled(Integer.valueOf(1));
        }
        AccbookEntity entity = (AccbookEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AccbookEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AccbookVO vo = (AccbookVO)BeanMapper.map((Object)((Object)entity), AccbookVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AccbookVO> queryDetail(@RequestParam Long id) {
        AccbookEntity entity = (AccbookEntity)((Object)this.service.selectById(id));
        AccbookVO vo = (AccbookVO)BeanMapper.map((Object)((Object)entity), AccbookVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccbookVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AccbookVO accbookVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AccbookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List accbookVOS = BeanMapper.mapList((Iterable)list, AccbookVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", accbookVOS);
        ExcelExport.getInstance().export("Accbook-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAccbookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> refAccbookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AccbookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u542f\u7528/\u505c\u7528")
    @RequestMapping(value={"/enabled"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody AccbookVO accbookVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)accbookVO.getId());
        wrapper.set(AccbookEntity::getEnabled, (Object)accbookVO.getEnabled());
        this.service.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u542f\u7528/\u505c\u7528\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Accbook-import.xlsx", (String)"\u5bfc\u5165\u8d26\u7c3f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<AccbookVO> successList = new ArrayList<AccbookVO>();
        ArrayList<AccbookVO> errorList = new ArrayList<AccbookVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 3) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List subjectEntities = this.subjectChartService.list((Wrapper)lambdaQueryWrapper);
        Map<String, Long> subMap = subjectEntities.stream().collect(Collectors.toMap(SubjectChartEntity::getName, BaseEntity::getId));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List accbookEntities = this.service.list((Wrapper)queryWrapper);
        List accbookCodeList = accbookEntities.stream().map(AccbookEntity::getCode).collect(Collectors.toList());
        for (int i = 0; i < result.size(); ++i) {
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            AccbookVO accbookVO = new AccbookVO();
            String code = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                if (accbookCodeList.contains(code)) {
                    errMsg.append("`\u8d26\u7c3f\u7f16\u7801\u5df2\u5b58\u5728\u8bf7\u91cd\u65b0\u8f93\u5165`");
                } else {
                    accbookVO.setCode(code);
                }
            } else {
                errMsg.append("`\u8d26\u7c3f\u7f16\u7801\u672a\u586b\u5199`");
            }
            String name = ((String)row.get(1)).trim();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                accbookVO.setName(name);
            } else {
                errMsg.append("`\u8d26\u7c3f\u540d\u79f0\u672a\u586b\u5199`");
            }
            String subjectName = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)subjectName)) {
                Long subId = subMap.get(subjectName);
                if (subId != null) {
                    accbookVO.setSubjectChartId(subId);
                    accbookVO.setSubjectChartName(subjectName);
                } else {
                    errMsg.append("`\u79d1\u76ee\u540d\u79f0\u4e0d\u5b58\u5728\u8bf7\u91cd\u65b0\u8f93\u5165`");
                }
            } else {
                errMsg.append("`\u79d1\u76ee\u540d\u79f0\u672a\u586b\u5199`");
            }
            accbookVO.setEnabled(Integer.valueOf(1));
            accbookVO.setEnabledName("\u542f\u7528");
            accbookVO.setErrMsg(errMsg.toString());
            if (StringUtils.isNotBlank((CharSequence)accbookVO.getErrMsg())) {
                errorList.add(accbookVO);
                continue;
            }
            successList.add(accbookVO);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, AccbookEntity.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<AccbookVO> accbookVOS) {
        this.service.saveBatch(BeanMapper.mapList(accbookVOS, AccbookEntity.class));
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }
}

