/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.api;

import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.voucher.service.VoucherBusinessService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voucherApi/"})
public class VoucherApi {
    private static final Logger log = LoggerFactory.getLogger(VoucherApi.class);
    @Autowired
    private VoucherBusinessService voucherBusinessService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @PostMapping(value={"save"})
    public CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long orgId = voucherParams.getOrgId();
        Map billData = voucherParams.getBillData();
        Assert.notNull((Object)billTypeCode, (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801billTypeCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billData, (String)"\u5355\u636e\u4e3b\u7ec4\u7ec7orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billData, (String)"\u5355\u636e\u6570\u636ebillData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse byCodeRes = this.billTypeApi.getByCode(billTypeCode);
        if (!byCodeRes.isSuccess()) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5355\u636e\u7c7b\u578b\u3010\u7f16\u7801\uff1a" + billTypeCode + "\u3011");
        }
        voucherParams.setBillTypeVO((BillTypeVO)byCodeRes.getData());
        Boolean isGenerateVoucher = this.voucherBusinessService.isGenerateVoucher(voucherParams);
        if (!isGenerateVoucher.booleanValue()) {
            VoucherInfo noNeedVoucherInfo = VoucherInfo.getNoNeedVoucherInfo((String)voucherParams.getMsgInfo());
            return CommonResponse.success((Object)noNeedVoucherInfo);
        }
        List<BillAccbookSetVO> billAccbookSetVOList = this.voucherBusinessService.getBillAccbookSet(orgId, billTypeCode, billData);
        voucherParams.setBillAccbookSetVOList(billAccbookSetVOList);
        Long tenantid = InvocationInfoProxy.getTenantid();
        String financeSystemCode = "kingDeeGalaxy";
        voucherParams.setFinanceSystemCode(financeSystemCode);
        CommonResponse<VoucherInfo> response = this.voucherBusinessService.save(voucherParams);
        if (response.isSuccess() && response.getData() != null) {
            VoucherInfo data = (VoucherInfo)response.getData();
            data.setFinanceSystemCode(voucherParams.getFinanceSystemCode());
            data.setBillTypeCode(billTypeCode);
        }
        return response;
    }

    @PostMapping(value={"get"})
    public CommonResponse<Map<String, Object>> get(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.get(voucherInfo);
    }

    @PostMapping(value={"del"})
    public CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.del(voucherInfo);
    }
}

