/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.AuxiliaryEntity;
import com.ejianc.business.accplat.config.bean.SubjectChartEntity;
import com.ejianc.business.accplat.config.bean.SubjectEntity;
import com.ejianc.business.accplat.config.service.IAuxiliaryService;
import com.ejianc.business.accplat.config.service.ISubjectChartService;
import com.ejianc.business.accplat.config.service.ISubjectService;
import com.ejianc.business.accplat.config.vo.SubjectAuxiliaryVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.business.voucher.utils.ResultAsTreePlus;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"subject"})
@Api(value="\u4f1a\u8ba1\u79d1\u76ee", tags={"\u4f1a\u8ba1\u79d1\u76ee"})
public class SubjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubjectChartService subjectChartService;
    @Autowired
    private ISubjectService service;
    @Autowired
    private IAuxiliaryService auxiliaryService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SubjectVO saveOrUpdateVO) {
        Long parentId;
        if (saveOrUpdateVO.getSubjectChartId() == null) {
            throw new BusinessException("\u79d1\u76ee\u8868ID[subjectChartId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SubjectEntity::getSubjectChartId, (Object)saveOrUpdateVO.getSubjectChartId());
        wrapper.eq(SubjectEntity::getSubjectCode, (Object)saveOrUpdateVO.getSubjectCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        int count = this.service.count((Wrapper)wrapper);
        if (count > 0) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        List subjectAuxiliaryList = saveOrUpdateVO.getSubjectAuxiliaryList();
        String auxiliaryIds = null;
        String auxiliaryNames = null;
        if (CollectionUtils.isNotEmpty((Collection)subjectAuxiliaryList)) {
            auxiliaryIds = subjectAuxiliaryList.stream().filter(t -> !"del".equals(t.getRowState())).map(t -> String.valueOf(t.getAuxiliaryId())).collect(Collectors.joining(","));
            auxiliaryNames = subjectAuxiliaryList.stream().filter(t -> !"del".equals(t.getRowState())).map(SubjectAuxiliaryVO::getAuxiliaryName).collect(Collectors.joining(","));
        }
        saveOrUpdateVO.setAuxiliaryIds(auxiliaryIds);
        saveOrUpdateVO.setAuxiliaryNames(auxiliaryNames);
        if (saveOrUpdateVO.getId() == null) {
            long id = IdWorker.getId();
            saveOrUpdateVO.setId(Long.valueOf(id));
        }
        if ((parentId = saveOrUpdateVO.getParentId()) == null) {
            saveOrUpdateVO.setInnerCode(String.valueOf(saveOrUpdateVO.getId()));
        } else {
            SubjectEntity parent = (SubjectEntity)((Object)this.service.getById(parentId));
            saveOrUpdateVO.setInnerCode(parent.getInnerCode() + "|" + saveOrUpdateVO.getId());
        }
        SubjectEntity entity = (SubjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubjectEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SubjectVO vo = (SubjectVO)BeanMapper.map((Object)((Object)entity), SubjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectVO> queryDetail(@RequestParam Long id) {
        SubjectEntity entity = (SubjectEntity)((Object)this.service.selectById(id));
        SubjectVO vo = (SubjectVO)BeanMapper.map((Object)((Object)entity), SubjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List subjectEntities = this.service.queryList(param, false);
        List subjectVOS = BeanMapper.mapList((Iterable)subjectEntities, SubjectVO.class);
        List resultMapList = BeanMapper.mapList((Iterable)subjectVOS, Map.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)ResultAsTreePlus.createTreeData((List)resultMapList));
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subject-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSubjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSubjectData(String condition, String searchObject, String searchText) {
        JSONObject _con;
        Long subjectChartId;
        if (StringUtils.isEmpty((CharSequence)condition) || !condition.contains("subjectChartId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e: \u5fc5\u4f20\u53c2\u6570\u79d1\u76ee\u8868ID\u3010subjectChartId\u3011");
        }
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("subjectCode", "subjectName", "fullName", "auxiliaryNames"));
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (subjectChartId = (_con = JSONObject.parseObject((String)condition)).getLong("subjectChartId"))) {
            param.getParams().put("subjectChartId", new Parameter("eq", (Object)subjectChartId));
        }
        List subjectEntities = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (SubjectEntity entity : subjectEntities) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Subject-import.xlsx", (String)"\u5bfc\u5165\u4f1a\u8ba1\u79d1\u76ee");
    }

    @RequestMapping(value={"/excelImport/{subjectChartId}"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(@PathVariable(name="subjectChartId") Long subjectChartId, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        SubjectChartEntity subjectChartEntity = (SubjectChartEntity)((Object)this.subjectChartService.getById(subjectChartId));
        Integer subjectCodeType = subjectChartEntity.getSubjectCodeType();
        String subjectCodeRule = subjectChartEntity.getSubjectCodeRule().trim();
        HashMap<Integer, Integer> selfRuleMap = new HashMap<Integer, Integer>();
        if (subjectCodeType == 2) {
            String[] ruleNum;
            for (String s : ruleNum = subjectCodeRule.split("-")) {
                int sum = selfRuleMap.values().stream().mapToInt(Integer::intValue).sum();
                selfRuleMap.put(Integer.valueOf(s), sum);
            }
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<SubjectVO> successList = new ArrayList<SubjectVO>();
        ArrayList<SubjectVO> errorList = new ArrayList<SubjectVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 4) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        HashMap<String, Integer> codeMap = new HashMap<String, Integer>();
        HashMap<String, SubjectVO> parentMap = new HashMap<String, SubjectVO>();
        for (int i = 0; i < result.size(); ++i) {
            int rowNum = i + 2;
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            StringBuilder errorFlag = new StringBuilder();
            if (row.get(1) == null) continue;
            SubjectVO subjectVO = new SubjectVO();
            subjectVO.setSubjectChartId(subjectChartId);
            String subjectCode = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)subjectCode)) {
                subjectVO.setSubjectCode(subjectCode);
                if (!codeMap.containsKey(subjectCode)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(SubjectEntity::getSubjectChartId, (Object)subjectChartId);
                    wrapper.eq(SubjectEntity::getSubjectCode, (Object)subjectCode);
                    wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    SubjectEntity one = (SubjectEntity)((Object)this.service.getOne((Wrapper)wrapper));
                    if (one != null) {
                        BeanUtils.copyProperties((Object)((Object)one), (Object)subjectVO, (String[])new String[]{"parentId", "innerCode", "subjectChartId", "treeIndex", "subjectCode", "subjectName", "fullName", "auxiliaryIds", "auxiliaryNames"});
                        errMsg.append("`\u7b2c" + rowNum + "\u884c\u79d1\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u3001\u53ef\u8986\u76d6\u66f4\u65b0`");
                        errorFlag.append("1");
                    }
                    codeMap.put(subjectCode, rowNum);
                } else {
                    errorFlag.append("2");
                    errMsg.append("`\u7b2c" + codeMap.get(subjectCode) + "\u3001" + rowNum + "\u884c\u79d1\u76ee\u7f16\u7801\u91cd\u590d`");
                }
            } else {
                errorFlag.append("2");
                errMsg.append("`\u79d1\u76ee\u7f16\u7801\u672a\u586b\u5199`");
            }
            String subjectName = ((String)row.get(1)).trim();
            if (StringUtils.isNotBlank((CharSequence)subjectName)) {
                subjectVO.setSubjectName(subjectName);
            } else {
                errorFlag.append("2");
                errMsg.append("`\u79d1\u76ee\u540d\u79f0\u672a\u586b\u5199`");
            }
            String fullName = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                subjectVO.setFullName(fullName);
            } else {
                errorFlag.append("2");
                errMsg.append("`\u5168\u540d\u672a\u586b\u5199`");
            }
            String auxiliaryNamesStr = ((String)row.get(3)).trim();
            if (StringUtils.isNotBlank((CharSequence)auxiliaryNamesStr)) {
                subjectVO.setAuxiliaryNamesImport(auxiliaryNamesStr);
                String[] auxiliaryNameArr = auxiliaryNamesStr.split("[,\uff0c]");
                List auxiliaryNames = Arrays.asList(auxiliaryNameArr).stream().distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(AuxiliaryEntity::getAuxiliaryName, auxiliaryNames);
                wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                List list = this.auxiliaryService.list((Wrapper)wrapper);
                Map<Object, Object> auxiliaryMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    auxiliaryMap = list.stream().collect(Collectors.toMap(AuxiliaryEntity::getAuxiliaryName, t -> t));
                }
                ArrayList<SubjectAuxiliaryVO> subjectAuxiliaryVOS = new ArrayList<SubjectAuxiliaryVO>();
                for (String auxiliaryName : auxiliaryNames) {
                    AuxiliaryEntity auxiliaryEntity = (AuxiliaryEntity)((Object)auxiliaryMap.get(auxiliaryName));
                    if (auxiliaryEntity != null) {
                        SubjectAuxiliaryVO subjectAuxiliaryVO = new SubjectAuxiliaryVO();
                        subjectAuxiliaryVO.setAuxiliaryId(auxiliaryEntity.getId());
                        subjectAuxiliaryVO.setAuxiliaryCode(auxiliaryEntity.getAuxiliaryCode());
                        subjectAuxiliaryVO.setAuxiliaryName(auxiliaryEntity.getAuxiliaryName());
                        subjectAuxiliaryVO.setDataType(auxiliaryEntity.getDataType());
                        subjectAuxiliaryVO.setReferId(auxiliaryEntity.getReferId());
                        subjectAuxiliaryVO.setReferCode(auxiliaryEntity.getReferCode());
                        subjectAuxiliaryVO.setReferName(auxiliaryEntity.getReferName());
                        subjectAuxiliaryVO.setSubjectId(subjectVO.getId());
                        subjectAuxiliaryVOS.add(subjectAuxiliaryVO);
                        continue;
                    }
                    errMsg.append("`\u8f85\u52a9\u6838\u7b97\u9879[" + auxiliaryName + "]\u4e0d\u5b58\u5728\u3001\u53ef\u5ffd\u7565\u5bfc\u5165`");
                    errorFlag.append("1");
                }
                if (CollectionUtils.isNotEmpty(subjectAuxiliaryVOS)) {
                    List _auxiliaryIds = subjectAuxiliaryVOS.stream().map(t -> t.getAuxiliaryId()).collect(Collectors.toList());
                    List _auxiliaryNames = subjectAuxiliaryVOS.stream().map(t -> t.getAuxiliaryName()).collect(Collectors.toList());
                    subjectVO.setAuxiliaryIds(StringUtils.join(_auxiliaryIds, (String)","));
                    subjectVO.setAuxiliaryNames(StringUtils.join(_auxiliaryNames, (String)","));
                    subjectVO.setSubjectAuxiliaryList(subjectAuxiliaryVOS);
                } else {
                    subjectVO.setAuxiliaryIds(null);
                    subjectVO.setAuxiliaryNames(null);
                    subjectVO.setSubjectAuxiliaryList(null);
                }
                subjectVO.setErrMsg(errMsg.toString());
            } else {
                subjectVO.setAuxiliaryIds(null);
                subjectVO.setAuxiliaryNames(null);
                subjectVO.setSubjectAuxiliaryList(null);
            }
            if (!errorFlag.toString().contains("2")) {
                if (subjectVO.getId() == null) {
                    subjectVO.setId(Long.valueOf(IdWorker.getId()));
                }
                String code = subjectVO.getSubjectCode();
                if (subjectCodeType == 1) {
                    if (!code.contains(subjectCodeRule)) {
                        subjectVO.setInnerCode(String.valueOf(subjectVO.getId()));
                    } else {
                        String parentCode = code.substring(0, code.lastIndexOf(subjectCodeRule));
                        SubjectVO parentVO = (SubjectVO)parentMap.get(parentCode);
                        subjectVO.setParentId(parentVO.getId());
                        subjectVO.setInnerCode(parentVO.getInnerCode() + "|" + subjectVO.getId());
                    }
                } else {
                    int codeLen = code.length();
                    Integer par = (Integer)selfRuleMap.get(codeLen);
                    if (par == null) {
                        subjectVO.setInnerCode(String.valueOf(subjectVO.getId()));
                    } else {
                        String parentCode = code.substring(0, par);
                        SubjectVO parentVO = (SubjectVO)parentMap.get(parentCode);
                        subjectVO.setParentId(parentVO.getId());
                        subjectVO.setInnerCode(parentVO.getInnerCode() + "|" + subjectVO.getId());
                    }
                }
                parentMap.put(code, subjectVO);
                successList.add(subjectVO);
            }
            if (!StringUtils.isNotBlank((CharSequence)subjectVO.getErrMsg())) continue;
            errorList.add(subjectVO);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, SubjectVO.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<SubjectVO> subjectVOS) {
        return CommonResponse.success((String)this.service.saveImport(subjectVOS));
    }

    public static void main(String[] args) {
        String a = "186-09";
        String[] split = a.split("\\-");
        System.out.println(split.length);
        StringBuilder stringBuilder = new StringBuilder();
        System.out.println(StringUtils.isNotEmpty((CharSequence)stringBuilder.toString()));
    }
}

