/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.custransfer.sjyg;

import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.BaseVoucherBusinessService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.vo.VoucherParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SJYGProductionVoucherCusTransferService")
public class SJYGProductionVoucherCusTransferService
extends BaseVoucherBusinessService
implements IVoucherTransferService {
    private static final Logger log = LoggerFactory.getLogger(SJYGProductionVoucherCusTransferService.class);
    private static final String MARKER_COLUMN = null;
    private static final String BUSINESS_DATE_COLUMN = "productionDate";
    private static final String SRC_BILL_PC_URL = "srcBillPcUrl";
    private static final String SRC_BILL_ORG_COLUMN = "orgId";
    private static final String VOUCHER_TYPE = "PRE001:\u8bb0";
    private static final String RATE_TYPE = "HLTX01_SYS";
    private static final String CURRENCY_CODE = "PRE001";
    private static final String SUBJECT_CODE = "2001.01";
    private static final String DESCRIPTION_EXPRESSION = "projectName + '_' + billTypeName";
    private static final String SUBJECT_CONTRAST_CODE = "production01";
    private static final String DESCRIPTION_EXPRESSION_VIEW = "\u4ea7\u503c\u624b\u52a8\u5f55\u5165\u6458\u8981";
    private static final String MNY_EXPRESSION = "finishTaxMny";

    @Override
    public void transfer(VoucherParams voucherParams) {
        VoucherTemplateVO voucherTemplateVO = new VoucherTemplateVO();
        voucherTemplateVO.setMarkerColumn(MARKER_COLUMN);
        voucherTemplateVO.setBusinessDateColumn(BUSINESS_DATE_COLUMN);
        voucherTemplateVO.setSrcBillPcUrl(SRC_BILL_PC_URL);
        voucherTemplateVO.setSrcBillOrgColumn(SRC_BILL_ORG_COLUMN);
        voucherTemplateVO.setVoucherType(VOUCHER_TYPE);
        voucherTemplateVO.setRateType(RATE_TYPE);
        voucherTemplateVO.setCurrencyCode(CURRENCY_CODE);
        ArrayList<VoucherTemplateDetailVO> templateDetailVOList = new ArrayList<VoucherTemplateDetailVO>();
        VoucherTemplateDetailVO debitDetailVO = new VoucherTemplateDetailVO();
        debitDetailVO.setDirectionFlag("debit");
        debitDetailVO.setSubjectRuleFlag("subject");
        debitDetailVO.setSubjectRuleCode(SUBJECT_CODE);
        debitDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION);
        debitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(debitDetailVO);
        VoucherTemplateDetailVO crebitDetailVO = new VoucherTemplateDetailVO();
        crebitDetailVO.setDirectionFlag("crebit");
        crebitDetailVO.setSubjectRuleFlag("subjectContrast");
        crebitDetailVO.setSubjectRuleCode(SUBJECT_CONTRAST_CODE);
        crebitDetailVO.setDescriptionExpressionView(DESCRIPTION_EXPRESSION_VIEW);
        crebitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(crebitDetailVO);
        voucherTemplateVO.setVoucherTemplateDetailList(templateDetailVOList);
        OriginVoucherVO originVoucherVO = this.transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVOList(Arrays.asList(originVoucherVO));
        Map<String, Object> financeVoucher = this.transferFinanceVoucherByOriginVoucher(voucherParams);
        voucherParams.setFinanceVoucher(financeVoucher);
    }
}

