/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.datacenter.impl;

import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.datacenter.pojo.GatewayAddressResponse;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import com.ejianc.business.yonyou.base.properties.UCFCoreProperties;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public abstract class DataCenterUrlProviderImpl
implements DataCenterUrlProvider {
    @Resource
    RestTemplate restTemplate;
    @Value(value="${ucf.mdd.active}")
    private String active;
    @Resource
    OpenApiProperties properties;
    @Resource
    UCFCoreProperties ucfCoreProperties;

    private boolean moreDataCenter() {
        String[] supportDataCenterEnv = new String[]{"production", "sandbox"};
        return Arrays.asList(supportDataCenterEnv).contains(this.active);
    }

    @Override
    public String buildBusinessUrl() {
        return this.useGatewayAddress().getGatewayUrl();
    }

    @Override
    public String buildTokenUrl() {
        return this.useGatewayAddress().getTokenUrl();
    }

    private GatewayAddressResponse.GatewayAddressDTO useGatewayAddress() {
        GatewayAddressResponse.GatewayAddressDTO gatewayAddressDTO = null;
        gatewayAddressDTO = this.moreDataCenter() ? this.queryGatewayAddress() : new GatewayAddressResponse.GatewayAddressDTO(this.properties.getGatewayAddressUrl(), this.properties.getGatewayAddressUrl());
        return gatewayAddressDTO;
    }

    @Override
    public String queryTenantId() {
        return this.ucfCoreProperties.getDefaultTenantId();
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

