/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public class ReSubmitUtil {
    private static final Logger log = LoggerFactory.getLogger(ReSubmitUtil.class);
    private static final String RESUbMIT_CHECK_KEY = "resubmitCheckKey";
    private static final String BASE_DATA = "data";
    private static final String STATUS_INSERT = "insert";
    private static final String STATUS = "_status";

    public static <T> T resubmitCheckKey(T t) {
        try {
            String resubmitCheckKeyV = ReSubmitUtil.md5Encode(t);
            Object reqData = ReSubmitUtil.getRealData(t);
            BeanUtils.setProperty((Object)reqData, (String)RESUbMIT_CHECK_KEY, (Object)resubmitCheckKeyV);
        }
        catch (Exception e) {
            log.info("\u5e42\u7b49\u53c2\u6570\u6dfb\u52a0\u5f02\u5e38:" + JSON.toJSON(t).toString());
        }
        return t;
    }

    public static <T> T resubmitCheckKey(T t, String dateFormat) {
        try {
            String resubmitCheckKeyV = ReSubmitUtil.md5EncodeTime(t, dateFormat);
            Object reqData = ReSubmitUtil.getRealData(t);
            BeanUtils.setProperty((Object)reqData, (String)RESUbMIT_CHECK_KEY, (Object)resubmitCheckKeyV);
        }
        catch (Exception e) {
            log.info("\u5e42\u7b49\u53c2\u6570\u6dfb\u52a0\u5f02\u5e38:" + JSON.toJSON(t).toString());
        }
        return t;
    }

    private static Object getRealData(Object object) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String isData = BeanUtils.getProperty((Object)object, (String)BASE_DATA);
        if (!StringUtils.isEmpty((CharSequence)isData)) {
            object = PropertyUtils.getProperty((Object)object, (String)BASE_DATA);
        }
        return object;
    }

    public static String md5Encode(Object object) {
        byte[] bytes = JSON.toJSONBytes((Object)object, (SerializerFeature[])new SerializerFeature[0]);
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    public static String md5EncodeTime(Object object, String dateFormat) {
        byte[] bytes = JSON.toJSONBytes((Object)object, (SerializerFeature[])new SerializerFeature[0]);
        SimpleDateFormat date = new SimpleDateFormat(dateFormat);
        return DigestUtils.md5DigestAsHex((byte[])bytes).substring(8, 24) + date.format(new Date());
    }
}

