/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.originvoucher.service.impl;

import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherAuxiliaryEntity;
import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherEntity;
import com.ejianc.business.accplat.originvoucher.mapper.OriginVoucherMapper;
import com.ejianc.business.accplat.originvoucher.service.IOriginVoucherService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="originVoucherService")
public class OriginVoucherServiceImpl
extends BaseServiceImpl<OriginVoucherMapper, OriginVoucherEntity>
implements IOriginVoucherService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ORIGN_VOUCHER_CODE";

    @Override
    public void saveOriginVouchers(List<OriginVoucherVO> originVoucherVOS) {
        for (OriginVoucherVO originVoucherVO : originVoucherVOS) {
            originVoucherVO.setId(Long.valueOf(IdWorker.getId()));
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)originVoucherVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            originVoucherVO.setVoucherCode((String)billCode.getData());
            ArrayList<OriginVoucherAuxiliaryEntity> originVoucherAuxiliaryList = new ArrayList<OriginVoucherAuxiliaryEntity>();
            List originVoucherEntryList = originVoucherVO.getOriginVoucherEntryList();
            if (CollectionUtils.isNotEmpty((Collection)originVoucherEntryList)) {
                for (OriginVoucherEntryVO originVoucherEntryVO : originVoucherEntryList) {
                    originVoucherEntryVO.setId(Long.valueOf(IdWorker.getId()));
                    List originVoucherAuxiliaryVOList = originVoucherEntryVO.getOriginVoucherAuxiliaryVOList();
                    if (!CollectionUtils.isNotEmpty((Collection)originVoucherAuxiliaryVOList)) continue;
                    for (OriginVoucherAuxiliaryVO auxiliaryVO : originVoucherAuxiliaryVOList) {
                        auxiliaryVO.setEntryId(originVoucherEntryVO.getId());
                        auxiliaryVO.setOriginVoucherId(originVoucherVO.getId());
                        originVoucherAuxiliaryList.add((OriginVoucherAuxiliaryEntity)((Object)BeanMapper.map((Object)auxiliaryVO, OriginVoucherAuxiliaryEntity.class)));
                    }
                }
            }
            OriginVoucherEntity entity = (OriginVoucherEntity)((Object)BeanMapper.map((Object)originVoucherVO, OriginVoucherEntity.class));
            if (CollectionUtils.isNotEmpty(originVoucherAuxiliaryList)) {
                entity.setOriginVoucherAuxiliaryList(originVoucherAuxiliaryList);
            }
            this.saveOrUpdate((Object)entity, false);
        }
    }
}

