/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.api;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.exception.BusinessException;
import com.ejianc.business.yonyou.base.module.auth.OpenApiAuthProviderFactory;
import com.ejianc.business.yonyou.base.module.common.OpenApiAccessToken;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import com.ejianc.business.yonyou.base.response.OpenApiResponse;
import com.ejianc.business.yonyou.utils.ReSubmitUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class BaseOpenApi {
    private static final Logger log = LoggerFactory.getLogger(BaseOpenApi.class);
    @Resource
    OpenApiAuthProviderFactory authProvider;
    @Resource
    RestTemplate restTemplate;
    @Resource
    OpenApiProperties properties;
    @Resource
    DataCenterUrlProvider dataCenterUrlProvider;
    private static String baseFilePath = "src/main/resources/file/";

    public <T> T getForEntity(String urlFragment, Map<String, String> params, Class<T> responseType) {
        String reqUrl = this.buildGetRequestUrl(urlFragment, params);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(reqUrl, responseType, new Object[0]);
        return (T)responseEntity.getBody();
    }

    public <T> T postForEntity(String urlFragment, Object params, Class<T> responseType, boolean isEnableResubmit) {
        if (isEnableResubmit) {
            ReSubmitUtil.resubmitCheckKey(params);
        }
        if (params != null) {
            log.info("\u7528\u53cb\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSON((Object)params).toString());
        }
        return this.postForEntity(urlFragment, params, responseType);
    }

    public <T> T postForEntity(String urlFragment, Object params, Class<T> responseType, boolean isEnableResubmit, String dateFormat) {
        if (isEnableResubmit) {
            ReSubmitUtil.resubmitCheckKey(params, dateFormat);
        }
        if (params != null) {
            log.info("\u7528\u53cb\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSON((Object)params).toString());
        }
        return this.postForEntity(urlFragment, params, responseType);
    }

    public <T> T postForEntity(String urlFragment, Map<String, String> headers, Object params, Class<T> responseType) {
        String reqUrl = this.buildGetRequestUrl(urlFragment, headers);
        if (params != null) {
            log.info("\u7528\u53cb\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSON((Object)params).toString());
        }
        ResponseEntity responseEntity = this.restTemplate.postForEntity(reqUrl, params, responseType, new Object[0]);
        return (T)responseEntity.getBody();
    }

    public <T> T postForEntity(String urlFragment, Object params, Class<T> responseType) {
        String reqUrl = this.buildPostRequestUrl(urlFragment);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(reqUrl, params, responseType, new Object[0]);
        return (T)responseEntity.getBody();
    }

    public <T> T postForEntityUrl(String reqUrl, Object params, Class<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.postForEntity(reqUrl, params, responseType, new Object[0]);
        return (T)responseEntity.getBody();
    }

    public <T> T getData(OpenApiResponse<T> body) {
        if (body == null) {
            throw new BusinessException("unexpected response null when request open api isv access token");
        }
        body.check();
        log.info(JSON.toJSONString(body));
        return body.getData();
    }

    protected String buildPostRequestUrl(String urlFragment) {
        String host = this.dataCenterUrlProvider.buildBusinessUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", this.getISVAccessToken().getAccessToken());
        String url = this.properties.concatParam(host + urlFragment, this.properties.buildQueryString(params, false));
        log.info("\u7528\u53cb\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42:" + url);
        return url;
    }

    protected String buildGetRequestUrl(String urlFragment, Map<String, String> params) {
        if (MapUtils.isEmpty(params)) {
            return this.buildPostRequestUrl(urlFragment);
        }
        return this.properties.concatURL(this.buildPostRequestUrl(urlFragment), "&", this.properties.buildQueryString(params, false));
    }

    protected OpenApiAccessToken getISVAccessToken() {
        return this.authProvider.getAuthProvider().buildISVAuthToken();
    }

    public <T> T file(String urlFragment, String filePath, Map<String, String> header, Class<T> responseType) {
        String reqUrl = this.buildGetRequestUrl(urlFragment, header);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"multipart/form-data");
        headers.setContentType(type);
        String path = new ClassPathResource(baseFilePath + filePath).getPath();
        FileSystemResource fileSystemResource = new FileSystemResource(path);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"files", (Object)fileSystemResource);
        HttpEntity files = new HttpEntity((Object)form, (MultiValueMap)headers);
        return (T)this.restTemplate.postForObject(reqUrl, (Object)files, responseType, new Object[0]);
    }

    public <T> T fileForPost(String urlFragment, MultiValueMap<String, Object> multimValueMap, Class<T> responseType) {
        String reqUrl = this.buildPostRequestUrl(urlFragment);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"multipart/form-data");
        headers.setContentType(type);
        HttpEntity files = new HttpEntity(multimValueMap, (MultiValueMap)headers);
        return (T)this.restTemplate.postForObject(reqUrl, (Object)files, responseType, new Object[0]);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public OpenApiProperties getProperties() {
        return this.properties;
    }
}

