/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.module.auth.isv.impl;

import com.ejianc.business.yonyou.base.module.auth.isv.ISVCryptoService;
import com.ejianc.business.yonyou.base.network.cryptor.EncryptionHolder;
import com.ejianc.business.yonyou.base.network.cryptor.ISVRequestCrypto;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISVCryptoServiceImpl
implements ISVCryptoService {
    private static final Logger log = LoggerFactory.getLogger(ISVCryptoServiceImpl.class);
    private final OpenApiProperties properties;

    @Override
    public String decrypt(EncryptionHolder holder) {
        ISVRequestCrypto crypto = this.buildCrypto();
        return crypto.decrypt(holder);
    }

    @Override
    public EncryptionHolder encrypt(String source) {
        ISVRequestCrypto crypto = this.buildCrypto();
        return crypto.encrypt(source);
    }

    private ISVRequestCrypto buildCrypto() {
        return new ISVRequestCrypto(this.properties.getAppKey(), this.properties.getAppSecret());
    }

    public ISVCryptoServiceImpl(OpenApiProperties properties) {
        this.properties = properties;
    }
}

