/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.module.auth.tenant.impl;

import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.exception.BusinessException;
import com.ejianc.business.yonyou.base.module.auth.pojo.OpenApiAccessTokenResponse;
import com.ejianc.business.yonyou.base.module.auth.tenant.TenantAuthProvider;
import com.ejianc.business.yonyou.base.module.common.OpenApiAccessToken;
import com.ejianc.business.yonyou.base.module.token.OpenApiTokenCacheProvider;
import com.ejianc.business.yonyou.base.network.OpenApiRequestEncryptor;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class TenantAuthProviderImpl
implements TenantAuthProvider {
    private static final Logger log = LoggerFactory.getLogger(TenantAuthProviderImpl.class);
    private static final String URL_TOKEN = "open-auth/selfAppAuth/getAccessToken?signature=%s&appKey=%s&timestamp=%s";
    private final OpenApiProperties properties;
    private final OpenApiRequestEncryptor encryptor;
    private final RestTemplate restTemplate;
    @Resource
    OpenApiTokenCacheProvider cacheProvider;
    @Resource
    DataCenterUrlProvider dataCenterUrlProvider;

    @Override
    public OpenApiAccessToken buildTenantAuthToken() {
        OpenApiAccessToken token = this.cacheProvider.loadTokenFromCache(this.dataCenterUrlProvider.queryTenantId());
        if (token != null && token.getExpiredAt() > System.currentTimeMillis()) {
            return token;
        }
        return this.buildTenantAuthTokenFromRemote();
    }

    public OpenApiAccessToken buildTenantAuthTokenFromRemote() {
        URI uri;
        long timestamp = System.currentTimeMillis();
        String appKey = this.properties.getAppKey();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appKey", appKey);
        params.put("timestamp", String.valueOf(timestamp));
        String signature = this.encryptor.signature(params, this.properties.getAppSecret());
        String url = this.properties.concatURL(this.dataCenterUrlProvider.buildTokenUrl(), String.format(URL_TOKEN, signature, appKey, timestamp));
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new BusinessException("invalid open api uri format", e);
        }
        ResponseEntity responseEntity = this.restTemplate.getForEntity(uri, OpenApiAccessTokenResponse.class);
        OpenApiAccessTokenResponse body = (OpenApiAccessTokenResponse)responseEntity.getBody();
        if (body != null) {
            body.check();
            OpenApiAccessToken accessToken = ((OpenApiAccessToken.OpenApiAccessTokenDTO)body.getData()).build();
            this.cacheProvider.saveTokenToCache(this.dataCenterUrlProvider.queryTenantId(), accessToken);
            return accessToken;
        }
        throw new BusinessException("Unexpected empty response encountered when request open api access token");
    }

    @Override
    public OpenApiAccessToken buildISVAuthToken() {
        return this.buildTenantAuthToken();
    }

    public TenantAuthProviderImpl(OpenApiProperties properties, OpenApiRequestEncryptor encryptor, RestTemplate restTemplate) {
        this.properties = properties;
        this.encryptor = encryptor;
        this.restTemplate = restTemplate;
    }
}

