/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.config.service.IBillVoucherSetService;
import com.ejianc.business.accplat.config.vo.BillVoucherSetVO;
import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherEntity;
import com.ejianc.business.accplat.originvoucher.service.IOriginVoucherService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.service.BaseVoucherBusinessService;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.transfer.VoucherTransferFactory;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherBusinessService
extends BaseVoucherBusinessService {
    private static final Logger log = LoggerFactory.getLogger(VoucherBusinessService.class);
    @Autowired
    private VoucherTransferFactory voucherTransferFactory;
    @Autowired
    private IBillVoucherSetService billVoucherSetService;
    @Autowired
    private IOriginVoucherService originVoucherService;

    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        log.info(" ============================= ");
        log.info(" \u4e1a\u52a1\u53c2\u6570(\u6784\u5efa\u524d)voucherParams:" + DataConvertUtil.objToString((Object)voucherParams));
        log.info(" ============================= ");
        BillTypeVO billTypeVO = voucherParams.getBillTypeVO();
        Map billData = voucherParams.getBillData();
        billData.put("billTypeCode", billTypeVO.getBillCode());
        billData.put("billTypeName", billTypeVO.getBillName());
        BillVoucherSetVO billVoucherSetVO = voucherParams.getBillVoucherSetVO();
        String serviceName = StringUtils.isEmpty((CharSequence)billVoucherSetVO.getCustomTransferServiceName()) ? "commonVoucherTransferService" : billVoucherSetVO.getCustomTransferServiceName();
        IVoucherTransferService voucherTransferService = this.voucherTransferFactory.getVoucherTransferService(serviceName);
        voucherTransferService.transfer(voucherParams);
        this.checkVoucherParams(voucherParams);
        log.info(" ============================= ");
        log.info(" \u4e1a\u52a1\u53c2\u6570(\u6784\u5efa\u540e)voucherParams:" + DataConvertUtil.objToString((Object)voucherParams));
        log.info(" ============================= ");
        List originVoucherVOList = voucherParams.getOriginVoucherVOList();
        boolean financeflag = true;
        Boolean isGenerateFinanceVoucherFlag = voucherParams.getIsGenerateFinanceVoucherFlag();
        CommonResponse<VoucherInfo> response = CommonResponse.success();
        if (isGenerateFinanceVoucherFlag.booleanValue()) {
            response = this.getFinanceVoucherService(voucherParams.getFinanceSystemCode()).save(voucherParams);
            financeflag = response.isSuccess();
            VoucherInfo voucherInfo = (VoucherInfo)response.getData();
            if (financeflag) {
                List vouchers = voucherInfo.getVouchers();
                for (int i = 0; i < vouchers.size(); ++i) {
                    VoucherSimpleVO voucherSimpleVO = (VoucherSimpleVO)vouchers.get(i);
                    OriginVoucherVO originVoucherVO = (OriginVoucherVO)originVoucherVOList.get(i);
                    originVoucherVO.setFinanceVoucherFlag(voucherInfo.getVoucherFlag());
                    originVoucherVO.setFinanceVoucherId(voucherSimpleVO.getFinanceVoucherId());
                    originVoucherVO.setFinanceVoucherCode(voucherSimpleVO.getFinanceVoucherCode());
                    originVoucherVO.setFinanceVoucherInfo(DataConvertUtil.objToString((Object)voucherInfo));
                }
            } else {
                for (OriginVoucherVO originVoucherVO : originVoucherVOList) {
                    originVoucherVO.setFinanceVoucherFlag(VoucherFlag.FAILED);
                    originVoucherVO.setFinanceVoucherInfo(response.getMsg());
                }
            }
        }
        if (voucherParams.getIsGenerateOriginVoucherFlag().booleanValue() && financeflag) {
            this.originVoucherService.saveOriginVouchers(originVoucherVOList);
        }
        return response;
    }

    public CommonResponse<List<OriginVoucherVO>> get(VoucherInfo voucherInfo) {
        return this.getFinanceVoucherService(voucherInfo.getFinanceSystemCode()).get(voucherInfo);
    }

    public CommonResponse del(VoucherInfo voucherInfo) {
        Long billId;
        CommonResponse response = this.getFinanceVoucherService(voucherInfo.getFinanceSystemCode()).del(voucherInfo);
        boolean success = response.isSuccess();
        if (success && (billId = voucherInfo.getBillId()) != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OriginVoucherEntity::getSrcBillId, (Object)billId);
            List list = this.originVoucherService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.originVoucherService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
        }
        return response;
    }

    public Boolean isGenerateVoucher(VoucherParams voucherParams) {
        String billTypeCode = voucherParams.getBillTypeCode();
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper voucherSetEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        voucherSetEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
        voucherSetEntityLambdaQueryWrapper.eq(BillVoucherSetEntity::getBillTypeCode, (Object)billTypeCode);
        BillVoucherSetEntity voucherSetEntity = (BillVoucherSetEntity)((Object)this.billVoucherSetService.getOne((Wrapper)voucherSetEntityLambdaQueryWrapper));
        if (voucherSetEntity == null) {
            throw new BusinessException("\u8be5\u5355\u636e\u3010\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "\u3011\u672a\u8bbe\u7f6e\u4f20\u4f1a\u8ba1\u51ed\u8bc1\u53c2\u6570\uff01");
        }
        StringBuilder msgBuilder = new StringBuilder();
        Boolean enabled = voucherSetEntity.getEnabled() == 1;
        msgBuilder.append("`\u4f20\u4f1a\u8ba1\u51ed\u8bc1\u542f\u7528\u6807\u8bc6\uff1a" + enabled + "`");
        String conditionExpression = voucherSetEntity.getConditionExpression();
        if (StringUtils.isNotBlank((CharSequence)conditionExpression)) {
            Boolean condiBool = (Boolean)this.executeOneExpression(conditionExpression, voucherParams.getBillData(), billTypeCode, "&&");
            msgBuilder.append("`\u6761\u4ef6\u8868\u8fbe\u5f0f\uff1a" + conditionExpression + "\uff0c\u7ed3\u679c\uff1a" + condiBool + "`");
            enabled = enabled != false && condiBool != false;
        }
        voucherParams.setIsGenerateOriginVoucherFlag(enabled);
        voucherParams.setIsGenerateFinanceVoucherFlag(enabled);
        voucherParams.setBillVoucherSetVO((BillVoucherSetVO)BeanMapper.map((Object)((Object)voucherSetEntity), BillVoucherSetVO.class));
        voucherParams.setMsgInfo(msgBuilder.toString());
        return enabled;
    }

    private IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        return this.voucherTransferFactory.getFinanceVoucherService(systemCode);
    }

    private void checkVoucherParams(VoucherParams voucherParams) {
        Boolean isGenerateOriginVoucherFlag = voucherParams.getIsGenerateOriginVoucherFlag();
        Boolean isGenerateFinanceVoucherFlag = voucherParams.getIsGenerateFinanceVoucherFlag();
        List originVoucherVOList = voucherParams.getOriginVoucherVOList();
        Map financeVoucher = voucherParams.getFinanceVoucher();
        if (isGenerateOriginVoucherFlag.booleanValue() && CollectionUtils.isEmpty((Collection)originVoucherVOList)) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u539f\u59cb\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u4f46\u7f3a\u4e4f\u539f\u59cb\u51ed\u8bc1\u6570\u636e[originVoucherVOList]");
        }
        if (isGenerateFinanceVoucherFlag.booleanValue() && financeVoucher == null) {
            throw new BusinessException("\u51ed\u8bc1\u6784\u5efa\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a\u751f\u6210\u8d22\u52a1\u51ed\u8bc1\u6807\u8bc6\u4e3a\u662f\uff0c\u7f3a\u4e4f\u8d22\u52a1\u51ed\u8bc1\u53c2\u6570[financeVoucher]");
        }
    }

    public CommonResponse<OriginVoucherVO> getOne(VoucherApiQueryVO voucherApiQueryVO) {
        return this.getFinanceVoucherService(voucherApiQueryVO.getFinanceSystemCode()).getOne(voucherApiQueryVO);
    }
}

