/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.kingdee.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.kingdee.api.KingDeeGalaxyInvokeHelper;
import com.ejianc.business.kingdee.base.consts.KingDeeQueryConsts;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.SuccessEntity;
import com.ejianc.business.kingdee.base.vo.query.KingDeeVoucherListApiQueryVO;
import com.ejianc.business.kingdee.base.vo.save.FACCOUNTID;
import com.ejianc.business.kingdee.base.vo.save.FAccountBookID;
import com.ejianc.business.kingdee.base.vo.save.FCURRENCYID;
import com.ejianc.business.kingdee.base.vo.save.FDetailID;
import com.ejianc.business.kingdee.base.vo.save.FEXCHANGERATETYPE;
import com.ejianc.business.kingdee.base.vo.save.FEntity;
import com.ejianc.business.kingdee.base.vo.save.KingDeeVoucherApiSaveVO;
import com.ejianc.business.kingdee.base.vo.save.Model;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class KingDeeGalaxyVoucherService
extends KingDeeGalaxyInvokeHelper
implements IFinanceVoucherService {
    @Value(value="${kdapi.access-type}")
    private boolean accessType;

    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            Map map = voucherParams.getFinanceVoucher();
            Object model = map.get("Model");
            RepoResult repoResult = null;
            repoResult = model instanceof List ? this.batchSave("GL_VOUCHER", DataConvertUtil.objToString((Object)map)) : this.save("GL_VOUCHER", DataConvertUtil.objToString((Object)map));
            if (repoResult.isSuccess()) {
                LinkedList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                LinkedList<VoucherSimpleVO> voucherSimpleVOS = new LinkedList<VoucherSimpleVO>();
                for (SuccessEntity successEntity : successEntitys) {
                    VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                    voucherSimpleVO.setFinanceVoucherId(successEntity.getId());
                    voucherSimpleVO.setFinanceVoucherCode(successEntity.getNumber());
                    voucherSimpleVOS.add(voucherSimpleVO);
                }
                return CommonResponse.success((Object)VoucherInfo.getVoucherInfo(voucherSimpleVOS));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            Map map = voucherParams.getFinanceVoucher();
            RepoResult repoResult = this.batchSave("GL_VOUCHER", DataConvertUtil.objToString((Object)map));
            if (repoResult.isSuccess()) {
                LinkedList<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                LinkedList<VoucherSimpleVO> voucherSimpleVOS = new LinkedList<VoucherSimpleVO>();
                for (SuccessEntity successEntity : successEntitys) {
                    VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                    voucherSimpleVO.setFinanceVoucherId(successEntity.getId());
                    voucherSimpleVO.setFinanceVoucherCode(successEntity.getNumber());
                    voucherSimpleVOS.add(voucherSimpleVO);
                }
                return CommonResponse.success((Object)VoucherInfo.getVoucherInfo(voucherSimpleVOS));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public CommonResponse<List<OriginVoucherVO>> get(VoucherInfo voucherInfo) {
        String financeSystemCode = voucherInfo.getFinanceSystemCode();
        List vouchers = voucherInfo.getVouchers();
        if (CollectionUtils.isEmpty((Collection)vouchers)) {
            throw new BusinessException("vouchers\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            if (vouchers.size() == 1) {
                VoucherSimpleVO voucherSimpleVO = (VoucherSimpleVO)vouchers.get(0);
                VoucherApiQueryVO voucherApiQueryVO = new VoucherApiQueryVO();
                voucherApiQueryVO.setFinanceVoucherId(voucherSimpleVO.getFinanceVoucherId());
                CommonResponse<OriginVoucherVO> one = this.getOne(voucherApiQueryVO);
                OriginVoucherVO data = (OriginVoucherVO)one.getData();
                data.setFinanceSystemCode(financeSystemCode);
                resp = CommonResponse.success(Arrays.asList(data));
            } else {
                KingDeeVoucherListApiQueryVO kingDeeVoucherListApiQueryVO = new KingDeeVoucherListApiQueryVO();
                List<String> ids = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.toList());
                kingDeeVoucherListApiQueryVO.setFilterStringForEqIds(ids);
                List<Map<String, Object>> list = this.executeBillQuery(DataConvertUtil.objToString((Object)kingDeeVoucherListApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
                ArrayList<OriginVoucherVO> originVoucherVOS = new ArrayList<OriginVoucherVO>();
                for (Map<String, Object> voucherMap : list) {
                    OriginVoucherVO originVoucherVO = new OriginVoucherVO();
                    originVoucherVO.setVoucherCode(String.valueOf(voucherMap.get("FVOUCHERID")));
                    originVoucherVO.setVoucherDate(DataConvertUtil.getDate((Object)voucherMap.get("FDate")));
                    originVoucherVO.setFinanceVoucherId(String.valueOf(voucherMap.get("FVOUCHERID")));
                    originVoucherVO.setFinanceVoucherCode(String.valueOf(voucherMap.get("FVOUCHERID")));
                    originVoucherVO.setFinanceVoucherPeriod(String.valueOf(voucherMap.get("FPERIOD")));
                    originVoucherVO.setFinanceSystemCode(financeSystemCode);
                    originVoucherVOS.add(originVoucherVO);
                }
                resp = CommonResponse.success(originVoucherVOS);
            }
        }
        return resp;
    }

    @Override
    public CommonResponse<OriginVoucherVO> getOne(VoucherApiQueryVO voucherApiQueryVO) {
        JSONObject voucherentry;
        String id;
        String financeSystemCode = voucherApiQueryVO.getFinanceSystemCode();
        String financeVoucherId = voucherApiQueryVO.getFinanceVoucherId();
        Assert.notNull((Object)financeVoucherId, (String)"\u8d22\u52a1\u51ed\u8bc1ID\u3010financeVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject paramObj = new JSONObject();
        paramObj.put("Id", (Object)financeVoucherId);
        RepoResult repoResult = this.view("GL_VOUCHER", paramObj.toJSONString());
        if (!repoResult.isSuccess()) {
            throw new BusinessException(DataConvertUtil.objToString((Object)repoResult));
        }
        OriginVoucherVO originVoucherVO = new OriginVoucherVO();
        JSONObject result = (JSONObject)repoResult.getResult();
        originVoucherVO.setFinanceVoucherId(financeVoucherId);
        originVoucherVO.setFinanceVoucherCode(financeSystemCode);
        JSONObject accountbookid = result.getJSONObject("AccountBookID");
        JSONArray accountbookid_name = accountbookid.getJSONArray("Name");
        JSONObject accountbookid_name_0 = accountbookid_name.getJSONObject(0);
        originVoucherVO.setAccbookCode(accountbookid.getString("Number"));
        originVoucherVO.setAccbookName(accountbookid_name_0.getString("Value"));
        JSONObject vouchergroupid = result.getJSONObject("VOUCHERGROUPID");
        JSONArray vouchergroupid_name = vouchergroupid.getJSONArray("Name");
        JSONObject vouchergroupid_name_0 = vouchergroupid_name.getJSONObject(0);
        originVoucherVO.setVoucherTypeCode(vouchergroupid.getString("Number"));
        originVoucherVO.setVoucherTypeName(vouchergroupid_name_0.getString("Value"));
        String vouchergroupno = result.getString("VOUCHERGROUPNO");
        originVoucherVO.setVoucherCode(vouchergroupno);
        originVoucherVO.setFinanceVoucherCode(vouchergroupno);
        String period = result.getString("PERIOD");
        originVoucherVO.setFinanceVoucherPeriod(period);
        String date = result.getString("Date");
        originVoucherVO.setVoucherDate(DataConvertUtil.getDate((Object)date));
        JSONObject fcreatorid = result.getJSONObject("FCreatorId");
        String fcreatorid_name = fcreatorid.getString("Name");
        originVoucherVO.setMarkerName(fcreatorid_name);
        String documentstatus = result.getString("DocumentStatus");
        if ("D".equals(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("\u4fdd\u5b58");
        } else if ("B".equals(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("\u63d0\u4ea4");
        } else if ("C".equals(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("\u5ba1\u6838");
        }
        JSONArray gl_voucherentry = result.getJSONArray("GL_VOUCHERENTRY");
        ArrayList<OriginVoucherEntryVO> entryVOList = new ArrayList<OriginVoucherEntryVO>();
        for (int i = 0; i < gl_voucherentry.size() && !"0".equals(id = (voucherentry = gl_voucherentry.getJSONObject(i)).getString("Id")); ++i) {
            OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
            String fexplanation = voucherentry.getString("FEXPLANATION");
            originVoucherEntryVO.setEntryDescription(fexplanation);
            JSONObject faccountid = voucherentry.getJSONObject("FACCOUNTID");
            JSONObject faccountid_fullname_0 = faccountid.getJSONArray("FullName").getJSONObject(0);
            originVoucherEntryVO.setSubjectName(faccountid_fullname_0.getString("Value"));
            JSONObject fcurrencyid = voucherentry.getJSONObject("FCURRENCYID");
            JSONObject fcurrencyid_name_0 = fcurrencyid.getJSONArray("Name").getJSONObject(0);
            originVoucherEntryVO.setCurrencyName(fcurrencyid_name_0.getString("Value"));
            String dc = voucherentry.getString("DC");
            if ("1".equals(dc)) {
                Object debit = voucherentry.get((Object)"DEBIT");
                originVoucherEntryVO.setDebitOriginalMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.toBigDecimal((Object)debit)));
                originVoucherEntryVO.setDirectionFlag("debit");
            } else {
                Object fcredit = voucherentry.get((Object)"FCREDIT");
                originVoucherEntryVO.setCreditOriginalMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.toBigDecimal((Object)fcredit)));
                originVoucherEntryVO.setDirectionFlag("credit");
            }
            JSONObject detailid = voucherentry.getJSONObject("DetailID");
            ArrayList<String> aulist = new ArrayList<String>();
            for (String key : detailid.keySet()) {
                Object value = detailid.get((Object)key);
                if (!key.startsWith("F") || !(value instanceof JSONObject)) continue;
                JSONObject valObj = (JSONObject)value;
                JSONObject nameObj = null;
                if (valObj.containsKey((Object)"Name")) {
                    nameObj = (JSONObject)valObj.getJSONArray("Name").get(0);
                } else if (valObj.containsKey((Object)"FDataValue")) {
                    nameObj = (JSONObject)valObj.getJSONArray("FDataValue").get(0);
                }
                String fnumber = Optional.ofNullable(valObj.getString("Number")).orElse(valObj.getString("FNumber"));
                String name = nameObj.getString("Value");
                aulist.add(fnumber + "/" + name);
            }
            if (CollectionUtils.isNotEmpty(aulist)) {
                originVoucherEntryVO.setAuxiliaryInfo(String.join((CharSequence)";", aulist));
            }
            entryVOList.add(originVoucherEntryVO);
        }
        originVoucherVO.setOriginVoucherEntryList(entryVOList);
        return CommonResponse.success((Object)originVoucherVO);
    }

    public CommonResponse getList(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            KingDeeVoucherListApiQueryVO kingDeeVoucherListApiQueryVO = new KingDeeVoucherListApiQueryVO();
            List vouchers = voucherInfo.getVouchers();
            List<String> ids = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.toList());
            kingDeeVoucherListApiQueryVO.setFilterStringForEqIds(ids);
            List<Map<String, Object>> maps = this.executeBillQuery(DataConvertUtil.objToString((Object)kingDeeVoucherListApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
            resp = CommonResponse.success(maps);
        }
        return this.get(voucherInfo);
    }

    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        if (!this.accessType && this.Login()) {
            List vouchers = voucherInfo.getVouchers();
            if (CollectionUtils.isEmpty((Collection)vouchers)) {
                return CommonResponse.success((String)"voucherInfo\u4e2d\u6ca1\u6709\u8d22\u52a1\u51ed\u8bc1\u4fe1\u606f\uff0c\u65e0\u9700\u5220\u9664\uff01");
            }
            String voucherIds = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.joining(","));
            JSONObject paramObj = new JSONObject();
            paramObj.put("Ids", (Object)voucherIds);
            RepoResult repoResult = this.delete("GL_VOUCHER", paramObj.toJSONString());
            if (repoResult.isSuccess()) {
                String result = String.valueOf(repoResult.getResult());
                return CommonResponse.success((Object)JSON.parseObject((String)result));
            }
            resp = repoResult.toCommonResponse();
        }
        return resp;
    }

    @Override
    public Map<String, Object> convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        List originVoucherVOs = voucherParams.getOriginVoucherVOList();
        KingDeeVoucherApiSaveVO<Object> kingDeeVoucherApiSaveVO = null;
        kingDeeVoucherApiSaveVO = originVoucherVOs.size() == 1 ? new KingDeeVoucherApiSaveVO<Object>() : new KingDeeVoucherApiSaveVO();
        LinkedList<Model> models = new LinkedList<Model>();
        for (OriginVoucherVO originVoucherVO : originVoucherVOs) {
            Model model = new Model();
            FAccountBookID fAccountBookID = new FAccountBookID();
            fAccountBookID.setFNumber(originVoucherVO.getAccbookCode());
            model.setFAccountBookID(fAccountBookID);
            Date businessDate = originVoucherVO.getBusinessDate();
            model.setFDate(DataConvertUtil.formatDate((Object)businessDate));
            List originVoucherEntryList = originVoucherVO.getOriginVoucherEntryList();
            ArrayList<FEntity> fEntityList = new ArrayList<FEntity>();
            for (OriginVoucherEntryVO entryVO : originVoucherEntryList) {
                FEntity fEntity1 = new FEntity();
                fEntity1.setFEXPLANATION(entryVO.getEntryDescription());
                FACCOUNTID faccountid = new FACCOUNTID();
                faccountid.setFNumber(entryVO.getSubjectCode());
                fEntity1.setFACCOUNTID(faccountid);
                if ("debit".equals(entryVO.getDirectionFlag())) {
                    fEntity1.setFAMOUNTFOR(entryVO.getDebitOriginalMny());
                    fEntity1.setFDEBIT(entryVO.getDebitOriginalMny());
                } else {
                    fEntity1.setFAMOUNTFOR(entryVO.getCreditOriginalMny());
                    fEntity1.setFCREDIT(entryVO.getCreditOriginalMny());
                }
                FCURRENCYID fcurrencyid = new FCURRENCYID();
                fcurrencyid.setFNumber(entryVO.getCurrencyCode());
                fEntity1.setFCURRENCYID(fcurrencyid);
                FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
                fexchangeratetype.setFNumber(entryVO.getRateType());
                fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);
                List clientAuxiliaryList = entryVO.getOriginVoucherAuxiliaryVOList();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)clientAuxiliaryList)) {
                    HashMap<String, FDetailID> fDetailID = new HashMap<String, FDetailID>();
                    for (OriginVoucherAuxiliaryVO originVoucherAuxiliaryVO : clientAuxiliaryList) {
                        FDetailID fflex = new FDetailID();
                        fflex.setFNumber(originVoucherAuxiliaryVO.getAuxiliaryFsValue());
                        try {
                            BeanUtils.setProperty(fDetailID, (String)originVoucherAuxiliaryVO.getAuxiliaryFsCode(), (Object)fflex);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    fEntity1.setFDetailID(fDetailID);
                }
                fEntityList.add(fEntity1);
            }
            model.setFEntity(fEntityList);
            models.add(model);
        }
        if (models.size() == 1) {
            kingDeeVoucherApiSaveVO.setModel(models.get(0));
        } else {
            kingDeeVoucherApiSaveVO.setModel(models);
        }
        return DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO);
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "tom");
        map.put("Age", 20);
        String s = new Gson().toJson(map);
        System.out.println(s);
        KingDeeVoucherApiSaveVO<Model> kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        Model model = new Model();
        FEntity fEntity = new FEntity();
        fEntity.setFAMOUNTFOR(ComputeUtil.toBigDecimal((Integer)11));
        model.setFEntity(Arrays.asList(fEntity));
        kingDeeVoucherApiSaveVO.setModel(model);
        String s1 = new Gson().toJson(kingDeeVoucherApiSaveVO);
        System.out.println(s1);
        Map map1 = (Map)JSON.parseObject((String)new Gson().toJson(kingDeeVoucherApiSaveVO), Map.class);
        System.out.println(map1);
        System.out.println(JSONObject.toJSONString(kingDeeVoucherApiSaveVO));
    }
}

