/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.network;

import com.ejianc.business.yonyou.base.exception.BusinessException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OpenApiRequestEncryptor {
    private static final String ALGORITHM = "HmacSHA256";

    public String signature(Map<String, String> params, String appSecret) {
        byte[] bytes;
        String source = this.buildSource(params);
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            mac.init(secretKey);
            bytes = mac.doFinal(source.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BusinessException("exception when do open api token request signature", e);
        }
        String hash = Base64.getEncoder().encodeToString(bytes);
        try {
            return URLEncoder.encode(hash, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessException("implementation error, utf-8 not found, What year is it?");
        }
    }

    private String buildSource(Map<String, String> params) {
        Map<String, String> treeMap = params instanceof TreeMap ? params : new TreeMap<String, String>(params);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            builder.append(entry.getKey()).append(entry.getValue());
        }
        return builder.toString();
    }
}

