package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.AccbookEntity;
import com.ejianc.business.accplat.config.bean.SubjectChartEntity;
import com.ejianc.business.accplat.config.service.IAccbookService;
import com.ejianc.business.accplat.config.service.ISubjectChartService;
import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 账簿
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("accbook")
@Api(value = "账簿", tags = {"账簿"})
public class AccbookController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAccbookService service;
    @Autowired
    private ISubjectChartService subjectChartService;

    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AccbookVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody AccbookVO saveOrUpdateVO) {
        LambdaQueryWrapper<AccbookEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AccbookEntity::getCode, saveOrUpdateVO.getCode());
        wrapper.ne(saveOrUpdateVO.getId() != null, AccbookEntity::getId, saveOrUpdateVO.getId());
        int count = service.count(wrapper);
        if (count > 0) {
            throw new BusinessException("编码已存在！");
        }
        boolean isUpdate = false;
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setEnabled(1);
        } else {
            isUpdate = true;
        }

        AccbookEntity entity = BeanMapper.map(saveOrUpdateVO, AccbookEntity.class);
        boolean b = service.saveOrUpdate(entity, false);
        if (b && isUpdate) {
            // 修改更新下游冗余
            commonUpdateBillStateService.updateQuoteData(saveOrUpdateVO.getId(), "BT202312000001");
        }
        AccbookVO vo = BeanMapper.map(entity, AccbookVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AccbookVO> queryDetail(@RequestParam Long id) {
        AccbookEntity entity = service.selectById(id);
        AccbookVO vo = BeanMapper.map(entity, AccbookVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccbookVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AccbookVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AccbookVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<AccbookEntity> page = service.queryPage(param, false);
        IPage<AccbookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AccbookVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AccbookEntity> list = service.queryList(param);
        List<AccbookVO> accbookVOS = BeanMapper.mapList(list, AccbookVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", accbookVOS);
        ExcelExport.getInstance().export("Accbook-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAccbookData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AccbookVO>> refAccbookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "subjectChartName"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AccbookEntity> page = service.queryPage(param, false);
        IPage<AccbookVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AccbookVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("启用/停用")
    @RequestMapping(value = "/enabled", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody AccbookVO accbookVO) {
        LambdaUpdateWrapper<AccbookEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AccbookEntity::getId, accbookVO.getId());
        wrapper.set(AccbookEntity::getEnabled, accbookVO.getEnabled());
        service.update(wrapper);
        return CommonResponse.success("启用/停用成功！");
    }

    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadTemplet")
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Accbook-import.xlsx", "导入账簿");
    }


    /**
     * 导入校验
     *
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<AccbookVO> successList = new ArrayList<>();
            List<AccbookVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 3) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            LambdaQueryWrapper<SubjectChartEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SubjectChartEntity::getTenantId, InvocationInfoProxy.getTenantid());
            List<SubjectChartEntity> subjectEntities = subjectChartService.list(lambdaQueryWrapper);
            Map<String, Long> subMap = subjectEntities.stream().collect(Collectors.toMap(SubjectChartEntity::getName, SubjectChartEntity::getId));

            LambdaQueryWrapper<AccbookEntity> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(AccbookEntity::getTenantId, InvocationInfoProxy.getTenantid());
            List<AccbookEntity> accbookEntities = service.list(queryWrapper);
            List<String> accbookCodeList = accbookEntities.stream().map(AccbookEntity::getCode).collect(Collectors.toList());
            for (int i = 0; i < result.size(); i++) {
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                AccbookVO accbookVO = new AccbookVO();
                // 账簿编码
                String code = row.get(0).trim();
                if (StringUtils.isNotBlank(code)) {
                    if (accbookCodeList.contains(code)) {
                        errMsg.append("`账簿编码已存在请重新输入`");
                    } else {
                        accbookVO.setCode(code);
                    }
                } else {
                    errMsg.append("`账簿编码未填写`");
                }

                // 账簿名称
                String name = row.get(1).trim();
                if (StringUtils.isNotBlank(name)) {
                    accbookVO.setName(name);
                } else {
                    errMsg.append("`账簿名称未填写`");
                }
                //科目名称
                String subjectName = row.get(2).trim();
                if (StringUtils.isNotBlank(subjectName)) {
                    Long subId = subMap.get(subjectName);
                    if (subId != null) {
                        accbookVO.setSubjectChartId(subId);
                        accbookVO.setSubjectChartName(subjectName);
                    } else {
                        errMsg.append("`科目名称不存在请重新输入`");
                    }
                } else {
                    errMsg.append("`科目名称未填写`");
                }
                accbookVO.setEnabled(1);
                accbookVO.setEnabledName("启用");
                accbookVO.setErrMsg(errMsg.toString());
                if (StringUtils.isNotBlank(accbookVO.getErrMsg())) {
                    errorList.add(accbookVO);
                } else {
                    successList.add(accbookVO);
                }
            }


            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList, AccbookEntity.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入
     */
    @RequestMapping(value = "/saveImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<AccbookVO> accbookVOS) {
        service.saveBatch(BeanMapper.mapList(accbookVOS, AccbookEntity.class));
        return CommonResponse.success("导入成功");
    }

}
