/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.custransfer.sjyg;

import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.BaseVoucherBusinessService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.vo.VoucherParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SJYGSubSettleVoucherCusTransferService")
public class SJYGSubSettleVoucherCusTransferService
extends BaseVoucherBusinessService
implements IVoucherTransferService {
    private static final Logger log = LoggerFactory.getLogger(SJYGSubSettleVoucherCusTransferService.class);
    private static final String MARKER_COLUMN = null;
    private static final String BUSINESS_DATE_COLUMN = "settleDate";
    private static final String SRC_BILL_PC_URL = "srcBillPcUrl";
    private static final String SRC_BILL_ORG_COLUMN = "orgId";
    private static final String ACCBOOK_CODE = "S03";
    private static final String VOUCHER_TYPE = "PRE001:\u8bb0";
    private static final String RATE_TYPE = "HLTX01_SYS";
    private static final String CURRENCY_CODE = "PRE001";
    private static final String SUBJECT_CODE = "1002.01";
    private static final String DESCRIPTION_EXPRESSION = "projectName + '_' + billTypeName";
    private static final String MNY_EXPRESSION = "settleTaxMny";
    private static final String SUBJECT_CONTRAST_CODE = "subSettle03";
    private static final String DESCRIPTION_EXPRESSION_2 = "projectName + '_' + settleDetailList.code";
    private static final String MNY_EXPRESSION_2 = "settleDetailList.settleMny";

    @Override
    public void transfer(VoucherParams voucherParams) {
        VoucherTemplateVO voucherTemplateVO = new VoucherTemplateVO();
        voucherTemplateVO.setMarkerColumn(MARKER_COLUMN);
        voucherTemplateVO.setBusinessDateColumn(BUSINESS_DATE_COLUMN);
        voucherTemplateVO.setSrcBillPcUrl(SRC_BILL_PC_URL);
        voucherTemplateVO.setSrcBillOrgColumn(SRC_BILL_ORG_COLUMN);
        voucherTemplateVO.setVoucherType(VOUCHER_TYPE);
        voucherTemplateVO.setRateType(RATE_TYPE);
        voucherTemplateVO.setCurrencyCode(CURRENCY_CODE);
        AccbookVO accbook = this.getAccbook(ACCBOOK_CODE);
        voucherTemplateVO.setAccbookId(accbook.getId());
        voucherTemplateVO.setAccbookCode(accbook.getCode());
        voucherTemplateVO.setAccbookName(accbook.getName());
        voucherTemplateVO.setMarkerColumn("employeeId");
        ArrayList<VoucherTemplateDetailVO> templateDetailVOList = new ArrayList<VoucherTemplateDetailVO>();
        VoucherTemplateDetailVO debitDetailVO = new VoucherTemplateDetailVO();
        debitDetailVO.setDirectionFlag("debit");
        debitDetailVO.setSubjectRuleFlag("subject");
        SubjectVO subjectVO = this.getSubject(accbook.getSubjectChartId(), SUBJECT_CODE);
        debitDetailVO.setSubjectRuleId(subjectVO.getId());
        debitDetailVO.setSubjectRuleCode(subjectVO.getSubjectCode());
        debitDetailVO.setSubjectRuleName(subjectVO.getSubjectName());
        debitDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION);
        debitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(debitDetailVO);
        VoucherTemplateDetailVO creditDetailVO = new VoucherTemplateDetailVO();
        creditDetailVO.setDirectionFlag("credit");
        creditDetailVO.setSubjectRuleFlag("subjectContrast");
        SubjectContrastVO subjectContrast = this.getSubjectContrast(SUBJECT_CONTRAST_CODE);
        creditDetailVO.setSubjectRuleId(subjectContrast.getId());
        creditDetailVO.setSubjectRuleCode(subjectContrast.getSubjectCategoryCode());
        creditDetailVO.setSubjectRuleName(subjectContrast.getSubjectCategoryName());
        creditDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION_2);
        creditDetailVO.setMnyExpression(MNY_EXPRESSION_2);
        templateDetailVOList.add(creditDetailVO);
        voucherTemplateVO.setVoucherTemplateDetailList(templateDetailVOList);
        OriginVoucherVO originVoucherVO = this.transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVOList(Arrays.asList(originVoucherVO));
        Map<String, Object> financeVoucher = this.transferFinanceVoucherByOriginVoucher(voucherParams);
        voucherParams.setFinanceVoucher(financeVoucher);
    }
}

