/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.kingdee.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.kingdee.api.K3CloudObjectTypeAdapter;
import com.ejianc.business.kingdee.base.properties.KingDeeK3CloudProperties;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.RepoRet;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KingDeeGalaxyInvokeHelper {
    private static final Logger log = LoggerFactory.getLogger(KingDeeGalaxyInvokeHelper.class);
    @Resource
    KingDeeK3CloudProperties kingDeeK3CloudProperties;
    private static final String USER_AUTH = "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";
    private static String CookieVal = null;
    private static Map map = new HashMap();

    private HttpURLConnection initUrlConn(String url, JSONArray paras) throws Exception {
        URL postUrl = new URL(this.kingDeeK3CloudProperties.getServerUrl().concat(url));
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        if (CookieVal != null) {
            connection.setRequestProperty("Cookie", CookieVal);
        }
        if (!connection.getDoOutput()) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "application/json");
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        UUID uuid = UUID.randomUUID();
        int hashCode = uuid.toString().hashCode();
        JSONObject jObj = new JSONObject();
        jObj.put("format", (Object)1);
        jObj.put("useragent", (Object)"ApiClient");
        jObj.put("rid", (Object)hashCode);
        String parameters = KingDeeGalaxyInvokeHelper.chinaToUnicode(new Gson().toJson((Object)paras));
        jObj.put("parameters", (Object)parameters);
        jObj.put("timestamp", (Object)new Date().toString());
        jObj.put("v", (Object)"1.0");
        out.writeBytes(jObj.toString());
        out.flush();
        out.close();
        return connection;
    }

    public boolean Login() {
        boolean bResult = false;
        JSONArray jParas = new JSONArray();
        jParas.add((Object)this.kingDeeK3CloudProperties.getDbId());
        jParas.add((Object)this.kingDeeK3CloudProperties.getUserName());
        jParas.add((Object)this.kingDeeK3CloudProperties.getPassword());
        jParas.add((Object)this.kingDeeK3CloudProperties.getLcid());
        HttpURLConnection connection = null;
        try {
            String line;
            connection = this.initUrlConn(USER_AUTH, jParas);
            String key = null;
            int i = 1;
            while ((key = connection.getHeaderFieldKey(i)) != null) {
                String tempCookieVal;
                if (key.equalsIgnoreCase("Set-Cookie") && (tempCookieVal = connection.getHeaderField(i)).startsWith("kdservice-sessionid")) {
                    CookieVal = tempCookieVal;
                    break;
                }
                ++i;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String sResult = new String(line.getBytes(), "utf-8");
                bResult = line.contains("\"LoginResultType\":1");
            }
            reader.close();
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bResult;
    }

    public RepoResult save(String formId, String content) {
        return this.invoke("Save", formId, content);
    }

    public RepoResult batchSave(String formId, String content) {
        return this.invoke("BatchSave", formId, content);
    }

    public RepoResult view(String formId, String content) {
        return this.invoke("View", formId, content);
    }

    public RepoResult delete(String formId, String content) {
        return this.invoke("Delete", formId, content);
    }

    public List<Map<String, Object>> executeBillQuery(String content, String fieldKeys) {
        return this.invokeQuery("ExecuteBillQuery", content, fieldKeys);
    }

    private RepoResult invoke(String deal, String formId, String content) {
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        jParas.add((Object)formId);
        jParas.add((Object)content);
        RepoResult repoResult = null;
        try {
            String line;
            HttpURLConnection connectionInvoke = this.initUrlConn(sUrl, jParas);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));
            log.info(" ============================= ");
            log.info("\u91d1\u8776\u4e91\u661f\u7a7a\u63a5\u53e3\u53d1\u9001\u53c2\u6570:" + content);
            log.info(" ============================= ");
            String sResult = null;
            while ((line = reader.readLine()) != null) {
                sResult = new String(line.getBytes(), "utf-8");
                JSONObject jsonObject = JSONObject.parseObject((String)sResult);
                repoResult = (RepoResult)DataConvertUtil.stringToObj((String)jsonObject.getString("Result"), RepoResult.class);
            }
            log.info(" ============================= ");
            log.info("\u91d1\u8776\u4e91\u661f\u7a7a\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:" + DataConvertUtil.toPrettyFormat((Object)sResult));
            log.info(" ============================= ");
            reader.close();
            connectionInvoke.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return repoResult;
    }

    private List<Map<String, Object>> invokeQuery(String deal, String content, String fieldKeys) {
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        jParas.add((Object)content);
        String json = null;
        try {
            String line;
            HttpURLConnection connectionInvoke = this.initUrlConn(sUrl, jParas);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));
            log.info(" ============================= ");
            log.info("\u91d1\u8776\u4e91\u661f\u7a7a\u63a5\u53e3\u53d1\u9001\u53c2\u6570:" + content);
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                json = new String(line.getBytes(), "utf-8");
            }
            log.info(" ============================= ");
            log.info("\u91d1\u8776\u4e91\u661f\u7a7a\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:" + json);
            log.info(" ============================= ");
            reader.close();
            connectionInvoke.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new JsonParser().parse(json).getAsJsonArray();
        }
        catch (Exception var6) {
            throw new BusinessException("json parse error, response: [" + json + "]", (Throwable)var6);
        }
        if (json.indexOf(",\"IsSuccess\":false,") > -1) {
            throw new BusinessException(this.loadErrorMsg(json));
        }
        return this.loadDataList(json, fieldKeys);
    }

    String loadErrorMsg(String json) {
        if (json.startsWith("[[") && json.endsWith("]]")) {
            Gson gson = new Gson();
            return ((RepoRet)gson.fromJson(json.substring(2, json.length() - 2), RepoRet.class)).getResult().getResponseStatus().getErrors().get(0).getMessage();
        }
        return String.format("fail for ExecuteBillQuery:%s", json);
    }

    public static Gson buildGson(Type type) {
        Gson gs = new Gson();
        K3CloudObjectTypeAdapter adapter = new K3CloudObjectTypeAdapter(gs);
        Gson gson = new GsonBuilder().registerTypeAdapter(type, (Object)adapter).create();
        return gson;
    }

    protected List<Map<String, Object>> loadDataList(String json, String fieldKeys) {
        ArrayList<Map<String, Object>> rets = new ArrayList<Map<String, Object>>();
        Gson gson = KingDeeGalaxyInvokeHelper.buildGson(ArrayList.class);
        List rows = (List)gson.fromJson(json, rets.getClass());
        String[] fields = fieldKeys.split(",");
        Iterator var11 = rows.iterator();
        try {
            while (var11.hasNext()) {
                List darray = (List)var11.next();
                HashMap map = new HashMap();
                for (int i = 0; i < fields.length; ++i) {
                    map.put(fields[i], darray.get(i));
                }
                rets.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rets;
    }

    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + "\\u" + Integer.toHexString(chr1) : result + str.charAt(i);
        }
        return result;
    }

    static {
        map.put("Save", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc");
        map.put("BatchSave", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.BatchSave.common.kdsvc");
        map.put("View", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.View.common.kdsvc");
        map.put("Delete", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        map.put("ExecuteBillQuery", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc");
    }
}

