/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.api;

import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.service.VoucherBusinessService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voucherApi/"})
@Api(value="\u51ed\u8bc1VoucherApi", tags={"\u51ed\u8bc1VoucherApi"})
public class VoucherApi {
    private static final Logger log = LoggerFactory.getLogger(VoucherApi.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private VoucherBusinessService voucherBusinessService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @PostMapping(value={"handleVoucher"})
    public CommonResponse<VoucherInfo> handleVoucher(@RequestBody VoucherParams voucherParams, @RequestParam(value="voucherOptFlag") String voucherOptFlag) {
        Map billData = voucherParams.getBillData();
        Object billVoucherInfo = billData.get("voucherInfo");
        Object billVoucherFlag = billData.get("voucherFlag");
        Integer voucherFlag = billVoucherFlag == null ? VoucherFlag.NO_NEED : Integer.valueOf(billVoucherFlag.toString());
        VoucherInfo voucherInfo = null;
        voucherInfo = billVoucherInfo == null ? new VoucherInfo() : (VoucherInfo)DataConvertUtil.stringToObj((String)String.valueOf(billVoucherInfo), VoucherInfo.class);
        CommonResponse<String> response = CommonResponse.success();
        if (VoucherFlag.SUCCESS.equals(voucherFlag)) {
            response = this.del(voucherInfo);
            this.logger.info("{}\u5220\u9664\u51ed\u8bc1\u7ed3\u679c\uff1a{}", (Object)voucherOptFlag, (Object)DataConvertUtil.toPrettyFormat(response));
        }
        if ("del".equals(voucherOptFlag)) {
            return response;
        }
        if (response.isSuccess()) {
            response = this.save(voucherParams);
            this.logger.info("{}\u4fdd\u5b58\u51ed\u8bc1\u7ed3\u679c\uff1a{}", (Object)voucherOptFlag, (Object)DataConvertUtil.toPrettyFormat(response));
        }
        return response;
    }

    @PostMapping(value={"save"})
    public CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams) {
        log.info(" ============================= ");
        log.info(" \u4e1a\u52a1\u53c2\u6570(\u6784\u5efa\u524d)voucherParams:" + DataConvertUtil.objToString((Object)voucherParams));
        log.info(" ============================= ");
        String billTypeCode = voucherParams.getBillTypeCode();
        Long orgId = voucherParams.getOrgId();
        Map billData = voucherParams.getBillData();
        Assert.notNull((Object)billTypeCode, (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801billTypeCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billData, (String)"\u5355\u636e\u4e3b\u7ec4\u7ec7orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billData, (String)"\u5355\u636e\u6570\u636ebillData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse byCodeRes = this.billTypeApi.getByCode(billTypeCode);
        if (!byCodeRes.isSuccess()) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5355\u636e\u7c7b\u578b\u3010\u7f16\u7801\uff1a" + billTypeCode + "\u3011");
        }
        voucherParams.setBillTypeVO((BillTypeVO)byCodeRes.getData());
        Boolean isGenerateVoucher = this.voucherBusinessService.isGenerateVoucher(voucherParams);
        if (!isGenerateVoucher.booleanValue()) {
            VoucherInfo noNeedVoucherInfo = VoucherInfo.getNoNeedVoucherInfo((String)voucherParams.getMsgInfo());
            return CommonResponse.success((Object)noNeedVoucherInfo);
        }
        List<BillAccbookSetVO> billAccbookSetVOList = this.voucherBusinessService.getBillAccbookSet(orgId, billTypeCode, billData);
        voucherParams.setBillAccbookSetVOList(billAccbookSetVOList);
        Long tenantid = InvocationInfoProxy.getTenantid();
        String financeSystemCode = "kingDeeGalaxy";
        voucherParams.setFinanceSystemCode(financeSystemCode);
        CommonResponse<VoucherInfo> response = this.voucherBusinessService.save(voucherParams);
        if (response.isSuccess() && response.getData() != null) {
            VoucherInfo data = (VoucherInfo)response.getData();
            data.setFinanceSystemCode(voucherParams.getFinanceSystemCode());
            data.setBillTypeCode(billTypeCode);
            data.setBillId(voucherParams.getBillId());
        }
        return response;
    }

    @PostMapping(value={"get"})
    public CommonResponse<List<OriginVoucherVO>> get(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.get(voucherInfo);
    }

    @PostMapping(value={"getOne"})
    public CommonResponse<OriginVoucherVO> getOne(@RequestBody VoucherApiQueryVO voucherApiQueryVO) {
        String financeSystemCode = voucherApiQueryVO.getFinanceSystemCode();
        Assert.notNull((Object)financeSystemCode, (String)"\u8d22\u52a1\u7cfb\u7edf\u6807\u8bc6financeSystemCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.voucherBusinessService.getOne(voucherApiQueryVO);
    }

    @PostMapping(value={"del"})
    public CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo) {
        return this.voucherBusinessService.del(voucherInfo);
    }
}

