/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.module.auth.isv.impl;

import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.exception.BusinessException;
import com.ejianc.business.yonyou.base.module.auth.isv.ISVAuthProvider;
import com.ejianc.business.yonyou.base.module.auth.pojo.OpenApiAccessTokenResponse;
import com.ejianc.business.yonyou.base.module.common.OpenApiAccessToken;
import com.ejianc.business.yonyou.base.module.token.OpenApiTokenCacheProvider;
import com.ejianc.business.yonyou.base.network.OpenApiRequestEncryptor;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ISVAuthProviderImpl
implements ISVAuthProvider {
    private static final Logger log = LoggerFactory.getLogger(ISVAuthProviderImpl.class);
    private static final String URL_ISV_ACCESS_TOKEN = "open-auth/suiteApp/getAccessToken";
    private final RestTemplate restTemplate;
    private final OpenApiProperties properties;
    private final OpenApiRequestEncryptor encryptor;
    @Resource
    DataCenterUrlProvider dataCenterUrlProvider;
    @Resource
    OpenApiTokenCacheProvider cacheProvider;

    @Override
    public OpenApiAccessToken buildISVAuthToken() {
        String tenantId = this.dataCenterUrlProvider.queryTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new BusinessException("tenant id can not be empty when request open api access token for isv");
        }
        OpenApiAccessToken token = null;
        try {
            token = this.cacheProvider.loadTokenFromCache(tenantId);
        }
        catch (Exception e) {
            log.warn("exception when load token from cache: {}", (Object)e.getMessage());
        }
        if (token != null && token.getExpiredAt() > System.currentTimeMillis()) {
            return token;
        }
        return this.queryAccessTokenFromRemote(tenantId);
    }

    private OpenApiAccessToken queryAccessTokenFromRemote(String tenantId) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new BusinessException("tenantId is required when request isv access token");
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("tenantId", tenantId);
        String host = this.dataCenterUrlProvider.buildTokenUrl();
        URI uri = this.buildRequestUri(host, params, URL_ISV_ACCESS_TOKEN);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(uri, OpenApiAccessTokenResponse.class);
        OpenApiAccessTokenResponse body = (OpenApiAccessTokenResponse)responseEntity.getBody();
        if (body == null) {
            throw new BusinessException("unexpected response null when request open api isv access token");
        }
        body.check();
        OpenApiAccessToken data = ((OpenApiAccessToken.OpenApiAccessTokenDTO)body.getData()).build();
        this.cacheProvider.saveTokenToCache(tenantId, data);
        return data;
    }

    private URI buildRequestUri(String host, Map<String, String> params, String urlFragment) {
        URI uri;
        params.put("suiteKey", this.properties.getAppKey());
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        String signature = this.encryptor.signature(params, this.properties.getAppSecret());
        params.put("signature", signature);
        String url = this.properties.concatURL(host, urlFragment, "?", this.properties.buildQueryString(params, false));
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new BusinessException("invalid open api uri format", e);
        }
        return uri;
    }

    public ISVAuthProviderImpl(RestTemplate restTemplate, OpenApiProperties properties, OpenApiRequestEncryptor encryptor) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.encryptor = encryptor;
    }
}

