package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.AuxiliaryEntity;
import com.ejianc.business.accplat.config.service.IAuxiliaryService;
import com.ejianc.business.accplat.config.vo.AuxiliaryPresetVO;
import com.ejianc.business.accplat.config.vo.AuxiliaryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 辅助核算项
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("auxiliary")
@Api(value = "辅助核算项", tags = {"辅助核算项"})
public class AuxiliaryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAuxiliaryService service;

    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;


    private static final String AUXILIARY_CODE = "AUXILIARY_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AuxiliaryVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody AuxiliaryVO saveOrUpdateVO) {
        String auxiliaryCode = saveOrUpdateVO.getAuxiliaryCode();
        if (StringUtils.isBlank(auxiliaryCode)) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(AUXILIARY_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setAuxiliaryCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaQueryWrapper<AuxiliaryEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(AuxiliaryEntity::getAuxiliaryCode, auxiliaryCode);
            wrapper.ne(saveOrUpdateVO.getId() != null, AuxiliaryEntity::getId, saveOrUpdateVO.getId());
            int count = service.count(wrapper);
            if (count > 0) {
                throw new BusinessException("编码已存在！");
            }
        }
        boolean isUpdate = false;
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setEnabled(1);
        } else {
            isUpdate = true;
        }

        AuxiliaryEntity entity = BeanMapper.map(saveOrUpdateVO, AuxiliaryEntity.class);
        boolean b = service.saveOrUpdate(entity, false);
        if (b && isUpdate) {
            // 修改更新下游冗余
            commonUpdateBillStateService.updateQuoteData(saveOrUpdateVO.getId(), "BT202312000004");
        }
        AuxiliaryVO vo = BeanMapper.map(entity, AuxiliaryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuxiliaryVO> queryDetail(@RequestParam Long id) {
        AuxiliaryEntity entity = service.selectById(id);
        AuxiliaryVO vo = BeanMapper.map(entity, AuxiliaryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuxiliaryVO> vos) {
        service.removeByIds(vos.stream().map(AuxiliaryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AuxiliaryEntity> page = service.queryPage(param, false);
        IPage<AuxiliaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuxiliaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AuxiliaryEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Auxiliary-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAuxiliaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryVO>> refAuxiliaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("auxiliaryCode", "auxiliaryName"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AuxiliaryEntity> page = service.queryPage(param, false);
        IPage<AuxiliaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuxiliaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @ApiOperation("启用/停用")
    @RequestMapping(value = "/enabled", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody AuxiliaryVO auxiliaryVO) {
        LambdaUpdateWrapper<AuxiliaryEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AuxiliaryEntity::getId, auxiliaryVO.getId());
        wrapper.set(AuxiliaryEntity::getEnabled, auxiliaryVO.getEnabled());
        service.update(wrapper);
        return CommonResponse.success("启用/停用成功！");
    }


    @ApiOperation("引入预置核算项")
    @RequestMapping(value = "/importPreset", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importPreset(@RequestBody List<AuxiliaryPresetVO> vos) {
        LambdaQueryWrapper<AuxiliaryEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AuxiliaryEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<AuxiliaryEntity> list = service.list(queryWrapper);
        Map<String, AuxiliaryEntity> auxiliaryMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            auxiliaryMap = list.stream().collect(Collectors.toMap(AuxiliaryEntity::getAuxiliaryCode, t -> t));
        }

        List<AuxiliaryEntity> auxiliaryEntitiesSave = new ArrayList<>();
        List<String> repeatCodes = new ArrayList<>();
        StringBuilder resMsg = new StringBuilder();
        for (AuxiliaryPresetVO vo : vos) {
            String auxiliaryCode = vo.getAuxiliaryCode();
            if (auxiliaryMap.containsKey(auxiliaryCode)) {
                repeatCodes.add(auxiliaryCode);
            } else {
                AuxiliaryEntity auxiliaryEntity = new AuxiliaryEntity();
                auxiliaryEntity.setAuxiliaryCode(vo.getAuxiliaryCode());
                auxiliaryEntity.setAuxiliaryName(vo.getAuxiliaryName());
                auxiliaryEntity.setDataType(vo.getDataType());
                auxiliaryEntity.setReferId(vo.getReferId());
                auxiliaryEntity.setReferCode(vo.getReferCode());
                auxiliaryEntity.setReferName(vo.getReferName());
                auxiliaryEntity.setEnabled(1);
                auxiliaryEntitiesSave.add(auxiliaryEntity);
            }
        }

        if (CollectionUtils.isNotEmpty(auxiliaryEntitiesSave)) {
            service.saveOrUpdateBatch(auxiliaryEntitiesSave);
            resMsg.append("[成功引入预置核算项 " + auxiliaryEntitiesSave.size() + " 条]");
        }
        if (CollectionUtils.isNotEmpty(repeatCodes)) {
            resMsg.append("[引入失败 " + repeatCodes.size() + " 条，编码已存在：" + String.join("，", repeatCodes) + "]");
        }
        return CommonResponse.success(resMsg.toString());
    }


}
