package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.AuxiliaryPresetEntity;
import com.ejianc.business.accplat.config.service.IAuxiliaryPresetService;
import com.ejianc.business.accplat.config.vo.AuxiliaryPresetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 辅助核算项预置表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("auxiliaryPreset")
@Api(value = "辅助核算项预置表", tags = {"辅助核算项预置表"})
public class AuxiliaryPresetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IAuxiliaryPresetService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AuxiliaryPresetVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AuxiliaryPresetVO saveOrUpdateVO) {
    	AuxiliaryPresetEntity entity = BeanMapper.map(saveOrUpdateVO, AuxiliaryPresetEntity.class);
    	service.saveOrUpdate(entity, false);
    	AuxiliaryPresetVO vo = BeanMapper.map(entity, AuxiliaryPresetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuxiliaryPresetVO> queryDetail(@RequestParam Long id) {
    	AuxiliaryPresetEntity entity = service.selectById(id);
    	AuxiliaryPresetVO vo = BeanMapper.map(entity, AuxiliaryPresetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuxiliaryPresetVO> vos) {
        service.removeByIds(vos.stream().map(AuxiliaryPresetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryPresetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AuxiliaryPresetEntity> page = service.queryPage(param,false);
        IPage<AuxiliaryPresetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuxiliaryPresetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AuxiliaryPresetEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AuxiliaryPreset-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAuxiliaryPresetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AuxiliaryPresetVO>> refAuxiliaryPresetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AuxiliaryPresetEntity> page = service.queryPage(param,false);
        IPage<AuxiliaryPresetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuxiliaryPresetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
