package com.ejianc.business.kingdee.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.accplat.consts.AccplatConsts;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.kingdee.api.KingDeeGalaxyInvokeHelper;
import com.ejianc.business.kingdee.base.consts.FormIdConsts;
import com.ejianc.business.kingdee.base.consts.KingDeeQueryConsts;
import com.ejianc.business.kingdee.base.response.RepoResult;
import com.ejianc.business.kingdee.base.response.SuccessEntity;
import com.ejianc.business.kingdee.base.vo.query.KingDeeVoucherListApiQueryVO;
import com.ejianc.business.kingdee.base.vo.save.*;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.business.voucher.vo.VoucherSimpleVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.gson.Gson;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description: 金蝶凭证服务
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service
public class KingDeeGalaxyVoucherService extends KingDeeGalaxyInvokeHelper implements IFinanceVoucherService {

    /**
     * @description: 金蝶云星空接入模式，这家比较特殊，不同接入模式调用方式不同，无语
     *   # 是否生态模式
     *   # true: 云接入模式
     *   # false: 私有化服务接入模式
     */
    @Value("${kdapi.access-type}")
    private boolean accessType;

    /**
     * @description: 保存财务凭证
     *
     * JSONObject data = new JSONObject();
     *                 JSONObject model = new JSONObject();
     *
     *                 JSONObject _FAccountBookID = new JSONObject();
     *                 _FAccountBookID.put("FNumber", "S01");
     *                 model.put("FAccountBookID", _FAccountBookID);
     *                 model.put("FDate", "2023-12-12");
     *                 model.put("FDocumentStatus", "Z");
     *
     *
     *                 JSONObject _FVOUCHERGROUPID = new JSONObject();
     *                 _FVOUCHERGROUPID.put("FNumber", "PRE001");
     *                 model.put("FVOUCHERGROUPID", _FVOUCHERGROUPID);
     *
     *                 JSONArray _FEntity = new JSONArray();
     *
     *
     *                 JSONObject sub1 = new JSONObject();
     *
     *                 sub1.put("FEXPLANATION", "供应商摘要");
     *                 //科目编码
     *                 JSONObject _FACCOUNTID = new JSONObject();
     *                 _FACCOUNTID.put("FNumber", "2202.02");
     *                 sub1.put("FACCOUNTID", _FACCOUNTID);
     *
     *                 //币别
     *                 JSONObject _FCURRENCYID = new JSONObject();
     *                 _FCURRENCYID.put("FNumber", "PRE001");
     *                 sub1.put("FCURRENCYID", _FCURRENCYID);
     *
     *                 //汇率类型
     *                 JSONObject _FEXCHANGERATETYPE = new JSONObject();
     *                 _FEXCHANGERATETYPE.put("FNumber", "HLTX01_SYS");
     *                 sub1.put("FEXCHANGERATETYPE", _FEXCHANGERATETYPE);
     *
     *                 sub1.put("FEXCHANGERATE", "1");
     *
     *                 sub1.put("FAMOUNTFOR", 667);
     *                 sub1.put("FDEBIT", 667);
     *
     *                 //核算对象
     *                 JSONObject _FDetailID = new JSONObject();
     *                 JSONObject _FDETAILID__FFLEX4 = new JSONObject();
     *                 _FDETAILID__FFLEX4.put("FNumber", "1.001");
     *                 _FDetailID.put("FDETAILID__FFLEX4", _FDETAILID__FFLEX4);
     *                 sub1.put("FDetailID", _FDetailID);
     *
     *
     *                 JSONObject sub2 = new JSONObject();
     *                 sub2.put("FEXPLANATION", "2222");
     *                 //科目编码
     *                 JSONObject _FACCOUNTID2 = new JSONObject();
     *                 _FACCOUNTID2.put("FNumber", "1001.01");
     *                 sub2.put("FACCOUNTID", _FACCOUNTID2);
     *
     *                 //币别
     *                 JSONObject _FCURRENCYID2 = new JSONObject();
     *                 _FCURRENCYID2.put("FNumber", "PRE001");
     *                 sub2.put("FCURRENCYID", _FCURRENCYID2);
     *
     *                 //汇率类型
     *                 JSONObject _FEXCHANGERATETYPE2 = new JSONObject();
     *                 _FEXCHANGERATETYPE2.put("FNumber", "HLTX01_SYS");
     *                 sub2.put("FEXCHANGERATETYPE", _FEXCHANGERATETYPE2);
     *
     *                 sub2.put("FEXCHANGERATE", "1");
     *
     *                 sub2.put("FAMOUNTFOR", 667);
     *                 sub2.put("FCREDIT", 667);
     *
     *                 //核算对象
     *                 JSONObject _FDetailID2 = new JSONObject();
     *
     *             JSONObject _FDETAILID__FFLEX4_2 = new JSONObject();
     *             _FDETAILID__FFLEX4_2.put("FNumber", "1.001");
     *             _FDetailID2.put("FDETAILID__FFLEX4", _FDETAILID__FFLEX4_2);
     *             JSONObject _FDETAILID__FFLEX5_2 = new JSONObject();
     *             _FDETAILID__FFLEX5_2.put("FNumber", "03.02.0003");
     *             _FDetailID2.put("FDETAILID__FFLEX5", _FDETAILID__FFLEX5_2);
     *             sub2.put("FDetailID", _FDetailID2);
     *
     *                 _FEntity.add(sub1);
     *                 _FEntity.add(sub2);
     *                 model.put("FEntity", _FEntity);
     *                 data.put("Model", model);
     *                 System.out.println("data:" + JSON.toJSONString(data, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
     *                 this.Save(getFormId(), JSON.toJSONString(data));
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse<VoucherInfo> save(VoucherParams voucherParams) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                Map<String, Object> map = voucherParams.getFinanceVoucher();
                Object model = map.get("Model");
                RepoResult repoResult = null;
                if (model instanceof List) {
                    repoResult = this.batchSave(FormIdConsts.GL_VOUCHER, DataConvertUtil.objToString(map));
                } else {
                    repoResult = this.save(FormIdConsts.GL_VOUCHER, DataConvertUtil.objToString(map));
                }
                if (repoResult.isSuccess()) {
                    List<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                    List<VoucherSimpleVO> voucherSimpleVOS = new LinkedList<>();
                    for (SuccessEntity successEntity : successEntitys) {
                        VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                        voucherSimpleVO.setFinanceVoucherId(successEntity.getId());
                        voucherSimpleVO.setFinanceVoucherCode(successEntity.getNumber());
                        voucherSimpleVOS.add(voucherSimpleVO);
                    }
                    return CommonResponse.success(VoucherInfo.getVoucherInfo(voucherSimpleVOS));
                } else {
                    resp = repoResult.toCommonResponse();
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 批量保存财务凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                Map<String, Object> map = voucherParams.getFinanceVoucher();
                RepoResult repoResult = this.batchSave(FormIdConsts.GL_VOUCHER, DataConvertUtil.objToString(map));
                if (repoResult.isSuccess()) {
                    List<SuccessEntity> successEntitys = repoResult.getResponseStatus().getSuccessEntitys();
                    List<VoucherSimpleVO> voucherSimpleVOS = new LinkedList<>();
                    for (SuccessEntity successEntity : successEntitys) {
                        VoucherSimpleVO voucherSimpleVO = new VoucherSimpleVO();
                        voucherSimpleVO.setFinanceVoucherId(successEntity.getId());
                        voucherSimpleVO.setFinanceVoucherCode(successEntity.getNumber());
                        voucherSimpleVOS.add(voucherSimpleVO);
                    }
                    return CommonResponse.success(VoucherInfo.getVoucherInfo(voucherSimpleVOS));
                } else {
                    resp = repoResult.toCommonResponse();
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }

    /**
     * @description: 查询财务凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherInfo
     */
    @Override
    public CommonResponse<List<OriginVoucherVO>> get(VoucherInfo voucherInfo) {
        String financeSystemCode = voucherInfo.getFinanceSystemCode();
        List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
        if (CollectionUtils.isEmpty(vouchers)) {
            throw new BusinessException("vouchers不能为空");
        }
        CommonResponse<List<OriginVoucherVO>> resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                if (vouchers.size() == 1) {
                    VoucherSimpleVO voucherSimpleVO = vouchers.get(0);
                    VoucherApiQueryVO voucherApiQueryVO = new VoucherApiQueryVO();
                    voucherApiQueryVO.setFinanceVoucherId(voucherSimpleVO.getFinanceVoucherId());
                    CommonResponse<OriginVoucherVO> one = this.getOne(voucherApiQueryVO);
                    OriginVoucherVO data = one.getData();
                    data.setFinanceSystemCode(financeSystemCode);
                    resp = CommonResponse.success(Arrays.asList(data));
                } else {
                    KingDeeVoucherListApiQueryVO kingDeeVoucherListApiQueryVO = new KingDeeVoucherListApiQueryVO();
                    List<String> ids = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.toList());
                    kingDeeVoucherListApiQueryVO.setFilterStringForEqIds(ids);
                    List<Map<String, Object>> list = this.executeBillQuery(DataConvertUtil.objToString(kingDeeVoucherListApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
                    ArrayList<OriginVoucherVO> originVoucherVOS = new ArrayList<>();
                    for (int i = 0; i < list.size(); i++) {
                        Map<String, Object> voucherMap = list.get(i);
                        OriginVoucherVO originVoucherVO = new OriginVoucherVO();
                        // 默认放入个id，避免前端因为id都为空只渲染出一条
                        originVoucherVO.setId(Long.valueOf(i));
                        //FVOUCHERID,FAccountBookID,FDate,FAMOUNTFOR,FYEAR,FPERIOD,FDEBIT,FCREDIT
                        originVoucherVO.setVoucherCode(String.valueOf(voucherMap.get("FVOUCHERID")));
                        originVoucherVO.setVoucherDate(DataConvertUtil.getDate(voucherMap.get("FDate")));

                        originVoucherVO.setFinanceVoucherId(String.valueOf(voucherMap.get("FVOUCHERID")));
                        originVoucherVO.setFinanceVoucherCode(String.valueOf(voucherMap.get("FVOUCHERID")));
                        originVoucherVO.setFinanceVoucherPeriod(String.valueOf(voucherMap.get("FPERIOD")));
                        originVoucherVO.setFinanceSystemCode(financeSystemCode);
                        originVoucherVOS.add(originVoucherVO);
                    }
                    resp = CommonResponse.success(originVoucherVOS);
                }
            }
        } else {
            // 云接入模式

        }
        return resp;
    }


    /**
     * @description: 查询单个凭证
     * @author songlx
     * @date: 2023/11/29
     * @param voucherApiQueryVO
     */
    @Override
    public CommonResponse<OriginVoucherVO> getOne(VoucherApiQueryVO voucherApiQueryVO) {
        String financeSystemCode = voucherApiQueryVO.getFinanceSystemCode();
        String financeVoucherId = voucherApiQueryVO.getFinanceVoucherId();
        Assert.notNull(financeVoucherId, "财务凭证ID【financeVoucherId】不能为空！");
        JSONObject paramObj = new JSONObject();
        paramObj.put("Id", financeVoucherId);
        RepoResult repoResult = this.view(FormIdConsts.GL_VOUCHER, paramObj.toJSONString());
        if (!repoResult.isSuccess()) {
            throw new BusinessException(DataConvertUtil.objToString(repoResult));
        }
        OriginVoucherVO originVoucherVO = new OriginVoucherVO();
        JSONObject result = (JSONObject) repoResult.getResult();
        originVoucherVO.setFinanceVoucherId(financeVoucherId);
        originVoucherVO.setFinanceVoucherCode(financeSystemCode);
        // 账簿
        JSONObject accountbookid = result.getJSONObject("AccountBookID");
        JSONArray accountbookid_name = accountbookid.getJSONArray("Name");
        JSONObject accountbookid_name_0 = accountbookid_name.getJSONObject(0);
        originVoucherVO.setAccbookCode(accountbookid.getString("Number"));
        originVoucherVO.setAccbookName(accountbookid_name_0.getString("Value"));
        // 凭证字
        JSONObject vouchergroupid = result.getJSONObject("VOUCHERGROUPID");
        JSONArray vouchergroupid_name = vouchergroupid.getJSONArray("Name");
        JSONObject vouchergroupid_name_0 = vouchergroupid_name.getJSONObject(0);
        originVoucherVO.setVoucherTypeCode(vouchergroupid.getString("Number"));
        originVoucherVO.setVoucherTypeName(vouchergroupid_name_0.getString("Value"));
        // 凭证号
        String vouchergroupno = result.getString("VOUCHERGROUPNO");
        originVoucherVO.setVoucherCode(vouchergroupno);
        originVoucherVO.setFinanceVoucherCode(vouchergroupno);
        // 期间
        String period = result.getString("PERIOD");
        originVoucherVO.setFinanceVoucherPeriod(period);

        // 凭证日期
        String date = result.getString("Date");
        originVoucherVO.setVoucherDate(DataConvertUtil.getDate(date));
        // 制单人
        JSONObject fcreatorid = result.getJSONObject("FCreatorId");
        String fcreatorid_name = fcreatorid.getString("Name");
        originVoucherVO.setMarkerName(fcreatorid_name);
        // 凭证状态
        String documentstatus = result.getString("DocumentStatus");
        if ("DA".contains(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("保存");
        } else if ("B".equals(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("提交");
        } else if ("C".equals(documentstatus)) {
            originVoucherVO.setFinanceVoucherState("审核");
        } else {
            originVoucherVO.setFinanceVoucherState("未知[" + documentstatus + "]");
        }

        // 分录
        JSONArray gl_voucherentry = result.getJSONArray("GL_VOUCHERENTRY");
        ArrayList<OriginVoucherEntryVO> entryVOList = new ArrayList<>();
        for (int i = 0; i < gl_voucherentry.size(); i++) {
            JSONObject voucherentry = gl_voucherentry.getJSONObject(i);
            String id = voucherentry.getString("Id");
            if ("0".equals(id)) break;
            OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
            // 默认放入个id，避免前端因为id都为空只渲染出一条
            originVoucherEntryVO.setId(Long.valueOf(i));
            // 摘要
            String fexplanation = voucherentry.getString("FEXPLANATION");
            originVoucherEntryVO.setEntryDescription(fexplanation);
            // 科目
            JSONObject faccountid = voucherentry.getJSONObject("FACCOUNTID");
            JSONObject faccountid_fullname_0 = faccountid.getJSONArray("FullName").getJSONObject(0);
            originVoucherEntryVO.setSubjectName(faccountid_fullname_0.getString("Value"));

            // 币种
            JSONObject fcurrencyid = voucherentry.getJSONObject("FCURRENCYID");
            JSONObject fcurrencyid_name_0 = fcurrencyid.getJSONArray("Name").getJSONObject(0);
            originVoucherEntryVO.setCurrencyName(fcurrencyid_name_0.getString("Value"));

            // 方向
            String dc = voucherentry.getString("DC");
            if ("1".equals(dc)) {
                Object debit = voucherentry.get("DEBIT");
                originVoucherEntryVO.setDebitOriginalMny(ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(debit)));
                originVoucherEntryVO.setDirectionFlag(AccplatConsts.DirectionFlag.DEBIT);
            } else {
                Object fcredit = voucherentry.get("FCREDIT");
                originVoucherEntryVO.setCreditOriginalMny(ComputeUtil.scaleTwo(ComputeUtil.toBigDecimal(fcredit)));
                originVoucherEntryVO.setDirectionFlag(AccplatConsts.DirectionFlag.CREDIT);
            }

            // 核算维度
            JSONObject detailid = voucherentry.getJSONObject("DetailID");
            List<String> aulist = new ArrayList<>();
            for (String key : detailid.keySet()) {
                Object value = detailid.get(key);
                if (key.startsWith("F") && value instanceof JSONObject) {
                    JSONObject valObj = (JSONObject) value;
                    JSONObject nameObj = null;
                    // 预置的核算项名称在Name、自定义的在FDataValue，奇葩啊。。。。
                    if (valObj.containsKey("Name")) {
                        nameObj = (JSONObject) valObj.getJSONArray("Name").get(0);
                    } else if (valObj.containsKey("FDataValue")) {
                        nameObj = (JSONObject) valObj.getJSONArray("FDataValue").get(0);
                    }
                    String fnumber = Optional.ofNullable(valObj.getString("Number")).orElse(valObj.getString("FNumber"));
                    String name = nameObj.getString("Value");
                    aulist.add(fnumber + "/" + name);
                }
            }
            if (CollectionUtils.isNotEmpty(aulist)) {
                originVoucherEntryVO.setAuxiliaryInfo(String.join(";", aulist));
            }
            entryVOList.add(originVoucherEntryVO);

        }
        Collections.sort(entryVOList, Comparator.comparing(OriginVoucherEntryVO::getDirectionFlag).reversed());
        originVoucherVO.setOriginVoucherEntryList(entryVOList);
        return CommonResponse.success(originVoucherVO);
    }

    /**
     * @description: 查询财务凭证List
     * @author songlx
     * @date: 2023/11/29
     */
    public CommonResponse getList(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                KingDeeVoucherListApiQueryVO kingDeeVoucherListApiQueryVO = new KingDeeVoucherListApiQueryVO();
                List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
                List<String> ids = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.toList());
                kingDeeVoucherListApiQueryVO.setFilterStringForEqIds(ids);
                List<Map<String, Object>> maps = this.executeBillQuery(DataConvertUtil.objToString(kingDeeVoucherListApiQueryVO), KingDeeQueryConsts.FIELDKEYS);
                resp = CommonResponse.success(maps);
            }
        } else {
            // 云接入模式

        }
        return this.get(voucherInfo);
    }

    /**
     * @description: 删除财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public CommonResponse del(VoucherInfo voucherInfo) {
        CommonResponse resp = null;
        // 私有化模式
        if (!accessType) {
            if (this.Login()) {
                List<VoucherSimpleVO> vouchers = voucherInfo.getVouchers();
                if (CollectionUtils.isEmpty(vouchers)) {
                    return CommonResponse.success("voucherInfo中没有财务凭证信息，无需删除！");
                }
                String voucherIds = vouchers.stream().map(VoucherSimpleVO::getFinanceVoucherId).collect(Collectors.joining(","));
                JSONObject paramObj = new JSONObject();
                paramObj.put("Ids", voucherIds);
                RepoResult repoResult = this.delete(FormIdConsts.GL_VOUCHER, paramObj.toJSONString());
                String result = String.valueOf(repoResult.getResult());
                if (repoResult.isSuccess()) {
                    return CommonResponse.success(JSON.parseObject(result));
                } else {
                    boolean b = result.contains("资料不存在");
                    resp = repoResult.toCommonResponse();
                    // 如果财务凭证已被手动删除，则认为删除成功
                    if (b) {
                        resp.setCode(CommonResponse.SUCCESS);
                    }
                }
            }
        } else {
            // 云接入模式

        }
        resp.setData(voucherInfo);
        return resp;
    }

    /**
     * @description: 依据原始凭证转化财务凭证参数
     * @author songlx
     * @date: 2023/11/29
     */
    @Override
    public Map<String, Object> convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        List<OriginVoucherVO> originVoucherVOs = voucherParams.getOriginVoucherVOList();
        KingDeeVoucherApiSaveVO kingDeeVoucherApiSaveVO = null;
        if (originVoucherVOs.size() == 1) {
            kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<Model>();
        } else {
            kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO<List<Model>>();
        }
        List<Model> models = new LinkedList<>();
        for (OriginVoucherVO originVoucherVO : originVoucherVOs) {
            Model model = new Model();
            // 1、设置账簿
            FAccountBookID fAccountBookID = new FAccountBookID();
            fAccountBookID.setFNumber(originVoucherVO.getAccbookCode());
            model.setFAccountBookID(fAccountBookID);
            // 日期
            Date businessDate = originVoucherVO.getBusinessDate();
            model.setFDate(DataConvertUtil.formatDate(businessDate));

            // 凭证字 这个不传也可以啊
      /*  FVOUCHERGROUPID fvouchergroupid = new FVOUCHERGROUPID();
        fvouchergroupid.setFNumber(originVoucherVO.getVoucherTypeCode());
        model.setFVOUCHERGROUPID(fvouchergroupid);*/

            List<OriginVoucherEntryVO> originVoucherEntryList = originVoucherVO.getOriginVoucherEntryList();
            List<FEntity> fEntityList = new ArrayList<>();
            for (OriginVoucherEntryVO entryVO : originVoucherEntryList) {
                FEntity fEntity1 = new FEntity();
                // 摘要
                fEntity1.setFEXPLANATION(entryVO.getEntryDescription());
                // FACCOUNTID 科目编码
                FACCOUNTID faccountid = new FACCOUNTID();
                faccountid.setFNumber(entryVO.getSubjectCode());
                fEntity1.setFACCOUNTID(faccountid);
                if (AccplatConsts.DirectionFlag.DEBIT.equals(entryVO.getDirectionFlag())) {
                    // FAMOUNTFOR 原币金额
                    fEntity1.setFAMOUNTFOR(entryVO.getDebitOriginalMny());
                    // FDEBIT 借方金额
                    fEntity1.setFDEBIT(entryVO.getDebitOriginalMny());
                } else {
                    // FAMOUNTFOR 原币金额
                    fEntity1.setFAMOUNTFOR(entryVO.getCreditOriginalMny());
                    // FDEBIT 借方金额
                    fEntity1.setFCREDIT(entryVO.getCreditOriginalMny());
                }

                // FCURRENCYID 币别
                FCURRENCYID fcurrencyid = new FCURRENCYID();
                fcurrencyid.setFNumber(entryVO.getCurrencyCode());
                fEntity1.setFCURRENCYID(fcurrencyid);

                // FEXCHANGERATETYPE 汇率类型
                FEXCHANGERATETYPE fexchangeratetype = new FEXCHANGERATETYPE();
                fexchangeratetype.setFNumber(entryVO.getRateType());
                fEntity1.setFEXCHANGERATETYPE(fexchangeratetype);

                // 辅助核算项
                List<OriginVoucherAuxiliaryVO> clientAuxiliaryList = entryVO.getOriginVoucherAuxiliaryVOList();
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(clientAuxiliaryList)) {
                    Map<String, FDetailID> fDetailID = new HashMap<>();
                    for (OriginVoucherAuxiliaryVO originVoucherAuxiliaryVO : clientAuxiliaryList) {
                        FDetailID fflex = new FDetailID();
                        fflex.setFNumber(originVoucherAuxiliaryVO.getAuxiliaryFsValue());
                        try {
                            BeanUtils.setProperty(fDetailID, originVoucherAuxiliaryVO.getAuxiliaryFsCode(), fflex);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    fEntity1.setFDetailID(fDetailID);
                }
                fEntityList.add(fEntity1);
            }
            model.setFEntity(fEntityList);
            models.add(model);
        }
        if (models.size() == 1) {
            kingDeeVoucherApiSaveVO.setModel(models.get(0));
        } else {
            kingDeeVoucherApiSaveVO.setModel(models);
        }
        return DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO);
    }


    public static void main(String[] args) {
        Map map = new HashMap<>();
        map.put("Name", "tom");
        map.put("Age", 20);

        String s = new Gson().toJson(map);
        System.out.println(s);

        KingDeeVoucherApiSaveVO kingDeeVoucherApiSaveVO = new KingDeeVoucherApiSaveVO();
        Model model = new Model();
        FEntity fEntity = new FEntity();
        fEntity.setFAMOUNTFOR(ComputeUtil.toBigDecimal(11));
        model.setFEntity(Arrays.asList(fEntity));
        kingDeeVoucherApiSaveVO.setModel(model);
        //Map map = BeanMapper.map(kingDeeVoucherApiSaveVO, Map.class);
        //JSONObject jsonObject = new JSONObject(map);
        String s1 = new Gson().toJson(kingDeeVoucherApiSaveVO);
        System.out.println(s1);


        Map<String, Object> map1 = JSON.parseObject(new Gson().toJson(kingDeeVoucherApiSaveVO), Map.class);
        System.out.println(map1);


        System.out.println(JSONObject.toJSONString(kingDeeVoucherApiSaveVO));

    }
}
