package com.ejianc.business.voucher.transfer;

import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.originvoucher.service.IVoucherTemplateService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.BaseVoucherBusinessService;
import com.ejianc.business.voucher.vo.VoucherParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @description: 公共凭证转化服务
 *
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Service("commonVoucherTransferService")
public class CommonVoucherTransferService extends BaseVoucherBusinessService implements IVoucherTransferService {


    @Autowired
    private IVoucherTemplateService voucherTemplateService;


    /**
     * @description: 将单据参数转化成原始凭证/财务凭证参数
     * @return
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public void transfer(VoucherParams voucherParams) {
        List<BillAccbookSetVO> billAccbookSetVOList = voucherParams.getBillAccbookSetVOList();
        List<OriginVoucherVO> originVoucherVOList = voucherParams.getOriginVoucherVOList();
        for (BillAccbookSetVO billAccbookSetVO : billAccbookSetVOList) {
            VoucherTemplateVO voucherTemplateVO = voucherTemplateService.getVoucherTemplate(billAccbookSetVO.getAccbookId(), voucherParams.getBillTypeCode(), voucherParams.getBusinessType());
            OriginVoucherVO originVoucherVO = transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
            originVoucherVOList.add(originVoucherVO);
        }
        Map<String, Object> financeVoucher = transferFinanceVoucherByOriginVoucher(voucherParams);
        voucherParams.setFinanceVoucher(financeVoucher);
    }


}
