/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.voucher.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.AuxiliaryEntity;
import com.ejianc.business.accplat.config.bean.BillAccbookSetEntity;
import com.ejianc.business.accplat.config.bean.BillAuxiliarySetEntity;
import com.ejianc.business.accplat.config.bean.BillInfluenceSetEntity;
import com.ejianc.business.accplat.config.bean.SubjectEntity;
import com.ejianc.business.accplat.config.service.IAccbookService;
import com.ejianc.business.accplat.config.service.IAuxiliaryService;
import com.ejianc.business.accplat.config.service.IBillAccbookSetService;
import com.ejianc.business.accplat.config.service.IBillAuxiliarySetService;
import com.ejianc.business.accplat.config.service.IBillInfluenceSetService;
import com.ejianc.business.accplat.config.service.ISubjectContrastService;
import com.ejianc.business.accplat.config.service.ISubjectService;
import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.config.vo.BillAuxiliarySetVO;
import com.ejianc.business.accplat.config.vo.BillInfluenceSetVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastDetailInfluenceVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastDetailVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.business.voucher.transfer.VoucherTransferFactory;
import com.ejianc.business.voucher.utils.AviatorUtil;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.dataCompare.api.IDataCompareApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.lexer.token.OperatorType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseVoucherBusinessService {
    private static final Logger log = LoggerFactory.getLogger(BaseVoucherBusinessService.class);
    @Autowired
    private VoucherTransferFactory voucherTransferFactory;
    @Autowired
    private IBillAccbookSetService billAccbookSetService;
    @Autowired
    private IBillInfluenceSetService billInfluenceSetService;
    @Autowired
    private IBillAuxiliarySetService billAuxiliarySetService;
    @Autowired
    private IAuxiliaryService auxiliaryService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAccbookService accbookService;
    @Autowired
    private ISubjectContrastService subjectContrastService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IDataCompareApi dataCompareApi;

    public <T> T executeOneExpression(String express, Map<String, Object> billData, String billTypeCode, String logic) {
        String subTableKey = this.getSubTableKey(billTypeCode, billData, express);
        if (subTableKey != null) {
            String _subTableKey = "subData-" + subTableKey;
            JSONArray subDatas = new JSONArray();
            if (billData.containsKey(_subTableKey)) {
                subDatas = (JSONArray)billData.get(_subTableKey);
            } else {
                Object sub = billData.get(subTableKey);
                if (sub != null) {
                    subDatas = (JSONArray)sub;
                    billData.put(_subTableKey, subDatas);
                }
            }
            int a = 1;
            StringBuilder subExpress = new StringBuilder();
            HashMap<String, Object> subExecResMap = new HashMap<String, Object>();
            for (Object subData : subDatas) {
                billData.remove(subTableKey);
                billData.put(subTableKey, subData);
                Object oneSubExecObj = AviatorUtil.exec((String)express, billData);
                String key = "oneSubRes" + a;
                subExecResMap.put(key, oneSubExecObj);
                subExpress.append(key);
                if (a != subDatas.size()) {
                    subExpress.append(" " + logic + " ");
                }
                ++a;
            }
            express = subExpress.toString();
            Object execSub = AviatorUtil.exec((String)express, subExecResMap);
            log.info("executeOneExpression(B)\u8868\u8fbe\u5f0f\u6267\u884c\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)express, execSub);
            return (T)execSub;
        }
        Object exec = AviatorUtil.exec((String)express, billData);
        log.info("executeOneExpression(H)\u8868\u8fbe\u5f0f\u6267\u884c\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)express, exec);
        return (T)exec;
    }

    private void setRelationEntityValue(String columnExpression, Map<String, Object> billData, String billTypeCode, Map<String, MdAttributeVO> mdAttributeVOMap) {
        String _headCol = columnExpression.substring(0, columnExpression.indexOf("."));
        String headCol = columnExpression.substring(1, columnExpression.indexOf("."));
        if (!billData.containsKey(_headCol)) {
            MdAttributeVO sourceAttributeVO = mdAttributeVOMap.get(headCol);
            Object execVal = AviatorUtil.exec((String)headCol, billData);
            CommonResponse mapCommonResponse = this.mdAttributeApi.queryRelationEntityValue(billTypeCode, sourceAttributeVO.getEntityId(), sourceAttributeVO.getId(), String.valueOf(execVal), null);
            billData.put(_headCol, mapCommonResponse.getData());
        }
    }

    public OriginVoucherVO transferOriginVoucherByVoucherTemplate(VoucherParams voucherParams, VoucherTemplateVO voucherTemplateVO) {
        String voucherType;
        String billTypeCode = voucherParams.getBillTypeCode();
        Map billData = voucherParams.getBillData();
        Long billId = Long.valueOf(String.valueOf(billData.get("id")));
        voucherParams.setBillId(billId);
        Long orgId = voucherParams.getOrgId();
        Date businessDate = DataConvertUtil.getDate(billData.get(voucherTemplateVO.getBusinessDateColumn()));
        OriginVoucherVO originVoucherVO = new OriginVoucherVO();
        BillTypeVO billTypeVO = voucherParams.getBillTypeVO();
        originVoucherVO.setSrcBillTypeId(billTypeVO.getId());
        originVoucherVO.setSrcBillTypeCode(billTypeVO.getBillCode());
        originVoucherVO.setSrcBillTypeName(billTypeVO.getBillName());
        originVoucherVO.setSrcSystemCode(voucherParams.getSrcSystemCode());
        originVoucherVO.setSrcSystemName(voucherParams.getSrcSystemName());
        originVoucherVO.setSrcBillId(billId);
        String billCode = voucherParams.getBillCode();
        String billCodeColumn = voucherTemplateVO.getBillCodeColumn();
        if (StringUtils.isEmpty((CharSequence)billCode) && StringUtils.isNotEmpty((CharSequence)billCodeColumn)) {
            billCode = String.valueOf(billData.get(billCodeColumn));
        }
        originVoucherVO.setSrcBillCode(billCode);
        originVoucherVO.setSrcBillPcUrl(voucherTemplateVO.getSrcBillPcUrl());
        JSONObject orgObj = this.getReferCodeValue(String.valueOf(orgId), "idm-org");
        originVoucherVO.setSrcBillOrgId(orgId);
        if (orgObj != null) {
            originVoucherVO.setSrcBillOrgCode(orgObj.getString("code"));
            originVoucherVO.setSrcBillOrgName(orgObj.getString("name"));
        }
        originVoucherVO.setVoucherCreateTime(new Date());
        originVoucherVO.setVoucherDate(new Date());
        originVoucherVO.setBusinessDate(businessDate);
        String markerColumn = voucherTemplateVO.getMarkerColumn();
        if (StringUtils.isNotEmpty((CharSequence)markerColumn)) {
            String markerId = String.valueOf(billData.get(markerColumn));
            JSONObject markerObj = this.getReferCodeValue(markerId, "idm-employee");
            originVoucherVO.setMarkerId(Long.valueOf(markerId));
            originVoucherVO.setMarkerCode(markerObj.getString("code"));
            originVoucherVO.setMarkerName(markerObj.getString("name"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(voucherType = voucherTemplateVO.getVoucherType()))) {
            String[] voucherTypeArr = voucherType.split(":|\uff1a");
            originVoucherVO.setVoucherTypeCode(voucherTypeArr[0]);
            originVoucherVO.setVoucherTypeName(voucherTypeArr[1]);
        }
        originVoucherVO.setAccbookId(voucherTemplateVO.getAccbookId());
        originVoucherVO.setAccbookCode(voucherTemplateVO.getAccbookCode());
        originVoucherVO.setAccbookName(voucherTemplateVO.getAccbookName());
        originVoucherVO.setFinanceSystemCode(voucherParams.getFinanceSystemCode());
        originVoucherVO.setVoucherTemplateId(voucherTemplateVO.getId());
        HashMap<Long, BillAuxiliarySetVO> auxiliarySetMap = new HashMap();
        List<BillAuxiliarySetVO> billAuxiliarySet = this.getBillAuxiliarySet(billTypeCode);
        if (CollectionUtils.isNotEmpty(billAuxiliarySet)) {
            auxiliarySetMap = billAuxiliarySet.stream().collect(Collectors.toMap(BillAuxiliarySetVO::getAuxiliaryId, dto2 -> dto2));
        }
        ArrayList<OriginVoucherEntryVO> entryList = new ArrayList<OriginVoucherEntryVO>();
        List voucherTemplateDetailList = voucherTemplateVO.getVoucherTemplateDetailList();
        for (VoucherTemplateDetailVO voucherTemplateDetailVO : voucherTemplateDetailList) {
            String subjectRuleFlag = voucherTemplateDetailVO.getSubjectRuleFlag();
            List<OriginVoucherEntryVO> list = null;
            list = "subjectContrast".equals(subjectRuleFlag) ? this.analysisEntryBySubjectContrast(billTypeCode, billData, voucherTemplateDetailVO, voucherTemplateVO, auxiliarySetMap) : this.analysisEntryBySubject(billTypeCode, billData, voucherTemplateDetailVO, voucherTemplateVO, auxiliarySetMap);
            entryList.addAll(list);
        }
        List<OriginVoucherEntryVO> mergeEntryList = this.mergeEntry(voucherTemplateVO, originVoucherVO, entryList);
        originVoucherVO.setOriginVoucherEntryList(mergeEntryList);
        return originVoucherVO;
    }

    private List<OriginVoucherEntryVO> mergeEntry(VoucherTemplateVO voucherTemplateVO, OriginVoucherVO originVoucherVO, List<OriginVoucherEntryVO> entryList) {
        String entryMergeRule = voucherTemplateVO.getEntryMergeRule();
        Boolean mnyNullFilterFlag = voucherTemplateVO.getMnyNullFilterFlag();
        BigDecimal debitTotal = null;
        BigDecimal creditTotal = null;
        ArrayList<OriginVoucherAuxiliaryVO> auxiliaryList = new ArrayList<OriginVoucherAuxiliaryVO>();
        HashMap<String, OriginVoucherEntryVO> map = new HashMap<String, OriginVoucherEntryVO>();
        for (int i = 0; i < entryList.size(); ++i) {
            OriginVoucherEntryVO _originVoucherEntryVO;
            OriginVoucherEntryVO originVoucherEntryVO = entryList.get(i);
            List auxiliaryVOList = originVoucherEntryVO.getOriginVoucherAuxiliaryVOList();
            if (CollectionUtils.isNotEmpty((Collection)auxiliaryVOList)) {
                auxiliaryList.addAll(auxiliaryVOList);
            }
            BigDecimal debitOriginalMny = originVoucherEntryVO.getDebitOriginalMny();
            BigDecimal creditOriginalMny = originVoucherEntryVO.getCreditOriginalMny();
            if (mnyNullFilterFlag.booleanValue() && ComputeUtil.isEmpty((BigDecimal)debitOriginalMny).booleanValue() && ComputeUtil.isEmpty((BigDecimal)creditOriginalMny).booleanValue()) continue;
            debitTotal = ComputeUtil.safeAdd(debitTotal, (BigDecimal)debitOriginalMny);
            creditTotal = ComputeUtil.safeAdd(creditTotal, (BigDecimal)creditOriginalMny);
            Long subjectId = originVoucherEntryVO.getSubjectId();
            String entryDescription = originVoucherEntryVO.getEntryDescription();
            String auxiliaryIds = originVoucherEntryVO.getAuxiliaryIds();
            String directionFlag = originVoucherEntryVO.getDirectionFlag();
            String key = String.valueOf(i);
            if ("subjectDescriptionAuxiliaryDirection".equals(entryMergeRule)) {
                key = subjectId + entryDescription + auxiliaryIds + directionFlag;
            }
            if ((_originVoucherEntryVO = (OriginVoucherEntryVO)map.get(key)) != null) {
                BigDecimal debitMny = ComputeUtil.safeAdd((BigDecimal)_originVoucherEntryVO.getDebitOriginalMny(), (BigDecimal)debitOriginalMny);
                _originVoucherEntryVO.setDebitOriginalMny(debitMny);
                BigDecimal creditMny = ComputeUtil.safeAdd((BigDecimal)_originVoucherEntryVO.getCreditOriginalMny(), (BigDecimal)creditOriginalMny);
                _originVoucherEntryVO.setCreditOriginalMny(creditMny);
                continue;
            }
            map.put(key, originVoucherEntryVO);
        }
        originVoucherVO.setDebitTotalMny(debitTotal);
        originVoucherVO.setCreditTotalMny(creditTotal);
        List<OriginVoucherEntryVO> entryVOList = map.values().stream().collect(Collectors.toList());
        this.getDataCompareMap(entryVOList, auxiliaryList);
        return entryVOList;
    }

    private void getDataCompareMap(List<OriginVoucherEntryVO> entryVOList, List<OriginVoucherAuxiliaryVO> auxiliaryList) {
        if (CollectionUtils.isNotEmpty(auxiliaryList)) {
            Map dataCompareMap = new HashMap();
            Map auxiliaryCodeMap = auxiliaryList.stream().filter(t -> t.getCompareAppId() != null).collect(Collectors.groupingBy(OriginVoucherAuxiliaryVO::getCompareAppId, Collectors.mapping(OriginVoucherAuxiliaryVO::getAuxiliaryCode, Collectors.toList())));
            if (MapUtils.isNotEmpty(auxiliaryCodeMap)) {
                CommonResponse appDataMapRes = this.dataCompareApi.getAppDataMap(auxiliaryCodeMap);
                if (appDataMapRes.isSuccess()) {
                    dataCompareMap = (Map)appDataMapRes.getData();
                }
                for (OriginVoucherEntryVO originVoucherEntryVO : entryVOList) {
                    List originVoucherAuxiliaryVOList = originVoucherEntryVO.getOriginVoucherAuxiliaryVOList();
                    for (OriginVoucherAuxiliaryVO auxiliaryVO : originVoucherAuxiliaryVOList) {
                        Long compareAppId = auxiliaryVO.getCompareAppId();
                        if (compareAppId == null) continue;
                        String auxiliaryCode = auxiliaryVO.getAuxiliaryCode();
                        String fsCodeVal = (String)dataCompareMap.get(compareAppId + auxiliaryCode);
                        auxiliaryVO.setAuxiliaryFsValue(StringUtils.isNotBlank((CharSequence)fsCodeVal) ? fsCodeVal : auxiliaryCode);
                    }
                }
            }
        }
    }

    public String getSubTableKey(String billTypeCode, Map<String, Object> billData, String mnyExpression) {
        List columnNameList = DataConvertUtil.getRelaionOrSubColumnList((String)mnyExpression);
        ArrayList<String> subTableKeyList = new ArrayList<String>();
        Map mdAttributeVOMap = null;
        String cacheKey = "mdattr" + billTypeCode;
        if (this.cacheManager.exists(cacheKey).booleanValue()) {
            mdAttributeVOMap = (Map)((Object)this.cacheManager.get(cacheKey));
        } else {
            CommonResponse attrMapRes = this.mdAttributeApi.getAttrMap(billTypeCode);
            mdAttributeVOMap = (Map)attrMapRes.getData();
        }
        for (String column : columnNameList) {
            MdAttributeVO mdAttributeVO = (MdAttributeVO)mdAttributeVOMap.get(column);
            if (mdAttributeVO == null) continue;
            String columnPos = mdAttributeVO.getColumnPos();
            if ("HR".equals(columnPos)) {
                this.setRelationEntityValue(column, billData, billTypeCode, mdAttributeVOMap);
                continue;
            }
            if (!"B".equals(columnPos)) continue;
            String[] subKeys = column.split("\\.");
            subTableKeyList.add(subKeys[0]);
        }
        if (subTableKeyList.size() > 1) {
            throw new BusinessException("\u5355\u636e\u7c7b\u578b\u7f16\u7801\u3010" + billTypeCode + "\u3011\u7684\u8868\u8fbe\u5f0f\u3010" + mnyExpression + "\u3011\u4e2d\u542b\u6709\u81f3\u5c11\u4e24\u4e2a\u5b50\u8868\u952e\u503c\uff0c\u4e0d\u80fd\u6b63\u5e38\u89e3\u6790\u6570\u636e\uff01");
        }
        return CollectionUtils.isNotEmpty(subTableKeyList) ? (String)subTableKeyList.get(0) : null;
    }

    public List<OriginVoucherEntryVO> analysisEntryBySubject(String billTypeCode, Map<String, Object> billData, VoucherTemplateDetailVO voucherTemplateDetailVO, VoucherTemplateVO voucherTemplateVO, Map<Long, BillAuxiliarySetVO> auxiliarySetMap) {
        String subjectCode = voucherTemplateDetailVO.getSubjectRuleCode();
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u56fa\u5b9a\u79d1\u76ee\u7f16\u7801\uff1a" + subjectCode + "\u3011=====start====================================");
        String directionFlag = voucherTemplateDetailVO.getDirectionFlag();
        String mnyExpression = voucherTemplateDetailVO.getMnyExpression();
        String descriptionFlag = voucherTemplateDetailVO.getDescriptionFlag();
        String conditionExpression = voucherTemplateDetailVO.getConditionExpression();
        String descriptionExpression = voucherTemplateDetailVO.getDescriptionExpression();
        LinkedList<OriginVoucherEntryVO> entryVOList = new LinkedList<OriginVoucherEntryVO>();
        String subTableKey = this.getSubTableKey(billTypeCode, billData, mnyExpression);
        if (subTableKey == null) {
            Boolean headbool = Boolean.TRUE;
            if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                headbool = (Boolean)AviatorUtil.exec((String)conditionExpression, billData);
            }
            log.info("==========\u5206\u5f55\u6761\u4ef6(H)\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)conditionExpression, (Object)headbool);
            if (headbool.booleanValue()) {
                OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
                String description = descriptionExpression;
                if (StringUtils.isNotEmpty((CharSequence)descriptionExpression) && "billColumn".equals(descriptionFlag)) {
                    description = (String)AviatorUtil.exec((String)descriptionExpression, billData);
                }
                originVoucherEntryVO.setEntryDescription(description);
                originVoucherEntryVO.setSubjectId(voucherTemplateDetailVO.getSubjectRuleId());
                originVoucherEntryVO.setSubjectCode(voucherTemplateDetailVO.getSubjectRuleCode());
                originVoucherEntryVO.setSubjectName(voucherTemplateDetailVO.getSubjectRuleName());
                originVoucherEntryVO.setDirectionFlag(directionFlag);
                BigDecimal mny = ComputeUtil.toBigDecimal((Object)AviatorUtil.exec((String)mnyExpression, billData));
                if ("debit".equals(directionFlag)) {
                    originVoucherEntryVO.setDebitOriginalMny(mny);
                } else {
                    originVoucherEntryVO.setCreditOriginalMny(mny);
                }
                originVoucherEntryVO.setRateType(voucherTemplateVO.getRateType());
                originVoucherEntryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
                this.analysisAuxiliary(originVoucherEntryVO, auxiliarySetMap, billData);
                entryVOList.add(originVoucherEntryVO);
            }
        } else {
            String _subTableKey = "subData-" + subTableKey;
            JSONArray subDatas = new JSONArray();
            if (billData.containsKey(_subTableKey)) {
                subDatas = (JSONArray)billData.get(_subTableKey);
            } else {
                Object sub = billData.get(subTableKey);
                if (sub != null) {
                    subDatas = (JSONArray)sub;
                    billData.put(_subTableKey, subDatas);
                }
            }
            int a = 1;
            for (Object subData : subDatas) {
                billData.remove(subTableKey);
                billData.put(subTableKey, subData);
                Boolean subbool = Boolean.TRUE;
                if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                    subbool = (Boolean)AviatorUtil.exec((String)conditionExpression, billData);
                }
                log.info("==========\u5206\u5f55\u6761\u4ef6(B{})\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{a, conditionExpression, subbool});
                ++a;
                if (!subbool.booleanValue()) continue;
                OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
                String subDescription = descriptionExpression;
                if (StringUtils.isNotEmpty((CharSequence)descriptionExpression) && "billColumn".equals(descriptionFlag)) {
                    subDescription = (String)AviatorUtil.exec((String)descriptionExpression, billData);
                }
                originVoucherEntryVO.setEntryDescription(subDescription);
                BigDecimal headMny = ComputeUtil.toBigDecimal((Object)AviatorUtil.exec((String)mnyExpression, billData));
                if ("debit".equals(directionFlag)) {
                    originVoucherEntryVO.setDebitOriginalMny(headMny);
                } else {
                    originVoucherEntryVO.setCreditOriginalMny(headMny);
                }
                originVoucherEntryVO.setDirectionFlag(directionFlag);
                originVoucherEntryVO.setRateType(voucherTemplateVO.getRateType());
                originVoucherEntryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
                originVoucherEntryVO.setSubjectId(voucherTemplateDetailVO.getSubjectRuleId());
                originVoucherEntryVO.setSubjectCode(voucherTemplateDetailVO.getSubjectRuleCode());
                originVoucherEntryVO.setSubjectName(voucherTemplateDetailVO.getSubjectRuleName());
                this.analysisAuxiliary(originVoucherEntryVO, auxiliarySetMap, billData);
                entryVOList.add(originVoucherEntryVO);
            }
        }
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u56fa\u5b9a\u79d1\u76ee\u7f16\u7801\uff1a" + subjectCode + "\u3011=====end======================================");
        return entryVOList;
    }

    public List<OriginVoucherEntryVO> analysisEntryBySubjectContrast(String billTypeCode, Map<String, Object> billData, VoucherTemplateDetailVO voucherTemplateDetailVO, VoucherTemplateVO voucherTemplateVO, Map<Long, BillAuxiliarySetVO> auxiliarySetMap) {
        List<Long> influenceIds;
        List<BillInfluenceSetVO> billInfluenceSetList;
        String subjectCategoryCode = voucherTemplateDetailVO.getSubjectRuleCode();
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====start====================================");
        SubjectContrastVO subjectContrast = this.getSubjectContrast(subjectCategoryCode);
        List subjectContrastDetailList = subjectContrast.getSubjectContrastDetailList();
        String influenceIdsStr = subjectContrast.getInfluenceIds();
        if (StringUtils.isBlank((CharSequence)influenceIdsStr)) {
            throw new BusinessException("\u8be5\u79d1\u76ee\u5206\u7c7b\u3010\u7f16\u7801\uff1a" + subjectContrast.getSubjectCategoryCode() + "\u3011\u672a\u5b9a\u4e49\u5f71\u54cd\u56e0\u7d20\uff01");
        }
        String[] influenceIdsArr = influenceIdsStr.split(",");
        if (influenceIdsArr.length != (billInfluenceSetList = this.getBillInfluenceSet(billTypeCode, influenceIds = Arrays.stream(influenceIdsArr).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()))).size()) {
            throw new BusinessException("\u5355\u636e\u3010\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + billTypeCode + "\u3011\u7684\u79d1\u76ee\u5206\u7c7b\u3010\u7f16\u7801\uff1a" + subjectContrast.getSubjectCategoryCode() + "\u3011\u7684\u5f71\u54cd\u56e0\u7d20\uff08" + influenceIdsArr.length + "\u4e2a\uff09\u548c\u5f71\u54cd\u56e0\u7d20\u5b57\u6bb5\u5173\u8054\uff08" + billInfluenceSetList.size() + "\u4e2a\uff09\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Map<Long, BillInfluenceSetVO> billInfluenceSetMap = billInfluenceSetList.stream().collect(Collectors.toMap(BillInfluenceSetVO::getInfluenceId, t -> t));
        String directionFlag = voucherTemplateDetailVO.getDirectionFlag();
        String mnyExpression = voucherTemplateDetailVO.getMnyExpression();
        String descriptionFlag = voucherTemplateDetailVO.getDescriptionFlag();
        String conditionExpression = voucherTemplateDetailVO.getConditionExpression();
        String descriptionExpression = voucherTemplateDetailVO.getDescriptionExpression();
        LinkedList<OriginVoucherEntryVO> entriesList = new LinkedList<OriginVoucherEntryVO>();
        String subTableKey = this.getSubTableKey(billTypeCode, billData, mnyExpression);
        if (subTableKey == null) {
            boolean conditionBool = Boolean.TRUE;
            if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                conditionBool = (Boolean)AviatorUtil.exec((String)conditionExpression, billData);
            }
            log.info("==========\u5206\u5f55\u6761\u4ef6(H)\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)conditionExpression, (Object)conditionBool);
            if (!conditionBool) {
                return entriesList;
            }
            OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
            String headDescription = descriptionExpression;
            if (StringUtils.isNotEmpty((CharSequence)descriptionExpression) && "billColumn".equals(descriptionFlag)) {
                headDescription = (String)AviatorUtil.exec((String)descriptionExpression, billData);
            }
            originVoucherEntryVO.setEntryDescription(headDescription);
            BigDecimal headMny = ComputeUtil.toBigDecimal((Object)AviatorUtil.exec((String)mnyExpression, billData));
            if ("debit".equals(directionFlag)) {
                originVoucherEntryVO.setDebitOriginalMny(headMny);
            } else {
                originVoucherEntryVO.setCreditOriginalMny(headMny);
            }
            originVoucherEntryVO.setDirectionFlag(directionFlag);
            originVoucherEntryVO.setRateType(voucherTemplateVO.getRateType());
            originVoucherEntryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
            originVoucherEntryVO.setSubjectId(subjectContrast.getDefaultSubjectId());
            originVoucherEntryVO.setSubjectCode(subjectContrast.getDefaultSubjectCode());
            originVoucherEntryVO.setSubjectName(subjectContrast.getDefaultSubjectName());
            for (SubjectContrastDetailVO subjectContrastDetailVO : subjectContrastDetailList) {
                List subjectContrastDetailInfluenceList = subjectContrastDetailVO.getSubjectContrastDetailInfluenceList();
                LinkedList<String> contrastExpressionList = new LinkedList<String>();
                for (SubjectContrastDetailInfluenceVO subjectContrastDetailInfluenceVO : subjectContrastDetailInfluenceList) {
                    Long influenceId = subjectContrastDetailInfluenceVO.getInfluenceId();
                    String influenceValue = subjectContrastDetailInfluenceVO.getInfluenceValue();
                    BillInfluenceSetVO billInfluenceSetVO = billInfluenceSetMap.get(influenceId);
                    if (billInfluenceSetVO == null) {
                        throw new BusinessException("\u4f1a\u8ba1\u5e73\u53f0\u914d\u7f6e-\u5f71\u54cd\u56e0\u7d20\u3010ID\uff1a" + subjectContrastDetailInfluenceVO.getInfluenceId() + "\u3011\u672a\u914d\u7f6e\u5173\u8054\u5b57\u6bb5");
                    }
                    String columnExpression = billInfluenceSetVO.getColumnExpression();
                    String contrastExpression = columnExpression + OperatorType.EQ.getToken() + influenceValue;
                    contrastExpressionList.add(contrastExpression);
                }
                String contrastExpression = String.join((CharSequence)OperatorType.AND.getToken(), contrastExpressionList);
                boolean contrastBool = (Boolean)AviatorUtil.exec((String)contrastExpression, billData);
                log.info("==========\u5206\u5f55\u79d1\u76ee\u8f6c\u5316\u6761\u4ef6(H)\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)contrastExpression, (Object)contrastBool);
                if (!contrastBool) continue;
                originVoucherEntryVO.setSubjectId(subjectContrastDetailVO.getAccountSubjectId());
                originVoucherEntryVO.setSubjectCode(subjectContrastDetailVO.getAccountSubjectCode());
                originVoucherEntryVO.setSubjectName(subjectContrastDetailVO.getAccountSubjectName());
                break;
            }
            this.analysisAuxiliary(originVoucherEntryVO, auxiliarySetMap, billData);
            entriesList.add(originVoucherEntryVO);
        } else {
            String _subTableKey = "subData-" + subTableKey;
            JSONArray subDatas = new JSONArray();
            if (billData.containsKey(_subTableKey)) {
                subDatas = (JSONArray)billData.get(_subTableKey);
            } else {
                Object sub = billData.get(subTableKey);
                if (sub != null) {
                    subDatas = (JSONArray)sub;
                    billData.put(_subTableKey, subDatas);
                }
            }
            for (Object subData : subDatas) {
                billData.remove(subTableKey);
                billData.put(subTableKey, subData);
                boolean conditionBool = Boolean.TRUE;
                if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                    conditionBool = (Boolean)AviatorUtil.exec((String)conditionExpression, billData);
                }
                log.info("==========\u5206\u5f55\u6761\u4ef6(B)\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)conditionExpression, (Object)conditionBool);
                if (!conditionBool) continue;
                OriginVoucherEntryVO originVoucherEntryVO = new OriginVoucherEntryVO();
                String oneSubDescription = descriptionExpression;
                if (StringUtils.isNotEmpty((CharSequence)descriptionExpression) && "billColumn".equals(descriptionFlag)) {
                    oneSubDescription = (String)AviatorUtil.exec((String)descriptionExpression, billData);
                }
                originVoucherEntryVO.setEntryDescription(oneSubDescription);
                BigDecimal headMny = ComputeUtil.toBigDecimal((Object)AviatorUtil.exec((String)mnyExpression, billData));
                if ("debit".equals(directionFlag)) {
                    originVoucherEntryVO.setDebitOriginalMny(headMny);
                } else {
                    originVoucherEntryVO.setCreditOriginalMny(headMny);
                }
                originVoucherEntryVO.setDirectionFlag(directionFlag);
                originVoucherEntryVO.setRateType(voucherTemplateVO.getRateType());
                originVoucherEntryVO.setCurrencyCode(voucherTemplateVO.getCurrencyCode());
                originVoucherEntryVO.setSubjectId(subjectContrast.getDefaultSubjectId());
                originVoucherEntryVO.setSubjectCode(subjectContrast.getDefaultSubjectCode());
                originVoucherEntryVO.setSubjectName(subjectContrast.getDefaultSubjectName());
                for (SubjectContrastDetailVO subjectContrastDetailVO : subjectContrastDetailList) {
                    List subjectContrastDetailInfluenceList = subjectContrastDetailVO.getSubjectContrastDetailInfluenceList();
                    LinkedList<String> subContrastExpressionList = new LinkedList<String>();
                    for (SubjectContrastDetailInfluenceVO subjectContrastDetailInfluenceVO : subjectContrastDetailInfluenceList) {
                        Long influenceId = subjectContrastDetailInfluenceVO.getInfluenceId();
                        String influenceValue = subjectContrastDetailInfluenceVO.getInfluenceValue();
                        BillInfluenceSetVO billInfluenceSetVO = billInfluenceSetMap.get(influenceId);
                        if (billInfluenceSetVO == null) {
                            throw new BusinessException("\u4f1a\u8ba1\u5e73\u53f0\u914d\u7f6e-\u5f71\u54cd\u56e0\u7d20\u3010ID\uff1a" + subjectContrastDetailInfluenceVO.getInfluenceId() + "\u3011\u672a\u914d\u7f6e\u5173\u8054\u5b57\u6bb5");
                        }
                        String columnExpression = billInfluenceSetVO.getColumnExpression();
                        String eqStringExpression = columnExpression + OperatorType.EQ.getToken() + influenceValue;
                        subContrastExpressionList.add(eqStringExpression);
                    }
                    String subContrastExpression = String.join((CharSequence)OperatorType.AND.getToken(), subContrastExpressionList);
                    boolean subContrastBool = (Boolean)AviatorUtil.exec((String)subContrastExpression, billData);
                    log.info("==========\u79d1\u76ee\u8f6c\u5316\u6761\u4ef6(B)\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)subContrastExpression, (Object)subContrastBool);
                    if (!subContrastBool) continue;
                    originVoucherEntryVO.setSubjectId(subjectContrastDetailVO.getAccountSubjectId());
                    originVoucherEntryVO.setSubjectCode(subjectContrastDetailVO.getAccountSubjectCode());
                    originVoucherEntryVO.setSubjectName(subjectContrastDetailVO.getAccountSubjectName());
                    break;
                }
                this.analysisAuxiliary(originVoucherEntryVO, auxiliarySetMap, billData);
                entriesList.add(originVoucherEntryVO);
            }
        }
        log.info("==========\u89e3\u6790\u5206\u5f55\u3010\u79d1\u76ee\u5206\u7c7b\u7f16\u7801\uff1a" + subjectCategoryCode + "\u3011=====end======================================");
        return entriesList;
    }

    public void analysisAuxiliary(OriginVoucherEntryVO entryVO, Map<Long, BillAuxiliarySetVO> auxiliarySetMap, Map<String, Object> billData) {
        String[] split;
        List subjectAuxiliaryList;
        Long subjectId = entryVO.getSubjectId();
        SubjectEntity subjectEntity = (SubjectEntity)((Object)this.subjectService.getById(subjectId));
        String auxiliaryIds = subjectEntity.getAuxiliaryIds();
        if (StringUtils.isNotEmpty((CharSequence)auxiliaryIds) && CollectionUtils.isNotEmpty((Collection)(subjectAuxiliaryList = (List)this.auxiliaryService.listByIds(Arrays.asList(split = auxiliaryIds.split(",")))))) {
            LinkedList<OriginVoucherAuxiliaryVO> originVoucherAuxiliaryVOS = new LinkedList<OriginVoucherAuxiliaryVO>();
            LinkedList<String> auxiliaryInfoList = new LinkedList<String>();
            for (AuxiliaryEntity auxiliary : subjectAuxiliaryList) {
                Long _auxiliaryId = auxiliary.getId();
                BillAuxiliarySetVO billAuxiliarySetVO = auxiliarySetMap.get(_auxiliaryId);
                if (billAuxiliarySetVO == null) {
                    throw new BusinessException("\u4f1a\u8ba1\u79d1\u76ee\u3010\u7f16\u7801\uff1a" + subjectEntity.getSubjectCode() + "\u3011\u672a\u8bbe\u7f6e\u8f85\u52a9\u6838\u7b97\u9879\u3010\u7f16\u7801\uff1a" + auxiliary.getAuxiliaryCode() + "\uff0c\u540d\u79f0\uff1a" + auxiliary.getAuxiliaryName() + "\u3011\u5173\u8054\u5b57\u6bb5");
                }
                String columnExpression = billAuxiliarySetVO.getColumnExpression();
                String referCode = auxiliary.getReferCode();
                Object auxiliaryIdObj = AviatorUtil.exec((String)columnExpression, billData);
                JSONObject auxiliaryValJson = this.getReferCodeValue(String.valueOf(auxiliaryIdObj), referCode);
                OriginVoucherAuxiliaryVO originVoucherAuxiliaryVO = new OriginVoucherAuxiliaryVO();
                originVoucherAuxiliaryVO.setAuxiliaryId(_auxiliaryId);
                originVoucherAuxiliaryVO.setAuxiliaryCode(auxiliary.getAuxiliaryCode());
                originVoucherAuxiliaryVO.setAuxiliaryName(auxiliary.getAuxiliaryName());
                originVoucherAuxiliaryVO.setAuxiliaryValueId(auxiliaryValJson.getLong("id"));
                String codeVal = auxiliaryValJson.getString("code");
                String nameVal = auxiliaryValJson.getString("name");
                originVoucherAuxiliaryVO.setAuxiliaryValueCode(codeVal);
                originVoucherAuxiliaryVO.setAuxiliaryValueName(nameVal);
                auxiliaryInfoList.add(codeVal + "/" + nameVal);
                originVoucherAuxiliaryVO.setCompareAppId(auxiliary.getCompareAppId());
                originVoucherAuxiliaryVO.setAuxiliaryFsCode(auxiliary.getAuxiliaryCode());
                originVoucherAuxiliaryVO.setAuxiliaryFsValue(codeVal);
                originVoucherAuxiliaryVOS.add(originVoucherAuxiliaryVO);
            }
            entryVO.setAuxiliaryIds(subjectEntity.getAuxiliaryIds());
            entryVO.setAuxiliaryInfo(String.join((CharSequence)";", auxiliaryInfoList));
            entryVO.setOriginVoucherAuxiliaryVOList(originVoucherAuxiliaryVOS);
        }
    }

    public JSONObject getReferCodeValue(String value, String referCode) {
        try {
            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)value, (String)referCode);
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                return json;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, Object> transferFinanceVoucherByOriginVoucher(VoucherParams voucherParams) {
        String systemCode = voucherParams.getFinanceSystemCode();
        IFinanceVoucherService financeVoucherService = this.voucherTransferFactory.getFinanceVoucherService(systemCode);
        return financeVoucherService.convertToFinanceVoucherByOriginVoucher(voucherParams);
    }

    public AccbookVO getAccbook(String code) {
        return this.accbookService.getOneByCode(code);
    }

    public SubjectContrastVO getSubjectContrast(String subjectCategoryCode) {
        return this.subjectContrastService.getOneBySubjectCategoryCode(subjectCategoryCode);
    }

    public SubjectVO getSubjectById(Long subjectId) {
        SubjectEntity one = (SubjectEntity)((Object)this.subjectService.selectById(subjectId));
        return (SubjectVO)BeanMapper.map((Object)((Object)one), SubjectVO.class);
    }

    public SubjectVO getSubject(Long subjectChartId, String subjectCode) {
        LambdaQueryWrapper subjectEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        subjectEntityLambdaQueryWrapper.eq(SubjectEntity::getSubjectChartId, (Object)subjectChartId);
        subjectEntityLambdaQueryWrapper.eq(SubjectEntity::getSubjectCode, (Object)subjectCode);
        subjectEntityLambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        SubjectEntity one = (SubjectEntity)((Object)this.subjectService.getOne((Wrapper)subjectEntityLambdaQueryWrapper));
        if (one == null) {
            throw new BusinessException("\u4f1a\u8ba1\u79d1\u76ee\u3010\u7f16\u7801:" + subjectCode + "\uff0c\u79d1\u76ee\u8868ID\uff1a" + subjectChartId + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return (SubjectVO)BeanMapper.map((Object)((Object)one), SubjectVO.class);
    }

    public List<BillAuxiliarySetVO> getBillAuxiliarySet(String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAuxiliarySetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billAuxiliarySetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u8f85\u52a9\u6838\u7b97\u9879\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillAuxiliarySetVO.class);
    }

    public List<BillInfluenceSetVO> getBillInfluenceSet(String billTypeCode, List<Long> influenceIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillInfluenceSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.in(CollectionUtils.isNotEmpty(influenceIds), BillInfluenceSetEntity::getInfluenceId, influenceIds);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.billInfluenceSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u3010\u5f71\u54cd\u56e0\u7d20\u5173\u8054\u3011");
        }
        return BeanMapper.mapList((Iterable)list, BillInfluenceSetVO.class);
    }

    public List<BillAccbookSetVO> getBillAccbookSet(Long orgId, String billTypeCode, Map<String, Object> billData) {
        CommonResponse oneById = this.orgApi.getOneById(orgId);
        OrgVO orgVO = (OrgVO)oneById.getData();
        Object[] parentOrgIds = orgVO.getInnerCode().split("\\|");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BillAccbookSetEntity::getBillTypeCode, (Object)billTypeCode);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.in(BillAccbookSetEntity::getSourceOrgId, parentOrgIds);
        List list = this.billAccbookSetService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u672a\u8bbe\u7f6e\u3010\u8d26\u7c3f\u6620\u5c04\u8bbe\u7f6e\u3011, orgId:" + orgId);
        }
        HashSet<Object> accbookSetVOS = new HashSet<Object>();
        for (BillAccbookSetEntity billAccbookSetEntity : list) {
            Boolean conditionBool = Boolean.TRUE;
            String conditionExpression = billAccbookSetEntity.getConditionExpression();
            if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                conditionBool = (Boolean)this.executeOneExpression(conditionExpression, billData, billTypeCode, OperatorType.AND.getToken());
            }
            if (!conditionBool.booleanValue()) continue;
            accbookSetVOS.add(BeanMapper.map((Object)((Object)billAccbookSetEntity), BillAccbookSetVO.class));
        }
        if (CollectionUtils.isEmpty(accbookSetVOS)) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u3010\u8d26\u7c3f\u6620\u5c04\u8bbe\u7f6e\u3011, orgId:" + orgId);
        }
        return accbookSetVOS.stream().collect(Collectors.toList());
    }

    public static void main(String[] args) {
        String[] split;
        String expressionString = "'x:' + x";
        Expression expression = AviatorEvaluator.getInstance().compile(expressionString);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("x", 10);
        variables.put("y", "10");
        Object result1 = expression.execute(variables);
        System.out.println("Result 1: " + result1);
        variables.put("x", 20);
        variables.put("y", 8);
        Object result2 = expression.execute(variables);
        System.out.println("Result 2: " + result2);
        String voucherType = "01:\u8bb0\u8d26";
        for (String s : split = voucherType.split(":|\uff1a")) {
            System.out.println(s);
        }
    }
}

