package com.ejianc.business.accplat.config.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.config.bean.BillVoucherSetEntity;
import com.ejianc.business.accplat.config.service.IBillVoucherSetService;
import com.ejianc.business.accplat.config.vo.BillVoucherSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 会计平台设置-传凭证设置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billVoucherSet")
@Api(value = "会计平台设置-传凭证设置", tags = {"会计平台设置-传凭证设置"})
public class BillVoucherSetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillVoucherSetService service;

    @Autowired
    private IBillTypeApi billTypeApi;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillVoucherSetVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BillVoucherSetVO saveOrUpdateVO) {
        String customTransferServiceName = saveOrUpdateVO.getCustomTransferServiceName();
        if (StringUtils.isNotEmpty(customTransferServiceName)) {
            customTransferServiceName = customTransferServiceName.trim();
            saveOrUpdateVO.setCustomTransferServiceName(customTransferServiceName);
            LambdaQueryWrapper<BillVoucherSetEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BillVoucherSetEntity::getCustomTransferServiceName, customTransferServiceName);
            int count = service.count(wrapper);
            if (count > 0) {
                throw new BusinessException("该自定义转化服务" + customTransferServiceName.trim() + "已存在！");
            }
        } else {
            // 避免有空串存在
            saveOrUpdateVO.setCustomTransferServiceName(null);
        }

        BillVoucherSetEntity entity = BeanMapper.map(saveOrUpdateVO, BillVoucherSetEntity.class);
        service.saveOrUpdate(entity, false);
        BillVoucherSetVO vo = BeanMapper.map(entity, BillVoucherSetVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillVoucherSetVO> queryDetail(@RequestParam Long id) {
        BillVoucherSetEntity entity = service.selectById(id);
        BillVoucherSetVO vo = BeanMapper.map(entity, BillVoucherSetVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillVoucherSetVO> vos) {
        service.removeByIds(vos.stream().map(BillVoucherSetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillVoucherSetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (params.get("billTypeId") != null) {
            //没有凭证设置默认生成一条
            Object billTypeIdObj = params.get("billTypeId").getValue();
            Long billTypeId = Long.valueOf(billTypeIdObj.toString());
            LambdaQueryWrapper<BillVoucherSetEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(BillVoucherSetEntity::getBillTypeId, billTypeId);
            wrapper.eq(BillVoucherSetEntity::getTenantId, InvocationInfoProxy.getTenantid());
            int count = service.count(wrapper);
            if (count == 0) {
                BillTypeVO billTypeVO = this.getBillType(billTypeId);
                if (billTypeVO != null) {
                    BillVoucherSetEntity billVoucherSetEntity = new BillVoucherSetEntity();
                    billVoucherSetEntity.setBillTypeId(billTypeVO.getId());
                    billVoucherSetEntity.setBillTypeCode(billTypeVO.getBillCode());
                    billVoucherSetEntity.setBillTypeName(billTypeVO.getBillName());
                    billVoucherSetEntity.setTenantId(InvocationInfoProxy.getTenantid());
                    billVoucherSetEntity.setEnabled(0);
                    service.saveOrUpdate(billVoucherSetEntity);
                }
            }
        }

        IPage<BillVoucherSetEntity> page = service.queryPage(param, false);
        IPage<BillVoucherSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillVoucherSetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    private BillTypeVO getBillType(Long billTypeId) {
        CommonResponse<BillTypeVO> byId = billTypeApi.getById(billTypeId);
        return byId.isSuccess() ? byId.getData() : null;
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BillVoucherSetEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BIllVoucherSet-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBIllVoucherSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BillVoucherSetVO>> refBIllVoucherSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BillVoucherSetEntity> page = service.queryPage(param, false);
        IPage<BillVoucherSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillVoucherSetVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("启用/停用")
    @RequestMapping(value = "/enabled", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody BillVoucherSetVO billVoucherSetVO) {
        LambdaUpdateWrapper<BillVoucherSetEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BillVoucherSetEntity::getId, billVoucherSetVO.getId());
        wrapper.set(BillVoucherSetEntity::getEnabled, billVoucherSetVO.getEnabled());
        service.update(wrapper);
        return CommonResponse.success("启用/停用成功！");
    }

}
