package com.ejianc.business.voucher.transfer;

import com.ejianc.business.voucher.service.IFinanceVoucherService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @description: 凭证转化服务Factory
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Component
public class VoucherTransferFactory {

    @Autowired
    private Map<String, IFinanceVoucherService> financeVoucherServiceMap;

    @Autowired
    private Map<String, IVoucherTransferService> voucherTransferServiceMap;


    public IVoucherTransferService getVoucherTransferService(String serviceName) {
        IVoucherTransferService transferService = voucherTransferServiceMap.get(serviceName);
        if (transferService == null) {
            throw new BusinessException("未获取到自定义凭证转化服务类[" +serviceName+"]");
        }
        return transferService;
    }

    public IFinanceVoucherService getFinanceVoucherService(String systemCode) {
        String serviceName = systemCode + "VoucherService";
        IFinanceVoucherService financeVoucherService = financeVoucherServiceMap.get(serviceName);
        if (financeVoucherService == null) {
            throw new BusinessException("未获取到财务凭证服务类[" + serviceName + "]");
        }
        return financeVoucherService;
    }

}
