package com.ejianc.business.yonyou.base.datacenter.impl;

import com.ejianc.business.yonyou.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.yonyou.base.datacenter.pojo.GatewayAddressResponse;
import com.ejianc.business.yonyou.base.properties.OpenApiProperties;
import com.ejianc.business.yonyou.base.properties.UCFCoreProperties;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * @author nishch
 * @description: TODO
 * @date 2022/3/8
 */
public abstract class DataCenterUrlProviderImpl implements DataCenterUrlProvider {

    @Resource
    @Getter
    RestTemplate restTemplate;
    @Value("${ucf.mdd.active}")
    private String active;
    @Resource
    OpenApiProperties properties;
    @Resource
    UCFCoreProperties ucfCoreProperties;

    /**
     * 当前环境是否支持多数据中心
     * @return boolean
     */
    private boolean moreDataCenter(){
        String[] supportDataCenterEnv = new String[]{
            "production",
            "sandbox"
        };
        return Arrays.asList(supportDataCenterEnv).contains(active);
    }

    @Override
    public String buildBusinessUrl() {
        return useGatewayAddress().getGatewayUrl();
    }

    @Override
    public String buildTokenUrl() {
        return useGatewayAddress().getTokenUrl();
    }

    private GatewayAddressResponse.GatewayAddressDTO useGatewayAddress(){
        GatewayAddressResponse.GatewayAddressDTO gatewayAddressDTO= null;
        if(moreDataCenter()){
            gatewayAddressDTO = queryGatewayAddress();
        }else{
            gatewayAddressDTO = new GatewayAddressResponse.GatewayAddressDTO(properties.getGatewayAddressUrl(),properties.getGatewayAddressUrl());
        }
        return gatewayAddressDTO;
    }

    @Override
    public String queryTenantId() {
        return ucfCoreProperties.getDefaultTenantId();
    }
}
