/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.network.cryptor;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.yonyou.base.exception.BusinessException;
import com.ejianc.business.yonyou.base.network.cryptor.ByteGroup;
import com.ejianc.business.yonyou.base.network.cryptor.EncryptionHolder;
import com.ejianc.business.yonyou.base.network.cryptor.PKCS7Encoder;
import com.ejianc.business.yonyou.base.network.cryptor.SHA1;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISVRequestCrypto {
    private static final Logger log = LoggerFactory.getLogger(ISVRequestCrypto.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final byte[] aesKey;
    private final String appKey;
    private final String appSecret;

    public ISVRequestCrypto(String appKey, String appSecret) {
        String encodingAesKey = ISVRequestCrypto.buildAesKeyFromSecret(appSecret);
        if (encodingAesKey.length() != 43) {
            throw new BusinessException("invalid AES key");
        }
        this.aesKey = Base64.getDecoder().decode(encodingAesKey + "=");
        this.appSecret = appSecret;
        this.appKey = appKey;
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    public String getRandomStr() {
        return RandomStringUtils.random((int)16, (boolean)true, (boolean)true);
    }

    public String encrypt(String randomStr, String text) {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] suiteKeyBytes = this.appKey.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes).addBytes(networkBytesOrder).addBytes(textBytes).addBytes(suiteKeyBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        return this.doEncrypt(unencrypted);
    }

    private String doEncrypt(byte[] unencrypted) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new BusinessException("AES encrypt failed", e);
        }
    }

    public String decrypt(String cipherText) {
        String from_suiteKey;
        String message;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.getDecoder().decode(cipherText);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            log.error("AES \u89e3\u5bc6\u5931\u8d25, cause: {}", (Object)e.toString());
            throw new BusinessException("AES decrypt failed", e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            message = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_suiteKey = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            log.error("\u65e0\u6548\u7684 AES key");
            throw new BusinessException("invalid aes key", e);
        }
        if (!from_suiteKey.equals(this.appKey)) {
            log.error("suiteKey \u6821\u9a8c\u5931\u8d25");
            throw new BusinessException("suiteKey inconsistent exists,  from suite key: " + from_suiteKey + ", actual suite key: " + this.appKey);
        }
        return message;
    }

    public EncryptionHolder encrypt(String source, long timestamp, String nonce) {
        String encrypt = this.encrypt(this.getRandomStr(), source);
        String signature = SHA1.getSHA1(this.appSecret, String.valueOf(timestamp), nonce, encrypt);
        return new EncryptionHolder(signature, timestamp, nonce, encrypt);
    }

    public EncryptionHolder encrypt(String source) {
        return this.encrypt(source, System.currentTimeMillis(), this.getRandomStr());
    }

    public String decrypt(String signature, long timestamp, String nonce, String encrypt) {
        String targetSignature = SHA1.getSHA1(this.appSecret, String.valueOf(timestamp), nonce, encrypt);
        if (!targetSignature.equals(signature)) {
            throw new BusinessException("signature invalid, required: " + targetSignature + ", actual: " + targetSignature);
        }
        return this.decrypt(encrypt);
    }

    public String decryptFromJson(String json) {
        EncryptionHolder holder = this.jsonToHolder(json);
        return this.decrypt(holder.getMsgSignature(), holder.getTimestamp(), holder.getNonce(), holder.getEncrypt());
    }

    public String decrypt(EncryptionHolder holder) {
        return this.decrypt(holder.getMsgSignature(), holder.getTimestamp(), holder.getNonce(), holder.getEncrypt());
    }

    public EncryptionHolder jsonToHolder(String jsonStr) {
        return (EncryptionHolder)JSON.parseObject((String)jsonStr, EncryptionHolder.class);
    }

    public static String buildAesKeyFromSecret(String appSecret) {
        String encodingAesKey = appSecret;
        if ((encodingAesKey = encodingAesKey.replaceAll("-", "")).length() == 43) {
            return encodingAesKey;
        }
        if (encodingAesKey.length() > 43) {
            return encodingAesKey.substring(0, 43);
        }
        StringBuilder stringBuilder = new StringBuilder(encodingAesKey);
        while (stringBuilder.length() < 43) {
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }
}

