package com.ejianc.business.accplat.config.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 会计科目
 * 
 * @author generator
 * 
 */
 @TableName("ejc_accplat_subject")
public class SubjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="inner_code")
    private String innerCode; // 父ID集合
    @TableField(value="subject_chart_id")
    private Long subjectChartId; // 科目表ID
    @TableField(value="tree_index")
    private String treeIndex; // 序号
    @TableField(value="subject_code")
    private String subjectCode; // 科目编码
    @TableField(value="subject_name")
    private String subjectName; // 科目名称
    @TableField(value="full_name")
    private String fullName; // 全名
    @TableField(value="auxiliary_ids")
    private String auxiliaryIds; // 辅助核算项ids
    @TableField(value="auxiliary_names")
    private String auxiliaryNames; // 辅助核算项names
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="subjectAuxiliaryService", pidName = "subjectId")//此处有pid="xxx"，默认值pid="pid"
    private List<SubjectAuxiliaryEntity> subjectAuxiliaryList = new ArrayList<>(); // 会计科目-辅助核算项

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Long getSubjectChartId() {
        return subjectChartId;
    }

    public void setSubjectChartId(Long subjectChartId) {
        this.subjectChartId = subjectChartId;
    }
    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
    public String getAuxiliaryIds() {
        return auxiliaryIds;
    }

    public void setAuxiliaryIds(String auxiliaryIds) {
        this.auxiliaryIds = auxiliaryIds;
    }
    public String getAuxiliaryNames() {
        return auxiliaryNames;
    }

    public void setAuxiliaryNames(String auxiliaryNames) {
        this.auxiliaryNames = auxiliaryNames;
    }
    
    public List<SubjectAuxiliaryEntity> getSubjectAuxiliaryList() {
        return subjectAuxiliaryList;
    }

    public void setSubjectAuxiliaryList(List<SubjectAuxiliaryEntity> subjectAuxiliaryList) {
        this.subjectAuxiliaryList = subjectAuxiliaryList;
    }
}
