package com.ejianc.business.accplat.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.SubjectAuxiliaryEntity;
import com.ejianc.business.accplat.config.bean.SubjectEntity;
import com.ejianc.business.accplat.config.mapper.SubjectMapper;
import com.ejianc.business.accplat.config.service.ISubjectAuxiliaryService;
import com.ejianc.business.accplat.config.service.ISubjectService;
import com.ejianc.business.accplat.config.vo.SubjectAuxiliaryVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 会计科目
 *
 * @author generator
 *
 */
@Service("subjectService")
public class SubjectServiceImpl extends BaseServiceImpl<SubjectMapper, SubjectEntity> implements ISubjectService {


    @Autowired
    private ISubjectAuxiliaryService subjectAuxiliaryService;

    @Override
    public String saveImport(List<SubjectVO> subjectVOS) {
        if (CollectionUtils.isNotEmpty(subjectVOS)) {
            List<SubjectAuxiliaryVO> auxiliaryVOList = new ArrayList<>();
            for (SubjectVO subjectVO : subjectVOS) {
                List<SubjectAuxiliaryVO> subjectAuxiliaryList = subjectVO.getSubjectAuxiliaryList();
                if (CollectionUtils.isNotEmpty(subjectAuxiliaryList)){
                    auxiliaryVOList.addAll(subjectAuxiliaryList);
                }
            }
            this.saveOrUpdateBatch(BeanMapper.mapList(subjectVOS, SubjectEntity.class));
            List<Long> subjectIds = subjectVOS.stream().map(SubjectVO::getId).collect(Collectors.toList());

            LambdaQueryWrapper<SubjectAuxiliaryEntity> subjectAuxiliaryEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            subjectAuxiliaryEntityLambdaQueryWrapper.in(SubjectAuxiliaryEntity::getSubjectId, subjectIds);
            if (CollectionUtils.isNotEmpty(auxiliaryVOList)) {
                List<SubjectAuxiliaryEntity> subjectAuxiliaryEntities = BeanMapper.mapList(auxiliaryVOList, SubjectAuxiliaryEntity.class);
                subjectAuxiliaryService.saveOrUpdateBatch(subjectAuxiliaryEntities);
                List<Long> subjectAuxiliaryIds = subjectAuxiliaryEntities.stream().map(SubjectAuxiliaryEntity::getId).collect(Collectors.toList());
                subjectAuxiliaryEntityLambdaQueryWrapper.notIn(SubjectAuxiliaryEntity::getId, subjectAuxiliaryIds);
            }
            subjectAuxiliaryService.remove(subjectAuxiliaryEntityLambdaQueryWrapper);
        }

        return "导入成功！";
    }
}
