package com.ejianc.business.custransfer.sjyg;

import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.business.accplat.config.vo.SubjectContrastVO;
import com.ejianc.business.accplat.config.vo.SubjectVO;
import com.ejianc.business.accplat.consts.AccplatConsts;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateDetailVO;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.business.voucher.service.BaseVoucherBusinessService;
import com.ejianc.business.voucher.transfer.IVoucherTransferService;
import com.ejianc.business.voucher.vo.VoucherParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @description: 凭证自定义转化-分包过程结算
 * @author songlx
 * @date 2023/11/28
 * @version 1.0
 */
@Slf4j
@Service("SJYGSubSettleVoucherCusTransferService")
public class SJYGSubSettleVoucherCusTransferService extends BaseVoucherBusinessService implements IVoucherTransferService {


    // 制单人ID取值字段
    private static final String MARKER_COLUMN = null;

    // 业务日期取值字段
    private static final String BUSINESS_DATE_COLUMN = "settleDate";

    // 来源单据URL-PC
    private static final String SRC_BILL_PC_URL = "srcBillPcUrl";

    // 来源单据主组织字段名
    private static final String SRC_BILL_ORG_COLUMN = "orgId";

    // 账簿编码
    private static final String ACCBOOK_CODE = "S03";

    // 凭证类型ex01:记账
    private static final String VOUCHER_TYPE = "PRE001:记";

    // 汇率类型
    private static final String RATE_TYPE = "HLTX01_SYS";

    // 币别
    private static final String CURRENCY_CODE = "PRE001";


    // 借方 固定科目编码
    private static final String SUBJECT_CODE = "1002.01";

    private static final String DESCRIPTION_EXPRESSION = "projectName + '_' + billTypeName";

    // 金额字段
    private static final String MNY_EXPRESSION = "settleTaxMny";


    // 贷方 科目分类编码
    private static final String SUBJECT_CONTRAST_CODE = "subSettle03";


    private static final String DESCRIPTION_EXPRESSION_2 = "projectName + '_' + settleDetailList.code";

    // 金额字段
    private static final String MNY_EXPRESSION_2 = "settleDetailList.settleMny";


    /**
     * @description: 将单据参数转化成原始凭证/财务凭证参数
     * @return
     * @author songlx
     * @date: 2023/11/29
     * @param voucherParams
     */
    @Override
    public void transfer(VoucherParams voucherParams) {
        VoucherTemplateVO voucherTemplateVO = new VoucherTemplateVO();
        // TODO 构建虚拟凭证模板vo
        voucherTemplateVO.setMarkerColumn(MARKER_COLUMN);
        voucherTemplateVO.setBusinessDateColumn(BUSINESS_DATE_COLUMN);
        voucherTemplateVO.setSrcBillPcUrl(SRC_BILL_PC_URL);
        voucherTemplateVO.setSrcBillOrgColumn(SRC_BILL_ORG_COLUMN);
        voucherTemplateVO.setVoucherType(VOUCHER_TYPE);
        voucherTemplateVO.setRateType(RATE_TYPE);
        voucherTemplateVO.setCurrencyCode(CURRENCY_CODE);

        AccbookVO accbook = this.getAccbook(ACCBOOK_CODE);
        voucherTemplateVO.setAccbookId(accbook.getId());
        voucherTemplateVO.setAccbookCode(accbook.getCode());
        voucherTemplateVO.setAccbookName(accbook.getName());

        voucherTemplateVO.setMarkerColumn("employeeId");

        List<VoucherTemplateDetailVO> templateDetailVOList = new ArrayList<>();
        // 借方分录 固定科目
        VoucherTemplateDetailVO debitDetailVO = new VoucherTemplateDetailVO();
        debitDetailVO.setDirectionFlag(AccplatConsts.DirectionFlag.DEBIT);
        debitDetailVO.setSubjectRuleFlag(AccplatConsts.SubjectRule.SUBJECT);
        SubjectVO subjectVO = this.getSubject(accbook.getSubjectChartId(), SUBJECT_CODE);
        debitDetailVO.setSubjectRuleId(subjectVO.getId());
        debitDetailVO.setSubjectRuleCode(subjectVO.getSubjectCode());
        debitDetailVO.setSubjectRuleName(subjectVO.getSubjectName());
        // 放摘要表达式
        debitDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION);
        debitDetailVO.setMnyExpression(MNY_EXPRESSION);
        templateDetailVOList.add(debitDetailVO);

        // 贷方分录 科目分类转化
        VoucherTemplateDetailVO creditDetailVO = new VoucherTemplateDetailVO();
        creditDetailVO.setDirectionFlag(AccplatConsts.DirectionFlag.CREDIT);
        creditDetailVO.setSubjectRuleFlag(AccplatConsts.SubjectRule.SUBJECT_CONTRAST);
        SubjectContrastVO subjectContrast = this.getSubjectContrast(SUBJECT_CONTRAST_CODE);
        creditDetailVO.setSubjectRuleId(subjectContrast.getId());
        creditDetailVO.setSubjectRuleCode(subjectContrast.getSubjectCategoryCode());
        creditDetailVO.setSubjectRuleName(subjectContrast.getSubjectCategoryName());
        // 放摘要字符串
        creditDetailVO.setDescriptionExpression(DESCRIPTION_EXPRESSION_2);
        creditDetailVO.setMnyExpression(MNY_EXPRESSION_2);
        templateDetailVOList.add(creditDetailVO);

        voucherTemplateVO.setVoucherTemplateDetailList(templateDetailVOList);

        OriginVoucherVO originVoucherVO = transferOriginVoucherByVoucherTemplate(voucherParams, voucherTemplateVO);
        voucherParams.setOriginVoucherVOList(Arrays.asList(originVoucherVO));
        Map<String, Object> financeVoucher = transferFinanceVoucherByOriginVoucher(voucherParams);
        voucherParams.setFinanceVoucher(financeVoucher);
    }


}
