package com.ejianc.business.voucher.api;

import com.ejianc.business.accplat.config.vo.BillAccbookSetVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.consts.VoucherBusinessConsts;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.service.VoucherBusinessService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @description: 凭证VoucherApi
 **/
@Slf4j
@RestController
@RequestMapping(value = "/api/voucherApi/")
@Api(value = "凭证VoucherApi", tags = {"凭证VoucherApi"})
public class VoucherApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private VoucherBusinessService voucherBusinessService;

    @Autowired
    private IBillTypeApi billTypeApi;


    /**
     * @description: 凭证处理
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "handleVoucher")
    public CommonResponse<VoucherInfo> handleVoucher(@RequestBody VoucherParams voucherParams, @RequestParam("voucherOptFlag") String voucherOptFlag) {
        Map<String, Object> billData = voucherParams.getBillData();
        Object billVoucherInfo = billData.get("voucherInfo");
        Object billVoucherFlag = billData.get("voucherFlag");
        Integer voucherFlag = billVoucherFlag == null ? VoucherFlag.NO_NEED : Integer.valueOf(billVoucherFlag.toString());
        CommonResponse response = CommonResponse.success();
        if (VoucherFlag.SUCCESS.equals(voucherFlag)) {
            VoucherInfo voucherInfo = DataConvertUtil.stringToObj(String.valueOf(billVoucherInfo), VoucherInfo.class);
            response = this.del(voucherInfo);
            logger.info("{}删除凭证结果：{}", voucherOptFlag, DataConvertUtil.toPrettyFormat(response));
        }
        if (VoucherOptFlag.DEL.equals(voucherOptFlag)) {
            return response;
        }
        if (response.isSuccess()) {
            response = this.save(voucherParams);
        }
        logger.info("{}保存凭证结果：{}", voucherOptFlag, DataConvertUtil.toPrettyFormat(response));
        return response;
    }

    /**
     * @description: 保存凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "save")
    public CommonResponse<VoucherInfo> save(@RequestBody VoucherParams voucherParams) {
        log.info(" ============================= ");
        log.info(" 业务参数(构建前)voucherParams:" + DataConvertUtil.objToString(voucherParams));
        log.info(" ============================= ");
        // 传入参数校验
        String billTypeCode = voucherParams.getBillTypeCode();
        Long orgId = voucherParams.getOrgId();
        Map<String, Object> billData = voucherParams.getBillData();
        Assert.notNull(billTypeCode, "单据类型编码billTypeCode不能为空！");
        Assert.notNull(billData, "单据主组织orgId不能为空！");
        Assert.notNull(billData, "单据数据billData不能为空！");
        CommonResponse<BillTypeVO> byCodeRes = billTypeApi.getByCode(billTypeCode);
        if (!byCodeRes.isSuccess()) {
            throw new BusinessException("未获取到单据类型【编码：" + billTypeCode + "】");
        }
        voucherParams.setBillTypeVO(byCodeRes.getData());

        // 查询是否需要传凭证
        Boolean isGenerateVoucher = voucherBusinessService.isGenerateVoucher(voucherParams);
        if (!isGenerateVoucher) {
            VoucherInfo noNeedVoucherInfo = VoucherInfo.getNoNeedVoucherInfo(voucherParams.getMsgInfo());
            return CommonResponse.success("无需传凭证：" + voucherParams.getMsgInfo(), noNeedVoucherInfo);
        }

        // 获取账簿设置，有可能需要传到多个账簿，生成多个凭证
        List<BillAccbookSetVO> billAccbookSetVOList = voucherBusinessService.getBillAccbookSet(orgId, billTypeCode, billData);
        voucherParams.setBillAccbookSetVOList(billAccbookSetVOList);

        // 根据tenantid 查询该租户用的什么财务系统
        Long tenantid = InvocationInfoProxy.getTenantid();
        String financeSystemCode = VoucherBusinessConsts.KINGDEE_GALAXY;
        voucherParams.setFinanceSystemCode(financeSystemCode);

        // 保存凭证
        CommonResponse<VoucherInfo> response = voucherBusinessService.save(voucherParams);
        if (response.getData() != null) {
            VoucherInfo data = response.getData();
            data.setFinanceSystemCode(voucherParams.getFinanceSystemCode());
            data.setBillTypeCode(billTypeCode);
            data.setBillId(voucherParams.getBillId());
        }
        return response;
    }


    /**
     * @description: 查询凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "get")
    public CommonResponse<List<OriginVoucherVO>> get(@RequestBody VoucherInfo voucherInfo) {
        return voucherBusinessService.get(voucherInfo);
    }

    /**
     * @description: 查询单个凭证
     *
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "getOne")
    public CommonResponse<OriginVoucherVO> getOne(@RequestBody VoucherApiQueryVO voucherApiQueryVO) {
        String financeSystemCode = voucherApiQueryVO.getFinanceSystemCode();
        Assert.notNull(financeSystemCode, "财务系统标识financeSystemCode不能为空！");
        return voucherBusinessService.getOne(voucherApiQueryVO);
    }


    /**
     * @description: 凭证删除
     *
     * @author songlx
     * @date: 2023/11/22
     */
    @PostMapping(value = "del")
    public CommonResponse<String> del(@RequestBody VoucherInfo voucherInfo) {
        return voucherBusinessService.del(voucherInfo);
    }

}
