package com.ejianc.business.voucher.service;

import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;


/**
 * @description: 第三方财务凭证接口
 *
 * @author songlx
 * @date: 2023/11/29
 */
public interface IFinanceVoucherService {

    /**
     * @description: 保存财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<VoucherInfo> save(VoucherParams voucherParams);


    /**
     * @description: 保存多个财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<VoucherInfo> batchSave(VoucherParams voucherParams);


    /**
     * @description: 根据voucherInfo查询财务凭证 单个或者多个
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<List<OriginVoucherVO>> get(VoucherInfo voucherInfo);


    /**
     * @description: 查询单个凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse<OriginVoucherVO> getOne(VoucherApiQueryVO voucherApiQueryVO);

    /**
     * @description: 删除财务凭证
     * @author songlx
     * @date: 2023/11/29
     */
    CommonResponse del(VoucherInfo voucherInfo);


    /**
     * @description: 依据原始凭证转化财务凭证参数
     * @author songlx
     * @date: 2023/11/29
     */
    Map<String, Object> convertToFinanceVoucherByOriginVoucher(VoucherParams voucherParams);


}
