package com.ejianc.business.yonyou.base.context;

import java.util.Map;

/**
 * @author nishch
 * @description: TODO
 * @date 2023/3/7
 */
public class InvocationInfoProxy {

    private static final ThreadLocal<InvocationInfo> threadLocal = new ThreadLocal<InvocationInfo>() {
        protected InvocationInfo initialValue() {
            return new InvocationInfo();
        }
    };

    public static String getTenantId() {
        return threadLocal.get().tenantId;
    }

    public static void setTenantId(String tenantId) {
        threadLocal.get().tenantId = tenantId;
    }


    public static Map<String, String> getParameters() {
        return threadLocal.get().parameters;
    }

    public static String getParameter(String parameter) {
        return threadLocal.get().parameters.get(parameter);
    }

    public static String setParameter(String parameter, String value) {
        return threadLocal.get().parameters.put(parameter, value);
    }
}
