package com.ejianc.business.accplat.originvoucher.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 原始凭证
 *
 * @author generator
 *
 */
@TableName("ejc_accplat_origin_voucher")
public class OriginVoucherEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "src_bill_type_id")
    private Long srcBillTypeId; // 来源单据类型ID
    @TableField(value = "src_bill_type_code")
    private String srcBillTypeCode; // 来源单据类型编码
    @TableField(value = "src_bill_type_name")
    private String srcBillTypeName; // 来源单据类型名称
    @TableField(value = "src_system_code")
    private String srcSystemCode; // 来源系统编码
    @TableField(value = "src_system_name")
    private String srcSystemName; // 来源系统名称
    @TableField(value = "src_bill_id")
    private Long srcBillId; // 来源业务单据ID
    @TableField(value = "src_bill_code")
    private String srcBillCode; // 来源业务单据编码
    @TableField(value = "src_bill_pc_url")
    private String srcBillPcUrl; // 来源业务单据URL-PC
    @TableField(value = "src_bill_org_id")
    private Long srcBillOrgId; // 来源业务单据主组织ID
    @TableField(value = "src_bill_org_code")
    private String srcBillOrgCode; // 来源业务单据主组织编码 
    @TableField(value = "src_bill_org_name")
    private String srcBillOrgName; // 来源业务单据主组织名称
    @TableField(value = "voucher_create_time")
    private Date voucherCreateTime; // 凭证生成时间
    @TableField(value = "voucher_date")
    private Date voucherDate; // 凭证日期
    @TableField(value = "business_date")
    private Date businessDate; // 业务日期
    @TableField(value = "marker_id")
    private Long markerId; // 制单人ID
    @TableField(value = "marker_code")
    private String markerCode; // 制单人编码
    @TableField(value = "marker_name")
    private String markerName; // 制单人名称
    @TableField(value = "voucher_code")
    private String voucherCode; // 原始凭证展示编号
    @TableField(value = "voucher_type_code")
    private String voucherTypeCode; // 凭证类型编码
    @TableField(value = "voucher_type_name")
    private String voucherTypeName; // 凭证类型名称
    @TableField(value = "debit_total_mny")
    private BigDecimal debitTotalMny; // 借方金额合计
    @TableField(value = "credit_total_mny")
    private BigDecimal creditTotalMny; // 贷方金额合计
    @TableField(value = "description")
    private String description; // 摘要
    @TableField(value = "accbook_id")
    private Long accbookId; // 账簿ID
    @TableField(value = "accbook_code")
    private String accbookCode; // 账簿编号
    @TableField(value = "accbook_name")
    private String accbookName; // 账簿名称
    @TableField(value = "finance_voucher_flag")
    private Integer financeVoucherFlag; // 生成财务凭证状态
    @TableField(value = "finance_voucher_id")
    private String financeVoucherId; // 财务凭证ID
    @TableField(value = "finance_voucher_code")
    private String financeVoucherCode; // 财务凭证号
    @TableField(value = "finance_voucher_period")
    private String financeVoucherPeriod; // 财务凭证期间
    @TableField(value = "finance_voucher_info")
    private String financeVoucherInfo; // 生成财务凭证回参
    @TableField(value = "finance_system_code")
    private String financeSystemCode; // 目标财务系统标识
    @TableField(value = "voucher_template_id")
    private Long voucherTemplateId; // 转换模版ID


    @TableField(exist = false)
    @SubEntity(serviceName = "originVoucherEntryService", pidName = "originVoucherId")
    private List<OriginVoucherEntryEntity> originVoucherEntryList = new ArrayList<>(); // 原始凭证分录

    @TableField(exist = false)
    @SubEntity(serviceName = "originVoucherAuxiliaryService", pidName = "originVoucherId")
    private List<OriginVoucherAuxiliaryEntity> originVoucherAuxiliaryList = new ArrayList<>(); // 原始凭证分录核算项

    public Long getSrcBillTypeId() {
        return srcBillTypeId;
    }

    public void setSrcBillTypeId(Long srcBillTypeId) {
        this.srcBillTypeId = srcBillTypeId;
    }

    public String getSrcBillTypeCode() {
        return srcBillTypeCode;
    }

    public void setSrcBillTypeCode(String srcBillTypeCode) {
        this.srcBillTypeCode = srcBillTypeCode;
    }

    public String getSrcBillTypeName() {
        return srcBillTypeName;
    }

    public void setSrcBillTypeName(String srcBillTypeName) {
        this.srcBillTypeName = srcBillTypeName;
    }

    public String getSrcSystemCode() {
        return srcSystemCode;
    }

    public void setSrcSystemCode(String srcSystemCode) {
        this.srcSystemCode = srcSystemCode;
    }

    public String getSrcSystemName() {
        return srcSystemName;
    }

    public void setSrcSystemName(String srcSystemName) {
        this.srcSystemName = srcSystemName;
    }

    public Long getSrcBillId() {
        return srcBillId;
    }

    public void setSrcBillId(Long srcBillId) {
        this.srcBillId = srcBillId;
    }

    public String getSrcBillCode() {
        return srcBillCode;
    }

    public void setSrcBillCode(String srcBillCode) {
        this.srcBillCode = srcBillCode;
    }

    public String getSrcBillPcUrl() {
        return srcBillPcUrl;
    }

    public void setSrcBillPcUrl(String srcBillPcUrl) {
        this.srcBillPcUrl = srcBillPcUrl;
    }

    public Long getSrcBillOrgId() {
        return srcBillOrgId;
    }

    public void setSrcBillOrgId(Long srcBillOrgId) {
        this.srcBillOrgId = srcBillOrgId;
    }

    public String getSrcBillOrgCode() {
        return srcBillOrgCode;
    }

    public void setSrcBillOrgCode(String srcBillOrgCode) {
        this.srcBillOrgCode = srcBillOrgCode;
    }

    public String getSrcBillOrgName() {
        return srcBillOrgName;
    }

    public void setSrcBillOrgName(String srcBillOrgName) {
        this.srcBillOrgName = srcBillOrgName;
    }

    public Date getVoucherCreateTime() {
        return voucherCreateTime;
    }

    public void setVoucherCreateTime(Date voucherCreateTime) {
        this.voucherCreateTime = voucherCreateTime;
    }

    public Date getVoucherDate() {
        return voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    public Long getMarkerId() {
        return markerId;
    }

    public void setMarkerId(Long markerId) {
        this.markerId = markerId;
    }

    public String getMarkerCode() {
        return markerCode;
    }

    public void setMarkerCode(String markerCode) {
        this.markerCode = markerCode;
    }

    public String getMarkerName() {
        return markerName;
    }

    public void setMarkerName(String markerName) {
        this.markerName = markerName;
    }

    public String getVoucherCode() {
        return voucherCode;
    }

    public void setVoucherCode(String voucherCode) {
        this.voucherCode = voucherCode;
    }

    public String getVoucherTypeCode() {
        return voucherTypeCode;
    }

    public void setVoucherTypeCode(String voucherTypeCode) {
        this.voucherTypeCode = voucherTypeCode;
    }

    public String getVoucherTypeName() {
        return voucherTypeName;
    }

    public void setVoucherTypeName(String voucherTypeName) {
        this.voucherTypeName = voucherTypeName;
    }

    public BigDecimal getDebitTotalMny() {
        return debitTotalMny;
    }

    public void setDebitTotalMny(BigDecimal debitTotalMny) {
        this.debitTotalMny = debitTotalMny;
    }

    public BigDecimal getCreditTotalMny() {
        return creditTotalMny;
    }

    public void setCreditTotalMny(BigDecimal creditTotalMny) {
        this.creditTotalMny = creditTotalMny;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getAccbookId() {
        return accbookId;
    }

    public void setAccbookId(Long accbookId) {
        this.accbookId = accbookId;
    }

    public String getAccbookCode() {
        return accbookCode;
    }

    public void setAccbookCode(String accbookCode) {
        this.accbookCode = accbookCode;
    }

    public String getAccbookName() {
        return accbookName;
    }

    public void setAccbookName(String accbookName) {
        this.accbookName = accbookName;
    }

    public Integer getFinanceVoucherFlag() {
        return financeVoucherFlag;
    }

    public void setFinanceVoucherFlag(Integer financeVoucherFlag) {
        this.financeVoucherFlag = financeVoucherFlag;
    }

    public String getFinanceVoucherId() {
        return financeVoucherId;
    }

    public void setFinanceVoucherId(String financeVoucherId) {
        this.financeVoucherId = financeVoucherId;
    }

    public String getFinanceVoucherCode() {
        return financeVoucherCode;
    }

    public void setFinanceVoucherCode(String financeVoucherCode) {
        this.financeVoucherCode = financeVoucherCode;
    }

    public String getFinanceVoucherPeriod() {
        return financeVoucherPeriod;
    }

    public void setFinanceVoucherPeriod(String financeVoucherPeriod) {
        this.financeVoucherPeriod = financeVoucherPeriod;
    }

    public String getFinanceVoucherInfo() {
        return financeVoucherInfo;
    }

    public void setFinanceVoucherInfo(String financeVoucherInfo) {
        this.financeVoucherInfo = financeVoucherInfo;
    }

    public String getFinanceSystemCode() {
        return financeSystemCode;
    }

    public void setFinanceSystemCode(String financeSystemCode) {
        this.financeSystemCode = financeSystemCode;
    }

    public Long getVoucherTemplateId() {
        return voucherTemplateId;
    }

    public void setVoucherTemplateId(Long voucherTemplateId) {
        this.voucherTemplateId = voucherTemplateId;
    }

    public List<OriginVoucherEntryEntity> getOriginVoucherEntryList() {
        return originVoucherEntryList;
    }

    public void setOriginVoucherEntryList(List<OriginVoucherEntryEntity> originVoucherEntryList) {
        this.originVoucherEntryList = originVoucherEntryList;
    }

    public List<OriginVoucherAuxiliaryEntity> getOriginVoucherAuxiliaryList() {
        return originVoucherAuxiliaryList;
    }

    public void setOriginVoucherAuxiliaryList(List<OriginVoucherAuxiliaryEntity> originVoucherAuxiliaryList) {
        this.originVoucherAuxiliaryList = originVoucherAuxiliaryList;
    }
}
